/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.util;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.exec.NpmExecutable;
import org.netbeans.modules.javascript.nodejs.ui.Notifications;

public final class GraalVmUtils {
    private static final boolean RUNNING_ON;
    private static final AtomicBoolean OPTIONS_DETECTED;

    private GraalVmUtils() {
    }

    public static boolean isRunningOn() {
        return RUNNING_ON;
    }

    public static void detectOptions() {
        if (!GraalVmUtils.isRunningOn()) {
            return;
        }
        if (!OPTIONS_DETECTED.compareAndSet(false, true)) {
            return;
        }
        if (!GraalVmUtils.properPathsSet()) {
            Notifications.notifyGraalVmDetected();
        }
    }

    public static boolean properPathsSet() {
        NodeExecutable node = NodeExecutable.getDefault(null, false);
        if (node == null || !node.getExecutable().equals(GraalVmUtils.getNode())) {
            return false;
        }
        NpmExecutable npm = NpmExecutable.getDefault(null, false);
        return npm != null && npm.getExecutable().equals(GraalVmUtils.getNpm(false));
    }

    public static String getNode() {
        return GraalVmUtils.getJavaHomeBinFile("node").getAbsolutePath();
    }

    public static String getNpm(boolean withParams) {
        StringBuilder npm = new StringBuilder(50);
        npm.append(GraalVmUtils.getJavaHomeBinFile("npm").getAbsolutePath());
        if (withParams) {
            npm.append(" --force");
        }
        return npm.toString();
    }

    private static File getJavaHomeBinFile(String filename) {
        return new File(new File(System.getProperty("java.home"), "bin"), filename);
    }

    static {
        OPTIONS_DETECTED = new AtomicBoolean(false);
        RUNNING_ON = new File(GraalVmUtils.getNode()).isFile();
    }
}

