/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Lookup;

public final class RemoteSyncSupport {
    private RemoteSyncSupport() {
    }

    public static RemoteSyncWorker createSyncWorker(Lookup.Provider project, PrintWriter out, PrintWriter err) {
        RemoteSyncFactory syncFactory;
        RemoteProject remoteProject;
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (syncFactory = remoteProject.getSyncFactory()) != null) {
            return syncFactory.createNew(project, out, err);
        }
        return null;
    }

    public static PathMap getPathMap(ExecutionEnvironment env, Lookup.Provider project) {
        PathMap pathMap = null;
        if (project != null) {
            pathMap = RemoteSyncSupport.getPathMap(project);
        }
        if (pathMap == null) {
            pathMap = HostInfoProvider.getMapper(env);
        }
        return pathMap;
    }

    public static PathMap getPathMap(Lookup.Provider project) {
        RemoteProject remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
        if (remoteProject == null) {
            return null;
        }
        PathMap pathMap = null;
        ExecutionEnvironment execEnv = remoteProject.getDevelopmentHost();
        if (execEnv == null) {
            return null;
        }
        RemoteSyncFactory syncFactory = remoteProject.getSyncFactory();
        if (syncFactory != null) {
            pathMap = syncFactory.getPathMap(execEnv);
        }
        if (pathMap == null) {
            pathMap = HostInfoProvider.getMapper(execEnv);
        }
        return pathMap;
    }

    public static ExecutionEnvironment getRemoteFileSystemHost(Lookup.Provider project) {
        RemoteProject remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
        return remoteProject == null ? ExecutionEnvironmentFactory.getLocal() : remoteProject.getSourceFileSystemHost();
    }

    public static Worker createUploader(Lookup.Provider project, ExecutionEnvironment execEnv) throws IOException {
        RemoteSyncService rss = (RemoteSyncService)Lookup.getDefault().lookup(RemoteSyncService.class);
        return rss == null ? null : rss.getUploader(project, execEnv);
    }

    public static interface Worker {
        public void process(File var1, Writer var2) throws PathMapperException, InterruptedException, ExecutionException, IOException;

        public void close();
    }

    public static class PathMapperException
    extends Exception {
        private final File file;

        public PathMapperException(File file) {
            super("Could not find remote path for " + file.getAbsolutePath());
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

