/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfAbbriviationTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfAbbriviationTableEntry;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

public class DwarfAbbriviationTableSection
extends ElfSection {
    private final HashMap<Long, DwarfAbbriviationTable> tables = new HashMap();

    public DwarfAbbriviationTableSection(ElfReader reader, int sectionIdx) {
        super(reader, sectionIdx);
    }

    public void dump(PrintStream out) {
        super.dump(out);
        for (DwarfAbbriviationTable table : this.tables.values()) {
            table.dump(out);
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream st = new ByteArrayOutputStream();
            PrintStream out = new PrintStream((OutputStream)st, false, "UTF-8");
            this.dump(out);
            return st.toString("UTF-8");
        }
        catch (IOException ex) {
            return "";
        }
    }

    public DwarfAbbriviationTable getAbbriviationTable(long offset) throws IOException {
        Long lOffset = offset;
        DwarfAbbriviationTable table = this.tables.get(lOffset);
        if (table == null) {
            table = this.readTable(offset);
            this.tables.put(lOffset, table);
        }
        return table;
    }

    private DwarfAbbriviationTable readTable(long offset) throws IOException {
        long currPos = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset() + offset);
        long idx = -1L;
        ArrayList<DwarfAbbriviationTableEntry> entries = new ArrayList<DwarfAbbriviationTableEntry>();
        DwarfAbbriviationTable table = new DwarfAbbriviationTable(offset);
        while (idx != 0L && (idx = (long)this.reader.readUnsignedLEB128()) != 0L) {
            long aTag = this.reader.readUnsignedLEB128();
            boolean hasChildren = this.reader.readBoolean();
            DwarfAbbriviationTableEntry entry = new DwarfAbbriviationTableEntry(idx, aTag, hasChildren);
            int name = -1;
            int form = -1;
            while (name != 0 && form != 0) {
                name = this.reader.readUnsignedLEB128();
                form = this.reader.readUnsignedLEB128();
                entry.addAttribute(name, form);
            }
            entries.add(entry);
        }
        table.setEntries(entries);
        this.reader.seek(currPos);
        return table;
    }
}

