/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.analysis.api.options;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.cnd.analysis.api.options.HintsPanel;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class HintsPanelLogic
implements MouseListener,
KeyListener,
TreeSelectionListener,
ChangeListener,
ActionListener {
    private static final Map<Severity, Integer> severity2index = new EnumMap<Severity, Integer>(Severity.class);
    private static final String DESCRIPTION_HEADER = "<html><head></head><body>";
    private static final String DESCRIPTION_FOOTER = "</body></html>";
    private JTree errorTree;
    private HintsPanel.ExtendedModel extendedModel;
    private JLabel severityLabel;
    private JComboBox severityComboBox;
    private JPanel customizerPanel;
    private JEditorPane descriptionTextArea;
    private final DefaultComboBoxModel defModel = new DefaultComboBoxModel();
    private final String defLabel = NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label");
    private static final int ROOT = 0;
    private static final int PROVIDER = 1;
    private static final int AUDIT = 2;
    private static final int OPTION = 3;

    HintsPanelLogic() {
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsError"));
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsWarning"));
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_WarningOnCurrentLine"));
    }

    void connect(JTree errorTree, HintsPanel.ExtendedModel model, JLabel severityLabel, JComboBox severityComboBox, JPanel customizerPanel, JEditorPane descriptionTextArea) {
        this.errorTree = errorTree;
        this.extendedModel = model;
        this.severityLabel = severityLabel;
        this.severityComboBox = severityComboBox;
        this.customizerPanel = customizerPanel;
        this.descriptionTextArea = descriptionTextArea;
        this.valueChanged(null);
        errorTree.addKeyListener(this);
        errorTree.addMouseListener(this);
        errorTree.getSelectionModel().addTreeSelectionListener(this);
        severityComboBox.addActionListener(this);
    }

    void disconnect() {
        this.errorTree.removeKeyListener(this);
        this.errorTree.removeMouseListener(this);
        this.errorTree.getSelectionModel().removeTreeSelectionListener(this);
        this.severityComboBox.removeActionListener(this);
        this.componentsSetEnabled(false, 0);
    }

    synchronized void applyChanges() {
        this.extendedModel.store();
    }

    synchronized void cancel() {
        this.extendedModel.cancel();
    }

    boolean isChanged() {
        return this.extendedModel.isChanged();
    }

    static Object getUserObject(TreePath path) {
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        if (node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)node;
            return tn.getUserObject();
        }
        return null;
    }

    static Object getUserObject(DefaultMutableTreeNode node) {
        return node.getUserObject();
    }

    boolean isSelected(DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            HintsPanel.CodeAuditProxy hint;
            DefaultMutableTreeNode ch = (DefaultMutableTreeNode)node.getChildAt(i);
            Object o = ch.getUserObject();
            if (!(o instanceof HintsPanel.CodeAuditProxy) || !(hint = (HintsPanel.CodeAuditProxy)o).isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int shift;
        Rectangle r;
        Point p = e.getPoint();
        TreePath path = this.errorTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (path != null && (r = this.errorTree.getPathBounds(path)) != null && r.contains(p) && (shift = p.x - r.x) < r.height) {
            this.toggle(path);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        JTree tree;
        TreePath path;
        if ((e.getKeyCode() == 32 || e.getKeyCode() == 10) && e.getSource() instanceof JTree && this.toggle(path = (tree = (JTree)e.getSource()).getSelectionPath())) {
            e.consume();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent ex) {
        Object o = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        if (o instanceof HintsPanel.CodeAuditProxy) {
            if (this.defModel != this.severityComboBox.getModel()) {
                this.severityComboBox.setModel(this.defModel);
                Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.defLabel);
            }
            HintsPanel.CodeAuditProxy hint = (HintsPanel.CodeAuditProxy)o;
            this.componentsSetEnabled(true, 2);
            if ("action".equals(hint.getKind())) {
                this.severityComboBox.setSelectedIndex(severity2index.get(Severity.HINT));
                this.severityComboBox.setEnabled(false);
            } else if ("error".equals(hint.minimalSeverity())) {
                this.severityComboBox.setSelectedIndex(severity2index.get(Severity.ERROR));
            } else if ("warning".equals(hint.minimalSeverity())) {
                this.severityComboBox.setSelectedIndex(severity2index.get(Severity.WARNING));
            } else {
                this.severityComboBox.setSelectedIndex(severity2index.get(Severity.HINT));
            }
            String description = hint.getDescription();
            this.descriptionTextArea.setText(description == null ? "" : this.wrapDescription(description));
            this.customizerPanel.removeAll();
            Component c = null;
            if (c != null) {
                this.customizerPanel.add(c, "Center");
            }
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
        } else if (o instanceof HintsPanel.CodeAuditProviderProxy) {
            HintsPanel.CodeAuditProviderProxy hint = (HintsPanel.CodeAuditProviderProxy)o;
            String description = hint.getDescription();
            this.componentsSetEnabled(true, 1);
            this.descriptionTextArea.setText(description == null ? "" : this.wrapDescription(description));
            this.customizerPanel.removeAll();
            JComponent c = hint.createComponent();
            if (c != null) {
                this.customizerPanel.add((Component)c, "Center");
            }
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
        } else if (o instanceof HintsPanel.NamedOptionProxy) {
            HintsPanel.NamedOptionProxy option = (HintsPanel.NamedOptionProxy)o;
            if (this.defModel != this.severityComboBox.getModel()) {
                this.severityComboBox.setModel(this.defModel);
                Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.defLabel);
            }
            this.componentsSetEnabled(true, 3);
            String description = option.getDescription();
            this.descriptionTextArea.setText(description == null ? "" : this.wrapDescription(description));
            this.customizerPanel.removeAll();
            JComponent c = option.createComponent();
            if (c != null) {
                this.customizerPanel.add((Component)c, "Center");
            }
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
        } else {
            if (this.defModel != this.severityComboBox.getModel()) {
                this.severityComboBox.setModel(this.defModel);
                Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.defLabel);
            }
            this.componentsSetEnabled(false, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o;
        if (this.errorTree.getSelectionPath() == null) {
            return;
        }
        if (this.severityComboBox.equals(e.getSource()) && (o = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath())) instanceof HintsPanel.CodeAuditProxy) {
            HintsPanel.CodeAuditProxy hint = (HintsPanel.CodeAuditProxy)o;
            if (this.index2severity(this.severityComboBox.getSelectedIndex()) == Severity.ERROR) {
                hint.setSeverity(Severity.ERROR);
            } else if (this.index2severity(this.severityComboBox.getSelectedIndex()) == Severity.WARNING) {
                hint.setSeverity(Severity.WARNING);
            } else {
                hint.setSeverity(Severity.HINT);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private String wrapDescription(String description) {
        return new StringBuffer(DESCRIPTION_HEADER).append(description).append(DESCRIPTION_FOOTER).toString();
    }

    private Severity index2severity(int index) {
        for (Map.Entry<Severity, Integer> e : severity2index.entrySet()) {
            if (e.getValue() != index) continue;
            return e.getKey();
        }
        throw new IllegalStateException("Unknown severity");
    }

    private boolean toggle(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object o = HintsPanelLogic.getUserObject(treePath);
        HintsPanel.ExtendedModel model = this.extendedModel;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (o instanceof HintsPanel.CodeAuditProxy) {
            HintsPanel.CodeAuditProxy hint;
            hint.setEnabled(!(hint = (HintsPanel.CodeAuditProxy)o).isEnabled());
            model.nodeChanged(node);
            this.errorTree.repaint();
        } else if (o instanceof HintsPanel.CodeAuditProviderProxy) {
            HintsPanel.CodeAuditProxy audit;
            DefaultMutableTreeNode childAt;
            int i;
            HintsPanel.CodeAuditProviderProxy provider = (HintsPanel.CodeAuditProviderProxy)o;
            boolean hasEnabled = false;
            boolean hasDisabled = false;
            for (i = 0; i < node.getChildCount(); ++i) {
                childAt = (DefaultMutableTreeNode)node.getChildAt(i);
                audit = (HintsPanel.CodeAuditProxy)childAt.getUserObject();
                if (audit.isEnabled()) {
                    hasEnabled = true;
                    continue;
                }
                hasDisabled = true;
            }
            if (hasEnabled) {
                if (hasDisabled) {
                    for (i = 0; i < node.getChildCount(); ++i) {
                        childAt = (DefaultMutableTreeNode)node.getChildAt(i);
                        audit = (HintsPanel.CodeAuditProxy)childAt.getUserObject();
                        audit.setEnabled(true);
                    }
                } else {
                    for (i = 0; i < node.getChildCount(); ++i) {
                        childAt = (DefaultMutableTreeNode)node.getChildAt(i);
                        audit = (HintsPanel.CodeAuditProxy)childAt.getUserObject();
                        audit.setEnabled(false);
                    }
                }
            } else {
                for (i = 0; i < node.getChildCount(); ++i) {
                    childAt = (DefaultMutableTreeNode)node.getChildAt(i);
                    audit = (HintsPanel.CodeAuditProxy)childAt.getUserObject();
                    audit.setEnabled(true);
                }
            }
            model.nodeChanged(node);
            this.errorTree.repaint();
        } else if (o instanceof HintsPanel.NamedOptionProxy) {
            HintsPanel.NamedOptionProxy option = (HintsPanel.NamedOptionProxy)o;
            if (option.getBoolean()) {
                option.setBoolean(false);
            } else {
                option.setBoolean(true);
            }
            model.nodeChanged(node);
            this.errorTree.repaint();
        }
        return false;
    }

    private void componentsSetEnabled(boolean enabled, int component) {
        if (!enabled) {
            this.customizerPanel.removeAll();
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
            this.severityComboBox.setSelectedIndex(0);
            this.descriptionTextArea.setText("");
        }
        if (component == 0) {
            this.severityComboBox.setEnabled(false);
        } else if (component == 2) {
            this.severityComboBox.setEnabled(enabled);
        } else if (component == 1) {
            this.severityComboBox.setEnabled(false);
        } else if (component == 3) {
            this.severityComboBox.setEnabled(false);
        }
        this.descriptionTextArea.setEnabled(enabled);
    }

    static {
        severity2index.put(Severity.ERROR, 0);
        severity2index.put(Severity.WARNING, 1);
        severity2index.put(Severity.HINT, 2);
    }
}

