/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;

public interface ProfilerTreeTableModel {
    public TreeNode getRoot();

    public int getColumnCount();

    public Class getColumnClass(int var1);

    public String getColumnName(int var1);

    public void setValueAt(Object var1, TreeNode var2, int var3);

    public Object getValueAt(TreeNode var1, int var2);

    public boolean isCellEditable(TreeNode var1, int var2);

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public static class Adapter
    implements Listener {
        @Override
        public void dataChanged() {
        }

        @Override
        public void structureChanged() {
        }

        @Override
        public void rootChanged(TreeNode oldRoot, TreeNode newRoot) {
        }
    }

    public static interface Listener {
        public void dataChanged();

        public void structureChanged();

        public void rootChanged(TreeNode var1, TreeNode var2);
    }

    public static abstract class Abstract
    implements ProfilerTreeTableModel {
        private TreeNode root;
        private Set<Listener> listeners;

        public Abstract(TreeNode root) {
            if (root == null) {
                throw new NullPointerException("Root cannot be null");
            }
            this.root = root;
        }

        public void dataChanged() {
            this.fireDataChanged();
        }

        public void setRoot(TreeNode newRoot) {
            TreeNode oldRoot = this.root;
            this.root = newRoot;
            this.fireRootChanged(oldRoot, newRoot);
        }

        @Override
        public TreeNode getRoot() {
            return this.root;
        }

        @Override
        public void addListener(Listener listener) {
            if (this.listeners == null) {
                this.listeners = new HashSet<Listener>();
            }
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(Listener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }

        protected void fireDataChanged() {
            if (this.listeners != null) {
                for (Listener listener : this.listeners) {
                    listener.dataChanged();
                }
            }
        }

        protected void fireStructureChanged() {
            if (this.listeners != null) {
                for (Listener listener : this.listeners) {
                    listener.structureChanged();
                }
            }
        }

        protected void fireRootChanged(TreeNode oldRoot, TreeNode newRoot) {
            if (this.listeners != null) {
                for (Listener listener : this.listeners) {
                    listener.rootChanged(oldRoot, newRoot);
                }
            }
        }
    }
}

