/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator.support;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.support.Catalog;
import org.netbeans.lib.terminalemulator.support.ColorComboBoxRenderer;
import org.netbeans.lib.terminalemulator.support.ColorValue;

public class ColorComboBox {
    public static final String PROP_COLOR = "color";
    private static ColorValue[] content = new ColorValue[]{new ColorValue(Color.BLACK), new ColorValue(Color.BLUE), new ColorValue(Color.CYAN), new ColorValue(Color.DARK_GRAY), new ColorValue(Color.GRAY), new ColorValue(Color.GREEN), new ColorValue(Color.LIGHT_GRAY), new ColorValue(Color.MAGENTA), new ColorValue(Color.ORANGE), new ColorValue(Color.PINK), new ColorValue(Color.RED), new ColorValue(Color.WHITE), new ColorValue(Color.YELLOW), ColorValue.CUSTOM_COLOR, new ColorValue(ColorComboBox.loc("CTL_None_Color"), null)};

    static void init(JComboBox<ColorValue> combo) {
        combo.setModel(new DefaultComboBoxModel<ColorValue>(content));
        combo.setRenderer(new ColorComboBoxRenderer(combo));
        combo.setEditable(true);
        combo.setEditor(new ColorComboBoxRenderer(combo));
        combo.setSelectedItem(new ColorValue(null, null));
        combo.addActionListener(new ComboBoxListener(combo));
    }

    static void setInheritedColor(JComboBox<ColorValue> combo, Color color) {
        ColorValue[] ncontent = new ColorValue[content.length];
        System.arraycopy(content, 0, ncontent, 0, content.length);
        ncontent[ColorComboBox.content.length - 1] = color != null ? new ColorValue(ColorComboBox.loc("CTL_Inherited_Color"), color) : new ColorValue(ColorComboBox.loc("CTL_None_Color"), null);
        combo.setModel(new DefaultComboBoxModel<ColorValue>(ncontent));
    }

    static void setColor(JComboBox<ColorValue> combo, Color color) {
        if (color == null) {
            combo.setSelectedIndex(content.length - 1);
        } else {
            combo.setSelectedItem(new ColorValue(color));
        }
    }

    static Color getColor(JComboBox<ColorValue> combo) {
        if (combo.getSelectedIndex() < combo.getItemCount() - 1) {
            return ((ColorValue)combo.getSelectedItem()).color;
        }
        return null;
    }

    private static String loc(String key) {
        return Catalog.get(key);
    }

    private static class ComboBoxListener
    implements ActionListener {
        private JComboBox<ColorValue> combo;
        private Object lastSelection;

        ComboBoxListener(JComboBox<ColorValue> combo) {
            this.combo = combo;
            this.lastSelection = combo.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (this.combo.getSelectedItem() == ColorValue.CUSTOM_COLOR) {
                Color c = JColorChooser.showDialog(SwingUtilities.getAncestorOfClass(Dialog.class, this.combo), ColorComboBox.loc("SelectColor"), this.lastSelection != null ? ((ColorValue)this.lastSelection).color : null);
                if (c != null) {
                    ColorComboBox.setColor(this.combo, c);
                } else if (this.lastSelection != null) {
                    this.combo.setSelectedItem(this.lastSelection);
                }
            }
            this.lastSelection = this.combo.getSelectedItem();
        }
    }
}

