package org.clank.support.aliases;

import org.clank.support.Converted;
import org.clank.support.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.NativeMemory.*;
import static org.clank.support.NativePointer.*;

/**
 * Lightest implementation of pointer to ${TYPE}
 */
//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.clank.java/src/org/clank/support/aliases/templates/pointersingleimpl.tpl")
//</editor-fold>
public final class ${FILE_NAME}${CLASS_SUFFIX} extends AbstractSinglePointerType<${POINTER_NAME}> implements ${POINTER_NAME}, ${REFERENCE_NAME} {
    
    private ${TYPE} val;

    public ${FILE_NAME}() {
        this((${TYPE})${DEFAULT_VALUE});
    }
    
    public ${FILE_NAME}(${TYPE} val) {
        this.val = val;
        trackInstance();
    }

    ////////////////////////////////////////////////////////////////////////////
    // common operations
    @Override
    public ${TYPE} $deref() {
      return $star();
    }

    @Override
    public ${TYPE} $star() {
      return val;
    }

    @Override
    public ${TYPE} $set(${TYPE} value) {
        ${SET_IMPL}
        return val;
    }

    @Override
    public ${TYPE} $at(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return val;
    }

    @Override
    public ${TYPE} $set(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val = value;
    }       
    ${BUILTIN_TYPE_MODIFY_VALUE_SECTION_START}
    @Override
    public ${TYPE} $set$andassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val &= value;
    }

    @Override
    public ${TYPE} $set$andassign(${TYPE} value) {
        return this.val &= value;
    }

    @Override
    public ${TYPE} $set$xorassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val ^= value;
    }

    @Override
    public ${TYPE} $set$xorassign(${TYPE} value) {
        return this.val ^= value;
    }

    @Override
    public ${TYPE} $set$orassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val |= value;
    }
    
    @Override
    public ${TYPE} $set$orassign(${TYPE} value) {
        return this.val |= value;
    }
    
    ${BUILTIN_TYPE_MODIFY_VALUE_SECTION_END}${ADDITIONAL_MODIFY_VALUE_SECTION_START}

    @Override
    public ${TYPE} $set$addassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val += value;
    }

    @Override
    public ${TYPE} $set$addassign(${TYPE} value) {
        return this.val += value;
    }

    @Override
    public ${TYPE} $set$minusassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val -= value;
    }

    @Override
    public ${TYPE} $set$minusassign(${TYPE} value) {
        return this.val -= value;
    }

    @Override
    public ${TYPE} $set$starassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val *= value;
    }

    @Override
    public ${TYPE} $set$starassign(${TYPE} value) {
        return this.val *= value;
    }

    @Override
    public ${TYPE} $set$slashassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val /= value;
    }

    @Override
    public ${TYPE} $set$slashassign(${TYPE} value) {
        return this.val /= value;
    }

    @Override
    public ${TYPE} $set$modassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val %= value;
    }

    @Override
    public ${TYPE} $set$modassign(${TYPE} value) {
        return this.val %= value;
    }

    @Override
    public ${TYPE} $set$lshiftassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val <<= value;
    }

    @Override
    public ${TYPE} $set$rshiftassign(int index, ${TYPE} value) {
        if (index != 0) {
            throw new IllegalArgumentException("Index must be zero to access to the single variable!");
        }
        return this.val >>= value;
    }

    @Override
    public ${TYPE} $set$rshiftassign(${TYPE} value) {
        return this.val >>= value;
    }

    @Override
    public ${TYPE} $set$postInc(int index) {
        return this.val++;
    }

    @Override
    public ${TYPE} $set$postInc() {
        return this.val++;
    }

    @Override
    public ${TYPE} $set$postDec(int index) {
        return this.val--;
    }

    @Override
    public ${TYPE} $set$postDec() {
        return this.val--;
    }

    @Override
    public ${TYPE} $set$preInc(int index) {
        return ++this.val;
    }

    @Override
    public ${TYPE} $set$preInc() {
        return ++this.val;
    }

    @Override
    public ${TYPE} $set$preDec(int index) {
        return --this.val;
    }

    @Override
    public ${TYPE} $set$preDec() {
        return --this.val;
    }

    ${ADDITIONAL_MODIFY_VALUE_SECTION_END}

    @Override
    public ${POINTER_NAME} $assign(${POINTER_NAME} value) {
        throw new UnsupportedOperationException("Use $set(value.$star()) instead!");
    }

    @Override
    public ${REFERENCE_NAME} star$ref() {
      return this;
    }

    @Override
    public ${POINTER_NAME} deref$ptr() {
      return this;
    }

    @Override
    public String toString() {
      return "${FILE_NAME}{" + ${STRING_VAL} + "}";
    }    

    ////////////////////////////////////////////////////////////////////////////
    // statistics
    private static long instances = 0;
    
    public static void trackInstance() {        
        if (NativeTrace.STATISTICS) instances++;
    }

    public static void clearStatistics() {        
        instances = 0;
    }

    public static long printStatistics(java.io.PrintWriter out) {
        out.printf("%22s created:\t%s%n", ${FILE_NAME}.class.getSimpleName(), NativeTrace.formatNumber(instances));
        return instances;
    }

    ///////////////////////////////////////////////////////////////////////////
    // performance access operations

    @Override
    public int $index() {
      throw new UnsupportedOperationException("Not supported; create array based instance instead");
    }

    @Override
    public ${TYPE}[] $array() {
      throw new UnsupportedOperationException("Not supported; create array based instance instead");
    }

}