#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.2.3.2
id: pandoc-2.2.3.2-KjILLxwn4pP5vtfqKc02vM
key: pandoc-2.2.3.2-KjILLxwn4pP5vtfqKc02vM
license: GPL-2.0-only
copyright: (c) 2006-2018 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
author: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: https://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, EPUB, FictionBook2, and Textile,
    and it can write Markdown, reStructuredText, XHTML, HTML 5,
    LaTeX, ConTeXt, DocBook, JATS, OPML, TEI, OpenDocument,
    ODT, Word docx, RTF, MediaWiki, DokuWiki, ZimWiki, Textile,
    groff man, groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
abi: 307a40257cc9dbb5b6ba85522a5407c8
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.FB2
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.Haddock
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.LaTeX.Types Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.SelfContained Text.Pandoc.Shared Text.Pandoc.Templates
    Text.Pandoc.UTF8 Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Filter Text.Pandoc.Filter.JSON
                Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
                Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
                Text.Pandoc.Readers.Docx.Parse Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Docx.Fields
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared
                Text.Pandoc.Writers.Powerpoint.Presentation
                Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Init Text.Pandoc.Lua.Module.MediaBag
                Text.Pandoc.Lua.Module.Pandoc Text.Pandoc.Lua.Module.Utils
                Text.Pandoc.Lua.Packages Text.Pandoc.Lua.StackInstances
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.UUID Text.Pandoc.Translations Text.Pandoc.Slides
                Paths_pandoc
import-dirs: /usr/lib/ghc-8.4.3/site-local/pandoc-2.2.3.2
library-dirs: /usr/lib/ghc-8.4.3/site-local/pandoc-2.2.3.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.2.3.2-KjILLxwn4pP5vtfqKc02vM
depends:
    base-4.11.1.0 syb-0.7-2jW43lwzJV5e7EQvU8PxV containers-0.5.11.0
    unordered-containers-0.2.9.0-KfM11vwfv9j3BnvMvjdQDd parsec-3.1.13.0
    mtl-2.2.2 exceptions-0.10.0-KqLFUMgISLoDmBqq0VbkGc filepath-1.4.2
    process-1.6.3.0 directory-1.3.1.5 bytestring-0.10.8.2 text-1.2.3.0
    time-1.8.0.2 safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur
    zip-archive-0.3.3-L4ZC1cFPAYN6WrYIJru0lg
    HTTP-4000.3.12-AytKzedvb60KGKOVaZhUDG
    texmath-0.11.1-C89QLRpRwSc6CdclcFeYZf
    xml-1.3.14-Iiopw2ucwBuIKdlkbvc4Gm
    split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG
    random-1.1-9LLJAJa4iQFLJiLXBOBXBV
    pandoc-types-1.17.5.1-8E5TgS4dFud82Makh5Hh4k
    aeson-1.4.0.0-EgUTCbIlE19378rsR2i9zV
    aeson-pretty-0.8.7-HR98go7is0pARduDbo8oPT
    tagsoup-0.14.6-7Kjdp42VPmpFTv5v8vSEkC
    base64-bytestring-1.0.0.1-4OCIe2BZn8jKI191JIXI37
    zlib-0.6.2-HJOgVWrPGFTFgWXcvoaUGH
    skylighting-0.7.3-LhkTyG1HxkuCPduchb0KK4
    data-default-0.7.1.1-ANph70WEdAe9A1H2IGNxHn
    temporary-1.3-9oQzo4JVNP7CXkKVrv2cKm
    blaze-html-0.9.1.1-EgxdH3AtVL83pCluZdDgeJ
    blaze-markup-0.8.2.1-FFkiru1HsegAfMrnqJMDug
    vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
    hslua-0.9.5.2-AiazFwAnXuh3Di6MU0O7d6
    hslua-module-text-0.1.2.1-HK0PldBGM825NWAKOeYv2A binary-0.8.5.1
    SHA-1.6.4.4-J97i4k52krALB5u9VxmQ73
    haddock-library-1.6.0-AbJMqhgpy5oDXPdggoZulu deepseq-1.4.3.0
    JuicyPixels-3.3.1-GoHpnhcfmT4HnjNPbV3sCn
    Glob-0.9.2-AJJPuAUSPRn1Cvmws5n8Um
    cmark-gfm-0.1.5-AvnXgi7Mts9sGqig73mCZ
    doctemplates-0.2.2.1-Ao96FART7wsiPgmb8xNOm
    network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9
    network-2.7.0.2-8yE8vwBlEy1KZPVD4sTAn
    http-client-0.5.13.1-8VGZtvml4R5EgKWuNogbLU
    http-client-tls-0.3.5.3-KHqdrg1m2Ik3YpAeWMZiTu
    http-types-0.12.1-BvzC7WDeWNh7Q1bvrgnPmB
    case-insensitive-1.2.0.11-GjimmYhRn324HWbQThQUra
    HsYAML-0.1.1.2-2zpifZwzGa8Kz9Q1vMaSOI unix-2.7.2.2
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             syb-0.7-2jW43lwzJV5e7EQvU8PxV=867165047495b4e6f144c8b9b108f918
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             unordered-containers-0.2.9.0-KfM11vwfv9j3BnvMvjdQDd=4d1dd6bd73dbf55dc13ef767664a6e82
             parsec-3.1.13.0=3626e7cedd22de76a8b10339d955721a
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             exceptions-0.10.0-KqLFUMgISLoDmBqq0VbkGc=7e2a2010d6645bddac83e90b3cee8839
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             directory-1.3.1.5=f5fa3aef63d61d9b32ef25d211ef137f
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur=42026212d0dad8beaed25fde58365be8
             zip-archive-0.3.3-L4ZC1cFPAYN6WrYIJru0lg=c613914dcefe342d62ec256103a2cbf4
             HTTP-4000.3.12-AytKzedvb60KGKOVaZhUDG=e1cdb087069013e88f5bab10813664a5
             texmath-0.11.1-C89QLRpRwSc6CdclcFeYZf=7927b9bc1eda4ea58d9789ed1be0541b
             xml-1.3.14-Iiopw2ucwBuIKdlkbvc4Gm=447f20f46280d63791817d6b9c8e0eb8
             split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG=cdf77c47c599317cfa01d2d98185c5d3
             random-1.1-9LLJAJa4iQFLJiLXBOBXBV=2cade9e72fa19fe7a43e5ace84505d9f
             pandoc-types-1.17.5.1-8E5TgS4dFud82Makh5Hh4k=3c8a9183aee932340ae16be7a7c1d301
             aeson-1.4.0.0-EgUTCbIlE19378rsR2i9zV=8e4d597de977510ba6167651bfbacc4c
             aeson-pretty-0.8.7-HR98go7is0pARduDbo8oPT=64591c1231c2b75f27f209aa70a0f690
             tagsoup-0.14.6-7Kjdp42VPmpFTv5v8vSEkC=20f59525319cbc5c261121b478cbf532
             base64-bytestring-1.0.0.1-4OCIe2BZn8jKI191JIXI37=65adc4f5f54a1c07291b4ebc49756c05
             zlib-0.6.2-HJOgVWrPGFTFgWXcvoaUGH=8fa648805d93281f19b98bbf203b4b1c
             skylighting-0.7.3-LhkTyG1HxkuCPduchb0KK4=7fd2ec55e4fed90dbf843c4e82f23dff
             data-default-0.7.1.1-ANph70WEdAe9A1H2IGNxHn=02e9419e0e877fc1db7c56d6f64866aa
             temporary-1.3-9oQzo4JVNP7CXkKVrv2cKm=ea3af39ce8ca8ee514ec8c391cc2de11
             blaze-html-0.9.1.1-EgxdH3AtVL83pCluZdDgeJ=26d7d7bc6469699c9d8f038081c294ce
             blaze-markup-0.8.2.1-FFkiru1HsegAfMrnqJMDug=71b515c6e3bfb99ff0075cc129b1fc3b
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             hslua-0.9.5.2-AiazFwAnXuh3Di6MU0O7d6=77d0164d5c7a005702bb69a321bd4978
             hslua-module-text-0.1.2.1-HK0PldBGM825NWAKOeYv2A=80a2669a097d2df261ff42583661147b
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             SHA-1.6.4.4-J97i4k52krALB5u9VxmQ73=7fdfeaf1e3416ffd434c90cf824fb303
             haddock-library-1.6.0-AbJMqhgpy5oDXPdggoZulu=e7fbe50d952f645e84d2505e9c928fdd
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             JuicyPixels-3.3.1-GoHpnhcfmT4HnjNPbV3sCn=76ae9cd77938ceb75dbc084e47aef5ec
             Glob-0.9.2-AJJPuAUSPRn1Cvmws5n8Um=391240d8943cdc647a04d17bc4a7876c
             cmark-gfm-0.1.5-AvnXgi7Mts9sGqig73mCZ=34716da549873f4c3e09aade28adf1b0
             doctemplates-0.2.2.1-Ao96FART7wsiPgmb8xNOm=a7f7c0ea81995f657e7ca21073ec92db
             network-uri-2.6.1.0-AstEwZoXrlUJQq4VkxaVo9=4ea8f0efa7a1ade0af4e9ce0cffcff8c
             network-2.7.0.2-8yE8vwBlEy1KZPVD4sTAn=90fa8650caae170586ac66be24e6a39f
             http-client-0.5.13.1-8VGZtvml4R5EgKWuNogbLU=731e662bb8eff5482969dab5518da667
             http-client-tls-0.3.5.3-KHqdrg1m2Ik3YpAeWMZiTu=f698c6d730379fc5e56cf2dac8ec304b
             http-types-0.12.1-BvzC7WDeWNh7Q1bvrgnPmB=302ec39836eeed635681d48972d58b60
             case-insensitive-1.2.0.11-GjimmYhRn324HWbQThQUra=0a5994e39a32f328ff4f350b25844411
             HsYAML-0.1.1.2-2zpifZwzGa8Kz9Q1vMaSOI=b2aeac0c0d87c97a5a6150b563d23324
             unix-2.7.2.2=f81aa481840dadf9c364a1cea96978c0
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

