/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.EventQueue;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.SessionStructure;

public class ProxyListenerLog
implements ProxyListener,
ConnectRequestProxyListener {
    private static final Logger log = Logger.getLogger(ProxyListenerLog.class);
    public static final int PROXY_LISTENER_ORDER = 5000;
    private ViewDelegate view = null;
    private Model model = null;
    private boolean isFirstAccess = true;
    private ExtensionHistory extension = null;

    public ProxyListenerLog(Model model, ViewDelegate view, ExtensionHistory extension) {
        this.model = model;
        this.view = view;
        this.extension = extension;
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 5000;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage msg) {
        HttpMessage existingMsg = this.model.getSession().getSiteTree().pollPath(msg);
        if (existingMsg != null && !existingMsg.getResponseHeader().isEmpty() && HttpStatusCode.isSuccess(existingMsg.getResponseHeader().getStatusCode())) {
            return true;
        }
        if (msg.getRequestHeader().getHeader("If-Modified-Since") != null) {
            msg.getRequestHeader().setHeader("If-Modified-Since", null);
        }
        if (msg.getRequestHeader().getHeader("If-None-Match") != null) {
            msg.getRequestHeader().setHeader("If-None-Match", null);
        }
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(final HttpMessage msg) {
        int type = 1;
        if (this.isSkipImage(msg.getRequestHeader()) || this.isSkipImage(msg.getResponseHeader())) {
            if (msg.getResponseHeader().getStatusCode() == 200) {
                type = 6;
            } else {
                return true;
            }
        }
        final int finalType = type;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ProxyListenerLog.this.createAndAddMessage(msg, finalType);
            }
        });
        t.start();
        return true;
    }

    public boolean isSkipImage(HttpHeader header) {
        return header.isImage() && !this.model.getOptionsParam().getViewParam().isProcessImages();
    }

    private void createAndAddMessage(HttpMessage msg, int type) {
        HistoryReference historyRef = this.createHistoryReference(msg, type);
        if (historyRef == null || type != 1 && type != 6) {
            return;
        }
        this.extension.addHistory(historyRef);
        this.addToSiteMap(historyRef, msg);
    }

    private HistoryReference createHistoryReference(HttpMessage message, int type) {
        try {
            return new HistoryReference(this.model.getSession(), type, message);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void addToSiteMap(final HistoryReference ref, final HttpMessage msg) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProxyListenerLog.this.addToSiteMap(ref, msg);
                    }
                });
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
        SessionStructure.addPath(this.model.getSession(), ref, msg);
        if (this.isFirstAccess && !Constant.isLowMemoryOptionSet()) {
            this.isFirstAccess = false;
            if (View.isInitialised()) {
                this.view.getSiteTreePanel().expandRoot();
            }
        }
    }

    @Override
    public void receivedConnectRequest(final HttpMessage connectMessage) {
        if (!this.model.getOptionsParam().getViewParam().isShowLocalConnectRequests()) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                HistoryReference historyRef = ProxyListenerLog.this.createHistoryReference(connectMessage, 16);
                if (historyRef != null) {
                    ProxyListenerLog.this.extension.addHistory(historyRef);
                }
            }
        });
        t.start();
    }
}

