/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import org.zaproxy.zap.network.DefaultHttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRedirectionValidator;

public class HttpRequestConfig {
    public static final int NO_VALUE_SET = -1;
    private final boolean followRedirects;
    private final HttpRedirectionValidator redirectionValidator;
    private final boolean notifyListeners;
    private final int soTimeout;

    HttpRequestConfig(boolean followRedirects, HttpRedirectionValidator redirectionValidator, boolean notifyListeners, int soTimeout) {
        this.followRedirects = followRedirects;
        this.redirectionValidator = redirectionValidator;
        this.notifyListeners = notifyListeners;
        this.soTimeout = soTimeout;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public HttpRedirectionValidator getRedirectionValidator() {
        return this.redirectionValidator;
    }

    public boolean isNotifyListeners() {
        return this.notifyListeners;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HttpRequestConfig configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Parameter configuration must not be null.");
        }
        return new Builder(configuration);
    }

    public static class Builder {
        private boolean followRedirects;
        private HttpRedirectionValidator redirectionValidator;
        private boolean notifyListeners;
        private int soTimeout;

        private Builder() {
            this.followRedirects = false;
            this.redirectionValidator = DefaultHttpRedirectionValidator.INSTANCE;
            this.notifyListeners = true;
            this.soTimeout = -1;
        }

        private Builder(HttpRequestConfig config) {
            this.followRedirects = config.isFollowRedirects();
            this.redirectionValidator = config.getRedirectionValidator();
            this.notifyListeners = config.isNotifyListeners();
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setRedirectionValidator(HttpRedirectionValidator redirectionValidator) {
            if (redirectionValidator == null) {
                throw new IllegalArgumentException("Parameter redirectionValidator must not be null.");
            }
            this.redirectionValidator = redirectionValidator;
            this.followRedirects = true;
            return this;
        }

        public Builder setNotifyListeners(boolean notifyListeners) {
            this.notifyListeners = notifyListeners;
            return this;
        }

        public Builder setSoTimeout(int soTimeout) {
            if (soTimeout <= -1) {
                this.soTimeout = -1;
                return this;
            }
            this.soTimeout = soTimeout;
            return this;
        }

        public HttpRequestConfig build() {
            return new HttpRequestConfig(this.followRedirects, this.redirectionValidator, this.notifyListeners, this.soTimeout);
        }
    }
}

