/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.ArrayList;
import java.util.List;
import org.openoffice.xmerge.merger.diff.TextNodeEntry;
import org.openoffice.xmerge.merger.diff.TextNodeIterator;
import org.w3c.dom.Node;

public class CharacterParser {
    private final TextNodeIterator textNodes;
    private int currentPosition = 0;
    private final List<TextNodeEntry> nodeList_;
    private char[] charArray;

    public CharacterParser(Node node) {
        this.textNodes = new TextNodeIterator(node);
        this.nodeList_ = new ArrayList<TextNodeEntry>();
        this.parseNodes();
    }

    public List<TextNodeEntry> getNodeList() {
        return this.nodeList_;
    }

    public char[] getCharArray() {
        return this.charArray;
    }

    private void parseNodes() {
        StringBuffer strBuf = new StringBuffer();
        Node currentNode = (Node)this.textNodes.start();
        while (currentNode != null) {
            String textValue = null;
            String nodeName = currentNode.getNodeName();
            if (currentNode.getNodeType() == 3) {
                textValue = currentNode.getNodeValue();
            } else if (nodeName.equals("text:s")) {
                textValue = " ";
            } else if (nodeName.equals("text:tab-stop")) {
                textValue = "\t";
            }
            if (textValue != null) {
                strBuf.append(textValue);
                this.addNewNodeEntry(textValue.length(), currentNode);
            }
            currentNode = (Node)this.textNodes.next();
        }
        this.charArray = strBuf.toString().toCharArray();
    }

    private void addNewNodeEntry(int textLen, Node node) {
        TextNodeEntry nodeEntry = new TextNodeEntry(this.currentPosition, this.currentPosition + textLen - 1, node);
        this.currentPosition += textLen;
        this.nodeList_.add(nodeEntry);
    }
}

