#ifndef _EFL_APP_EO_H_
#define _EFL_APP_EO_H_

#ifndef _EFL_APP_EO_CLASS_TYPE
#define _EFL_APP_EO_CLASS_TYPE

typedef Eo Efl_App;

#endif

#ifndef _EFL_APP_EO_TYPES
#define _EFL_APP_EO_TYPES


#endif
/** No description supplied.
 *
 * @ingroup Efl_App
 */
#define EFL_APP_CLASS efl_app_class_get()

EWAPI const Efl_Class *efl_app_class_get(void);

/**
 * @brief Points to the main loop instance of the application.
 *
 * @return Application main loop
 *
 * @ingroup Efl_App
 */
EOAPI Efl_Loop *efl_app_loop_main_get(const Eo *obj);

/**
 * @brief Indicates the version of EFL with which this application was compiled
 * against/for.
 *
 * This might differ from @ref efl_app_efl_version_get.
 *
 * @param[in] obj The object.
 *
 * @return Efl version
 *
 * @ingroup Efl_App
 */
EOAPI const Efl_Version *efl_app_build_efl_version_get(const Eo *obj);

/**
 * @brief Indicates the currently running version of EFL.
 *
 * This might differ from @ref efl_app_build_efl_version_get.
 *
 * @param[in] obj The object.
 *
 * @return Efl version
 *
 * @ingroup Efl_App
 */
EOAPI const Efl_Version *efl_app_efl_version_get(const Eo *obj);

EWAPI extern const Efl_Event_Description _EFL_APP_EVENT_PAUSE;

/** Called when the application is not going be displayed or otherwise used by
 * a user for some time
 *
 * @ingroup Efl_App
 */
#define EFL_APP_EVENT_PAUSE (&(_EFL_APP_EVENT_PAUSE))

EWAPI extern const Efl_Event_Description _EFL_APP_EVENT_RESUME;

/** Called before a window is rendered after a pause event
 *
 * @ingroup Efl_App
 */
#define EFL_APP_EVENT_RESUME (&(_EFL_APP_EVENT_RESUME))

EWAPI extern const Efl_Event_Description _EFL_APP_EVENT_TERMINATE;

/** Called before starting the shutdown of the application
 *
 * @ingroup Efl_App
 */
#define EFL_APP_EVENT_TERMINATE (&(_EFL_APP_EVENT_TERMINATE))

EWAPI extern const Efl_Event_Description _EFL_APP_EVENT_SIGNAL_USR1;

/** System specific, but on unix maps to SIGUSR1 signal to the process - only
 * called on main loop object
 *
 * @ingroup Efl_App
 */
#define EFL_APP_EVENT_SIGNAL_USR1 (&(_EFL_APP_EVENT_SIGNAL_USR1))

EWAPI extern const Efl_Event_Description _EFL_APP_EVENT_SIGNAL_USR2;

/** System specific, but on unix maps to SIGUSR2 signal to the process - only
 * called on main loop object
 *
 * @ingroup Efl_App
 */
#define EFL_APP_EVENT_SIGNAL_USR2 (&(_EFL_APP_EVENT_SIGNAL_USR2))

EWAPI extern const Efl_Event_Description _EFL_APP_EVENT_SIGNAL_HUP;

/** System specific, but on unix maps to SIGHUP signal to the process - only
 * called on main loop object
 *
 * @ingroup Efl_App
 */
#define EFL_APP_EVENT_SIGNAL_HUP (&(_EFL_APP_EVENT_SIGNAL_HUP))

#endif
