/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.ScrollViewport;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.relation.ChildRelationBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberRoleCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowserModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditorHooks;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTable;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddSelectedAfterSelection;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddSelectedAtEndAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddSelectedAtStartAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddSelectedBeforeSelection;
import org.openstreetmap.josm.gui.dialogs.relation.actions.ApplyAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.CancelAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.CopyMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DeleteCurrentRelationAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DownloadIncompleteMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.DuplicateRelationAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.EditAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionGroup;
import org.openstreetmap.josm.gui.dialogs.relation.actions.MoveDownAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.MoveUpAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.OKAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.PasteMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.RefreshAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.RemoveAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.RemoveSelectedAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.ReverseAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SelectAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SelectPrimitivesForSelectedMembersAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SelectedMembersForSelectionAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SetRoleAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SortAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SortBelowAction;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class GenericRelationEditor
extends RelationEditor {
    private final TagEditorPanel tagEditorPanel;
    private final ReferringRelationsBrowser referrerBrowser;
    private final ReferringRelationsBrowserModel referrerModel;
    private final MemberTable memberTable;
    private final MemberTableModel memberTableModel;
    private final SelectionTable selectionTable;
    private final SelectionTableModel selectionTableModel;
    private final AutoCompletingTextField tfRole;
    private JMenuItem windowMenuItem;
    private final RefreshAction refreshAction;
    private final ApplyAction applyAction;
    private final SelectAction selectAction;
    private final DuplicateRelationAction duplicateAction;
    private final DeleteCurrentRelationAction deleteAction;
    private final OKAction okAction;
    private final CancelAction cancelAction;
    private final ArrayList<FlavorListener> clipboardListeners = new ArrayList();

    public GenericRelationEditor(OsmDataLayer layer, Relation relation, Collection<RelationMember> selectedMembers) {
        super(layer, relation);
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(700, 650)));
        TaggingPresetHandler presetHandler = new TaggingPresetHandler(){

            @Override
            public void updateTags(List<Tag> tags) {
                GenericRelationEditor.this.tagEditorPanel.getModel().updateTags(tags);
            }

            @Override
            public Collection<OsmPrimitive> getSelection() {
                Relation relation = new Relation();
                GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(relation);
                return Collections.singletonList(relation);
            }
        };
        this.memberTableModel = new MemberTableModel(relation, this.getLayer(), presetHandler);
        this.memberTableModel.register();
        this.selectionTableModel = new SelectionTableModel(this.getLayer());
        this.selectionTableModel.register();
        this.referrerModel = new ReferringRelationsBrowserModel(relation);
        this.tagEditorPanel = new TagEditorPanel(relation, presetHandler);
        this.populateModels(relation);
        this.tagEditorPanel.getModel().ensureOneTag();
        this.memberTable = new MemberTable(this.getLayer(), this.getRelation(), this.memberTableModel);
        this.memberTable.addMouseListener(new MemberTableDblClickAdapter());
        this.memberTableModel.addMemberModelListener(this.memberTable);
        MemberRoleCellEditor ce = (MemberRoleCellEditor)this.memberTable.getColumnModel().getColumn(0).getCellEditor();
        this.selectionTable = new SelectionTable(this.selectionTableModel, this.memberTableModel);
        this.selectionTable.setRowHeight(ce.getEditor().getPreferredSize().height);
        LeftButtonToolbar leftButtonToolbar = new LeftButtonToolbar(new RelationEditorActionAccess());
        this.tfRole = GenericRelationEditor.buildRoleTextField(this);
        JSplitPane pane = GenericRelationEditor.buildSplitPane(GenericRelationEditor.buildTagEditorPanel(this.tagEditorPanel), GenericRelationEditor.buildMemberEditorPanel(leftButtonToolbar, new RelationEditorActionAccess()), this);
        pane.setPreferredSize(new Dimension(100, 100));
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)pane, "Center");
        pnl.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(I18n.tr("Tags and Members", new Object[0]), pnl);
        this.referrerBrowser = new ReferringRelationsBrowser(this.getLayer(), this.referrerModel);
        tabbedPane.add(I18n.tr("Parent Relations", new Object[0]), this.referrerBrowser);
        tabbedPane.add(I18n.tr("Child Relations", new Object[0]), new ChildRelationBrowser(this.getLayer(), relation));
        tabbedPane.addChangeListener(e -> {
            int index;
            JTabbedPane sourceTabbedPane = (JTabbedPane)e.getSource();
            String title = sourceTabbedPane.getTitleAt(index = sourceTabbedPane.getSelectedIndex());
            if (title.equals(I18n.tr("Parent Relations", new Object[0]))) {
                this.referrerBrowser.init();
            }
        });
        RelationEditorActionAccess actionAccess = new RelationEditorActionAccess();
        this.refreshAction = new RefreshAction(actionAccess);
        this.applyAction = new ApplyAction(actionAccess);
        this.selectAction = new SelectAction(actionAccess);
        this.duplicateAction = new DuplicateRelationAction(actionAccess);
        this.deleteAction = new DeleteCurrentRelationAction(actionAccess);
        this.addPropertyChangeListener(this.deleteAction);
        this.okAction = new OKAction(actionAccess);
        this.cancelAction = new CancelAction(actionAccess);
        this.getContentPane().add((Component)GenericRelationEditor.buildToolBar(this.refreshAction, this.applyAction, this.selectAction, this.duplicateAction, this.deleteAction), "North");
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.getContentPane().add((Component)GenericRelationEditor.buildOkCancelButtonPanel(this.okAction, this.cancelAction), "South");
        this.setSize(this.findMaxDialogSize());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                GenericRelationEditor.cleanSelfReferences(GenericRelationEditor.this.memberTableModel, GenericRelationEditor.this.getRelation());
            }

            @Override
            public void windowClosing(WindowEvent e) {
                GenericRelationEditor.this.cancel();
            }
        });
        this.registerCopyPasteAction(this.tagEditorPanel.getPasteAction(), "PASTE_TAGS", Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags", new Object[0])), 86, 5009).getKeyStroke(), this.getRootPane(), this.memberTable, this.selectionTable);
        KeyStroke key = Shortcut.getPasteKeyStroke();
        if (key != null) {
            this.registerCopyPasteAction(new PasteMembersAction(actionAccess){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    GenericRelationEditor.this.tfRole.requestFocusInWindow();
                }
            }, "PASTE_MEMBERS", key, this.getRootPane(), this.memberTable, this.selectionTable);
        }
        if ((key = Shortcut.getCopyKeyStroke()) != null) {
            this.registerCopyPasteAction(new CopyMembersAction(actionAccess), "COPY_MEMBERS", key, this.getRootPane(), this.memberTable, this.selectionTable);
        }
        this.tagEditorPanel.setNextFocusComponent(this.memberTable);
        this.selectionTable.setFocusable(false);
        this.memberTableModel.setSelectedMembers(selectedMembers);
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/RelationEditor"));
    }

    @Override
    public void reloadDataFromRelation() {
        this.setRelation(this.getRelation());
        this.populateModels(this.getRelation());
        this.refreshAction.updateEnabledState();
    }

    private void populateModels(Relation relation) {
        if (relation != null) {
            this.tagEditorPanel.getModel().initFromPrimitive(relation);
            this.memberTableModel.populate(relation);
            if (!this.getLayer().data.getRelations().contains(relation)) {
                this.setRelation(null);
            }
        } else {
            this.tagEditorPanel.getModel().clear();
            this.memberTableModel.populate(null);
        }
    }

    public void apply() {
        this.applyAction.actionPerformed(null);
    }

    public void select() {
        this.selectAction.actionPerformed(null);
    }

    public void cancel() {
        this.cancelAction.actionPerformed(null);
    }

    protected static JToolBar buildToolBar(AbstractRelationEditorAction ... actions) {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        for (AbstractRelationEditorAction action : actions) {
            tb.add(action);
        }
        return tb;
    }

    protected static JPanel buildOkCancelButtonPanel(OKAction okAction, CancelAction cancelAction) {
        JPanel pnl = new JPanel(new FlowLayout(1));
        pnl.add(new JButton(okAction));
        pnl.add(new JButton(cancelAction));
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/RelationEditor"))));
        return pnl;
    }

    protected static JPanel buildTagEditorPanel(TagEditorPanel tagEditorPanel) {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Tags", new Object[0])), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)tagEditorPanel, gc);
        return pnl;
    }

    protected static AutoCompletingTextField buildRoleTextField(final IRelationEditor re) {
        final AutoCompletingTextField tfRole = new AutoCompletingTextField(10);
        tfRole.setToolTipText(I18n.tr("Enter a role and apply it to the selected relation members", new Object[0]));
        tfRole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                tfRole.selectAll();
            }
        });
        tfRole.setAutoCompletionList(new AutoCompletionList());
        tfRole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AutoCompletionList list = tfRole.getAutoCompletionList();
                if (list != null) {
                    list.clear();
                    AutoCompletionManager.of(re.getLayer().data).populateWithMemberRoles(list, re.getRelation());
                }
            }
        });
        tfRole.setText(Config.getPref().get("relation.editor.generic.lastrole", ""));
        return tfRole;
    }

    protected static JPanel buildMemberEditorPanel(LeftButtonToolbar leftButtonToolbar, IRelationEditorActionAccess editorAccess) {
        JPanel pnl = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(editorAccess.getMemberTable());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 2;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Members", new Object[0])), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridheight = 2;
        gc.gridwidth = 1;
        gc.fill = 3;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        pnl.add((Component)new ScrollViewport(leftButtonToolbar, 3), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.6;
        gc.weighty = 1.0;
        pnl.add((Component)scrollPane, gc);
        JPanel p3 = new JPanel(new FlowLayout(0));
        p3.add(new JLabel(I18n.tr("Apply Role:", new Object[0])));
        p3.add(editorAccess.getTextFieldRole());
        SetRoleAction setRoleAction = new SetRoleAction(editorAccess);
        editorAccess.getMemberTableModel().getSelectionModel().addListSelectionListener(setRoleAction);
        editorAccess.getTextFieldRole().getDocument().addDocumentListener(setRoleAction);
        editorAccess.getTextFieldRole().addActionListener(setRoleAction);
        editorAccess.getMemberTableModel().getSelectionModel().addListSelectionListener(e -> editorAccess.getTextFieldRole().setEnabled(editorAccess.getMemberTable().getSelectedRowCount() > 0));
        editorAccess.getTextFieldRole().setEnabled(editorAccess.getMemberTable().getSelectedRowCount() > 0);
        JButton btnApply = new JButton(setRoleAction);
        btnApply.setPreferredSize(new Dimension(20, 20));
        btnApply.setText("");
        p3.add(btnApply);
        gc.gridx = 1;
        gc.gridy = 2;
        gc.fill = 2;
        gc.anchor = 25;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        pnl.add((Component)p3, gc);
        JPanel pnl2 = new JPanel(new GridBagLayout());
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridwidth = 3;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        pnl2.add((Component)new JLabel(I18n.tr("Selection", new Object[0])), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 3;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        pnl2.add((Component)new ScrollViewport(GenericRelationEditor.buildSelectionControlButtonToolbar(editorAccess), 3), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl2.add((Component)GenericRelationEditor.buildSelectionTablePanel(editorAccess.getSelectionTable()), gc);
        final JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(pnl);
        splitPane.setRightComponent(pnl2);
        splitPane.setOneTouchExpandable(false);
        if (editorAccess.getEditor() instanceof Window) {
            ((Window)((Object)editorAccess.getEditor())).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    splitPane.setDividerLocation(0.6);
                }
            });
        }
        JPanel pnl3 = new JPanel(new BorderLayout());
        pnl3.add((Component)splitPane, "Center");
        return pnl3;
    }

    protected static JPanel buildSelectionTablePanel(SelectionTable selectionTable) {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)new JScrollPane(selectionTable), "Center");
        return pnl;
    }

    protected static JSplitPane buildSplitPane(JPanel top, JPanel bottom, IRelationEditor re) {
        final JSplitPane pane = new JSplitPane(0);
        pane.setTopComponent(top);
        pane.setBottomComponent(bottom);
        pane.setOneTouchExpandable(true);
        if (re instanceof Window) {
            ((Window)((Object)re)).addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    pane.setDividerLocation(0.3);
                }
            });
        }
        return pane;
    }

    protected static JToolBar buildSelectionControlButtonToolbar(IRelationEditorActionAccess editorAccess) {
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        ArrayList<IRelationEditorActionGroup> groups = new ArrayList<IRelationEditorActionGroup>();
        groups.add(GenericRelationEditor.buildNativeGroup(10, new AddSelectedAtStartAction(editorAccess), new AddSelectedBeforeSelection(editorAccess), new AddSelectedAfterSelection(editorAccess), new AddSelectedAtEndAction(editorAccess)));
        groups.add(GenericRelationEditor.buildNativeGroup(20, new SelectedMembersForSelectionAction(editorAccess), new SelectPrimitivesForSelectedMembersAction(editorAccess)));
        groups.add(GenericRelationEditor.buildNativeGroup(30, new RemoveSelectedAction(editorAccess)));
        groups.addAll(RelationEditorHooks.getSelectActions());
        IRelationEditorActionGroup.fillToolbar(tb, groups, editorAccess);
        return tb;
    }

    private static IRelationEditorActionGroup buildNativeGroup(final int order, final AbstractRelationEditorAction ... actions) {
        return new IRelationEditorActionGroup(){

            @Override
            public int order() {
                return order;
            }

            @Override
            public List<AbstractRelationEditorAction> getActions(IRelationEditorActionAccess editorAccess) {
                return Arrays.asList(actions);
            }
        };
    }

    @Override
    protected Dimension findMaxDialogSize() {
        return new Dimension(700, 650);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        if (visible) {
            this.tagEditorPanel.initAutoCompletion(this.getLayer());
        }
        super.setVisible(visible);
        Clipboard clipboard = ClipboardUtils.getClipboard();
        if (visible) {
            RelationDialogManager.getRelationDialogManager().positionOnScreen(this);
            if (this.windowMenuItem == null) {
                this.windowMenuItem = GenericRelationEditor.addToWindowMenu(this, this.getLayer().getName());
            }
            this.tagEditorPanel.requestFocusInWindow();
            for (FlavorListener listener : this.clipboardListeners) {
                clipboard.addFlavorListener(listener);
            }
        } else {
            this.memberTable.stopHighlighting();
            this.selectionTableModel.unregister();
            this.memberTableModel.unregister();
            this.memberTable.unregisterListeners();
            if (this.windowMenuItem != null) {
                MainApplication.getMenu().windowMenu.remove(this.windowMenuItem);
                this.windowMenuItem = null;
            }
            for (FlavorListener listener : this.clipboardListeners) {
                clipboard.removeFlavorListener(listener);
            }
            this.dispose();
        }
    }

    protected static JMenuItem addToWindowMenu(IRelationEditor re, String layerName) {
        Relation r = re.getRelation();
        String name = r == null ? I18n.tr("New relation", new Object[0]) : r.getLocalName();
        JosmAction focusAction = new JosmAction(I18n.tr("Relation Editor: {0}", name == null && r != null ? Long.valueOf(r.getId()) : name), "dialogs/relationlist", I18n.tr("Focus Relation Editor with relation ''{0}'' in layer ''{1}''", name, layerName), null, false, false){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((RelationEditor)this.getValue("relationEditor")).setVisible(true);
            }
        };
        focusAction.putValue("relationEditor", re);
        return MainMenu.add(MainApplication.getMenu().windowMenu, focusAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
    }

    protected static void cleanSelfReferences(MemberTableModel memberTableModel, Relation relation) {
        ArrayList<OsmPrimitive> toCheck = new ArrayList<OsmPrimitive>();
        toCheck.add(relation);
        if (memberTableModel.hasMembersReferringTo(toCheck)) {
            int ret = ConditionalOptionPaneUtil.showOptionDialog("clean_relation_self_references", MainApplication.getMainFrame(), I18n.tr("<html>There is at least one member in this relation referring<br>to the relation itself.<br>This creates circular dependencies and is discouraged.<br>How do you want to proceed with circular dependencies?</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 0, 2, new String[]{I18n.tr("Remove them, clean up relation", new Object[0]), I18n.tr("Ignore them, leave relation as is", new Object[0])}, I18n.tr("Remove them, clean up relation", new Object[0]));
            switch (ret) {
                case -2147483648: 
                case -1: 
                case 1: {
                    return;
                }
                case 0: {
                    memberTableModel.removeMembersReferringTo(toCheck);
                    break;
                }
            }
        }
    }

    private void registerCopyPasteAction(AbstractAction action, Object actionName, KeyStroke shortcut, JRootPane rootPane, JTable ... tables) {
        if (shortcut == null) {
            Logging.warn("No shortcut provided for the Paste action in Relation editor dialog");
        } else {
            int mods = shortcut.getModifiers();
            int code = shortcut.getKeyCode();
            if (code != 155 && (mods == 0 || mods == 64)) {
                Logging.info(I18n.tr("Sorry, shortcut \"{0}\" can not be enabled in Relation editor dialog", new Object[0]), shortcut);
                return;
            }
        }
        rootPane.getActionMap().put(actionName, action);
        if (shortcut != null) {
            rootPane.getInputMap(2).put(shortcut, actionName);
            for (JTable table : tables) {
                table.getInputMap(0).put(shortcut, actionName);
                table.getInputMap(1).put(shortcut, actionName);
                table.getInputMap(2).put(shortcut, actionName);
            }
        }
        if (action instanceof FlavorListener) {
            this.clipboardListeners.add((FlavorListener)((Object)action));
        }
    }

    public static boolean confirmAddingPrimitive(OsmPrimitive primitive) throws AddAbortException {
        String msg = I18n.tr("<html>This relation already has one or more members referring to<br>the object ''{0}''<br><br>Do you really want to add another relation member?</html>", Utils.escapeReservedCharactersHTML(primitive.getDisplayName(DefaultNameFormatter.getInstance())));
        int ret = ConditionalOptionPaneUtil.showOptionDialog("add_primitive_to_relation", MainApplication.getMainFrame(), msg, I18n.tr("Multiple members referring to same object.", new Object[0]), 1, 2, null, null);
        switch (ret) {
            case -2147483648: 
            case 0: {
                return true;
            }
            case -1: 
            case 1: {
                return false;
            }
        }
        throw new AddAbortException();
    }

    public static void warnOfCircularReferences(OsmPrimitive primitive) {
        String msg = I18n.tr("<html>You are trying to add a relation to itself.<br><br>This creates circular references and is therefore discouraged.<br>Skipping relation ''{0}''.</html>", Utils.escapeReservedCharactersHTML(primitive.getDisplayName(DefaultNameFormatter.getInstance())));
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), msg, I18n.tr("Warning", new Object[0]), 2);
    }

    public static Command addPrimitivesToRelation(Relation orig, Collection<? extends OsmPrimitive> primitivesToAdd) {
        CheckParameterUtil.ensureParameterNotNull(orig, "orig");
        try {
            Collection<TaggingPreset> presets = TaggingPresets.getMatchingPresets(EnumSet.of(TaggingPresetType.forPrimitive(orig)), orig.getKeys(), false);
            Relation relation = new Relation(orig);
            boolean modified = false;
            for (OsmPrimitive osmPrimitive : primitivesToAdd) {
                if (osmPrimitive instanceof Relation && orig.equals(osmPrimitive)) {
                    if (GraphicsEnvironment.isHeadless()) continue;
                    GenericRelationEditor.warnOfCircularReferences(osmPrimitive);
                    continue;
                }
                if (MemberTableModel.hasMembersReferringTo(relation.getMembers(), Collections.singleton(osmPrimitive)) && !GenericRelationEditor.confirmAddingPrimitive(osmPrimitive)) continue;
                Set<String> roles = GenericRelationEditor.findSuggestedRoles(presets, osmPrimitive);
                relation.addMember(new RelationMember(roles.size() == 1 ? roles.iterator().next() : "", osmPrimitive));
                modified = true;
            }
            return modified ? new ChangeCommand(orig, relation) : null;
        }
        catch (AddAbortException ign) {
            Logging.trace(ign);
            return null;
        }
    }

    protected static Set<String> findSuggestedRoles(Collection<TaggingPreset> presets, OsmPrimitive p) {
        HashSet<String> roles = new HashSet<String>();
        for (TaggingPreset preset : presets) {
            String role = preset.suggestRoleForOsmPrimitive(p);
            if (role == null || role.isEmpty()) continue;
            roles.add(role);
        }
        return roles;
    }

    private class RelationEditorActionAccess
    implements IRelationEditorActionAccess {
        private RelationEditorActionAccess() {
        }

        @Override
        public MemberTable getMemberTable() {
            return GenericRelationEditor.this.memberTable;
        }

        @Override
        public MemberTableModel getMemberTableModel() {
            return GenericRelationEditor.this.memberTableModel;
        }

        @Override
        public SelectionTable getSelectionTable() {
            return GenericRelationEditor.this.selectionTable;
        }

        @Override
        public SelectionTableModel getSelectionTableModel() {
            return GenericRelationEditor.this.selectionTableModel;
        }

        @Override
        public IRelationEditor getEditor() {
            return GenericRelationEditor.this;
        }

        @Override
        public TagEditorModel getTagModel() {
            return GenericRelationEditor.this.tagEditorPanel.getModel();
        }

        @Override
        public AutoCompletingTextField getTextFieldRole() {
            return GenericRelationEditor.this.tfRole;
        }
    }

    class MemberTableDblClickAdapter
    extends MouseAdapter {
        MemberTableDblClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                new EditAction(new RelationEditorActionAccess()).actionPerformed(null);
            }
        }
    }

    public static class AddAbortException
    extends Exception {
    }

    static class LeftButtonToolbar
    extends JToolBar {
        private static final long serialVersionUID = 1L;

        LeftButtonToolbar(IRelationEditorActionAccess editorAccess) {
            this.setOrientation(1);
            this.setFloatable(false);
            ArrayList<IRelationEditorActionGroup> groups = new ArrayList<IRelationEditorActionGroup>();
            groups.add(GenericRelationEditor.buildNativeGroup(10, new AbstractRelationEditorAction[]{new MoveUpAction(editorAccess, "moveUp"), new MoveDownAction(editorAccess, "moveDown")}));
            groups.add(GenericRelationEditor.buildNativeGroup(20, new AbstractRelationEditorAction[]{new EditAction(editorAccess), new RemoveAction(editorAccess, "removeSelected")}));
            groups.add(GenericRelationEditor.buildNativeGroup(30, new AbstractRelationEditorAction[]{new SortAction(editorAccess), new SortBelowAction(editorAccess)}));
            groups.add(GenericRelationEditor.buildNativeGroup(40, new AbstractRelationEditorAction[]{new ReverseAction(editorAccess)}));
            groups.add(GenericRelationEditor.buildNativeGroup(50, new AbstractRelationEditorAction[]{new DownloadIncompleteMembersAction(editorAccess, "downloadIncomplete"), new DownloadSelectedIncompleteMembersAction(editorAccess)}));
            groups.addAll(RelationEditorHooks.getMemberActions());
            IRelationEditorActionGroup.fillToolbar(this, groups, editorAccess);
            InputMap inputMap = editorAccess.getMemberTable().getInputMap(1);
            inputMap.put((KeyStroke)new RemoveAction(editorAccess, "removeSelected").getValue("AcceleratorKey"), "removeSelected");
            inputMap.put((KeyStroke)new MoveUpAction(editorAccess, "moveUp").getValue("AcceleratorKey"), "moveUp");
            inputMap.put((KeyStroke)new MoveDownAction(editorAccess, "moveDown").getValue("AcceleratorKey"), "moveDown");
            inputMap.put((KeyStroke)new DownloadIncompleteMembersAction(editorAccess, "downloadIncomplete").getValue("AcceleratorKey"), "downloadIncomplete");
        }
    }
}

