/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TokenRegister;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DTLcleardb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLcolumncount;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdeletedb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLforeach;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifDbEmpty;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifDbExists;
import com.dickimawbooks.texparserlib.latex.datatool.DTLloaddb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLloaddbtex;
import com.dickimawbooks.texparserlib.latex.datatool.DTLmessage;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewdb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewdbentry;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewrow;
import com.dickimawbooks.texparserlib.latex.datatool.DTLrowcount;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetExpansion;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetdelimiter;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetseparator;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsettabseparator;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataCurrencyElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataIntElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataRealElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataStringElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntryRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeaderRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolRows;
import com.dickimawbooks.texparserlib.latex.ifthen.IfThenSty;
import com.dickimawbooks.texparserlib.primitives.EndGraf;
import com.dickimawbooks.texparserlib.primitives.IfFalse;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class DataToolSty
extends LaTeXSty {
    private int separator = 44;
    private int delimiter = 34;
    private DataToolBaseSty dataToolBaseSty;
    private ConcurrentHashMap<String, DataBase> databases;
    public static final String ERROR_DB_EXISTS = "datatool.db_exists";
    public static final String ERROR_DB_DOESNT_EXIST = "datatool.db_doesnt_exist";
    public static final String ERROR_MISMATCHED = "datatool.mismatched";
    public static final String ERROR_HEADER_EXISTS = "datatool.header.exists";
    public static final String ERROR_HEADER_DOESNT_EXIST = "datatool.header.doesnt_exist";
    public static final String ERROR_INVALID_HEADER = "datatool.invalid.header";
    public static final String ERROR_INVALID_CONTENTS = "datatool.invalid.contents";
    public static final String ERROR_ROW_NOT_FOUND = "datatool.row.not.found";
    public static final String MESSAGE_LOADDB = "datatool.loaddb.message";

    public DataToolSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "datatool", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new DTLifDbExists(this));
        this.registerControlSequence(new DTLifDbEmpty(this));
        this.registerControlSequence(new DTLnewdb(this));
        this.registerControlSequence(new DTLnewdb("DTLgnewdb", true, this));
        this.registerControlSequence(new DTLnewrow(this));
        this.registerControlSequence(new DTLcleardb(this));
        this.registerControlSequence(new DTLcleardb("DTLgcleardb", true, this));
        this.registerControlSequence(new DTLdeletedb(this));
        this.registerControlSequence(new DTLdeletedb("DTLgdeletedb", true, this));
        this.registerControlSequence(new DTLrowcount(this));
        this.registerControlSequence(new DTLcolumncount(this));
        this.registerControlSequence(new DTLnewdbentry(this));
        this.registerControlSequence(new DTLmessage());
        this.registerControlSequence(new DTLforeach(this));
        this.registerControlSequence(new DTLsetdelimiter(this));
        this.registerControlSequence(new DTLsetseparator(this));
        this.registerControlSequence(new DTLsettabseparator(this));
        this.registerControlSequence(new DTLsetExpansion("dtlexpandnewvalue", true, this));
        this.registerControlSequence(new DTLsetExpansion("dtlnoexpandnewvalue", false, this));
        this.registerControlSequence(new EndGraf("DTLpar"));
        this.registerControlSequence(new DTLloaddbtex());
        this.registerControlSequence(new DTLloaddb(this));
        this.registerControlSequence(new GenericCommand("dtldefaultkey", null, this.getListener().createString("Column")));
        this.registerControlSequence(new GenericCommand("DTLunsettype"));
        this.registerControlSequence(new GenericCommand("DTLstringtype", null, new UserNumber(0)));
        this.registerControlSequence(new GenericCommand("DTLinttype", null, new UserNumber(1)));
        this.registerControlSequence(new GenericCommand("DTLrealtype", null, new UserNumber(2)));
        this.registerControlSequence(new GenericCommand("DTLcurrencytype", null, new UserNumber(3)));
    }

    @Override
    protected void preOptions() throws IOException {
        this.getListener().requirepackage(null, "etoolbox", false);
        this.dataToolBaseSty = (DataToolBaseSty)this.getListener().requirepackage(null, "datatool-base", true);
    }

    public static String getContentsRegisterName(String string) {
        return String.format("dtldb@%s", string);
    }

    public static String getHeaderRegisterName(String string) {
        return String.format("dtlkeys@%s", string);
    }

    public static String getRowCountRegisterName(String string) {
        return String.format("dtlrows@%s", string);
    }

    public static String getColumnCountRegisterName(String string) {
        return String.format("dtlcols@%s", string);
    }

    public static String getColumnHeaderName(String string, String string2) {
        return String.format("dtl@ci@%s@%s", string, string2);
    }

    public static String getColumnHeaderName(String string, DataToolHeader dataToolHeader) {
        return DataToolSty.getColumnHeaderName(string, dataToolHeader.getColumnLabel());
    }

    public int getRowCount(String string) throws IOException {
        DataBase dataBase = this.update(string);
        return dataBase.getRowCount();
    }

    public int getColumnCount(String string) throws IOException {
        DataBase dataBase = this.update(string);
        return dataBase.getColumnCount();
    }

    public void setExpansion(boolean bl) {
        if (bl) {
            this.getListener().getParser().putControlSequence(true, new IfTrue("if@dtl@expansion@on"));
        } else {
            this.getListener().getParser().putControlSequence(true, new IfFalse("if@dtl@expansion@on"));
        }
    }

    public boolean isExpansionOn() {
        ControlSequence controlSequence = this.getListener().getParser().getControlSequence("if@dtl@expansion@on");
        return controlSequence instanceof IfTrue;
    }

    public boolean dbExists(String string) {
        ControlSequence controlSequence = this.getListener().getParser().getControlSequence(DataToolSty.getContentsRegisterName(string));
        return controlSequence != null;
    }

    public boolean dbEmpty(String string) throws IOException {
        return this.getRowCount(string) == 0;
    }

    public DataBase createDataBase(String string, boolean bl) throws TeXSyntaxException {
        TeXParser teXParser = this.getListener().getParser();
        if (this.dbExists(string)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DB_EXISTS, string);
        }
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.newtoks(bl, DataToolSty.getContentsRegisterName(string));
        teXSettings.newtoks(bl, DataToolSty.getHeaderRegisterName(string));
        teXSettings.newcount(bl, DataToolSty.getRowCountRegisterName(string));
        teXSettings.newcount(bl, DataToolSty.getColumnCountRegisterName(string));
        DataBase dataBase = new DataBase(string);
        if (this.databases == null) {
            this.databases = new ConcurrentHashMap();
        }
        this.databases.put(string, dataBase);
        return dataBase;
    }

    public DataBase getDataBase(String string) throws IOException {
        DataBase dataBase = null;
        if (this.databases != null) {
            dataBase = this.databases.get(string);
        }
        if (dataBase == null) {
            dataBase = this.update(string);
        }
        return dataBase;
    }

    public DataBase clearDataBase(String string, boolean bl) throws TeXSyntaxException {
        TeXParser teXParser = this.getListener().getParser();
        DataBase dataBase = null;
        if (this.databases == null) {
            this.databases = new ConcurrentHashMap();
        } else {
            dataBase = this.databases.get(string);
        }
        TeXSettings teXSettings = teXParser.getSettings();
        if (dataBase != null) {
            DataToolHeaderRow dataToolHeaderRow = dataBase.getHeaders();
            for (DataToolHeader dataToolHeader : dataToolHeaderRow) {
                if (bl) {
                    teXSettings.removeGlobalControlSequence(DataToolSty.getColumnHeaderName(string, dataToolHeader));
                    continue;
                }
                teXSettings.removeLocalControlSequence(DataToolSty.getColumnHeaderName(string, dataToolHeader));
            }
        }
        if (bl) {
            teXSettings.globalSetRegister(DataToolSty.getContentsRegisterName(string), new TeXObjectList());
            teXSettings.globalSetRegister(DataToolSty.getHeaderRegisterName(string), new TeXObjectList());
            teXSettings.globalSetRegister(DataToolSty.getRowCountRegisterName(string), (TeXObject)new UserNumber(0));
            teXSettings.globalSetRegister(DataToolSty.getColumnCountRegisterName(string), (TeXObject)new UserNumber(0));
        } else {
            teXSettings.localSetRegister(DataToolSty.getContentsRegisterName(string), new TeXObjectList());
            teXSettings.localSetRegister(DataToolSty.getHeaderRegisterName(string), new TeXObjectList());
            teXSettings.localSetRegister(DataToolSty.getRowCountRegisterName(string), (TeXObject)new UserNumber(0));
            teXSettings.localSetRegister(DataToolSty.getColumnCountRegisterName(string), (TeXObject)new UserNumber(0));
        }
        if (dataBase == null) {
            dataBase = new DataBase(string);
            this.databases.put(string, dataBase);
        } else {
            dataBase.update(null, null);
        }
        return dataBase;
    }

    public DataToolEntryRow addNewRow(String string) throws IOException {
        DataToolRows dataToolRows = this.getContents(string);
        DataToolEntryRow dataToolEntryRow = new DataToolEntryRow(this);
        dataToolRows.add(dataToolEntryRow);
        this.update(string, dataToolRows);
        return dataToolEntryRow;
    }

    public DataToolHeader addNewColumn(String string, String string2) throws IOException {
        DataToolHeaderRow dataToolHeaderRow = this.getHeaderContents(string);
        DataToolHeader dataToolHeader = dataToolHeaderRow.getHeader(string2);
        if (dataToolHeader != null) {
            throw new LaTeXSyntaxException(this.getListener().getParser(), ERROR_HEADER_EXISTS, string2);
        }
        dataToolHeader = new DataToolHeader(this, dataToolHeaderRow.getMaxIndex() + 1, string2);
        dataToolHeaderRow.add(dataToolHeader);
        this.update(string, dataToolHeaderRow);
        return dataToolHeader;
    }

    public DataElement getElement(TeXObject teXObject) throws IOException {
        Object object;
        TeXParser teXParser = this.getListener().getParser();
        if (teXObject instanceof TeXObjectList) {
            object = (TeXObjectList)teXObject;
            TeXObject teXObject2 = ((TeXObjectList)object).peekStack();
            if (teXObject2 == null) {
                return null;
            }
            if (this.dataToolBaseSty.isCurrencySymbol(teXObject2)) {
                teXObject2 = ((TeXObjectList)object).popStack(teXParser);
                try {
                    return new DataCurrencyElement(this, teXObject2, Double.parseDouble(((TeXObjectList)object).toString(teXParser).trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    ((TeXObjectList)object).add(0, teXObject2);
                    return new DataStringElement((TeXObjectList)object);
                }
            }
        }
        object = teXObject.toString(teXParser).trim();
        try {
            return new DataIntElement(this, Integer.parseInt((String)object));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new DataRealElement(this, Double.parseDouble((String)object));
            }
            catch (NumberFormatException numberFormatException2) {
                if (teXObject instanceof TeXObjectList) {
                    return new DataStringElement((TeXObjectList)teXObject);
                }
                DataStringElement dataStringElement = new DataStringElement();
                dataStringElement.add(teXObject);
                return dataStringElement;
            }
        }
    }

    public DataToolEntry addNewEntry(String string, String string2, TeXObject teXObject) throws IOException {
        DataToolEntryRow dataToolEntryRow;
        DataToolRows dataToolRows = this.getContents(string);
        DataToolHeaderRow dataToolHeaderRow = this.getHeaderContents(string);
        if (dataToolRows.size() == 0) {
            dataToolEntryRow = new DataToolEntryRow(this);
            dataToolRows.add(dataToolEntryRow);
        } else {
            dataToolEntryRow = (DataToolEntryRow)dataToolRows.lastElement();
        }
        DataToolHeader dataToolHeader = dataToolHeaderRow.getHeader(string2);
        if (dataToolHeader == null) {
            dataToolHeader = new DataToolHeader(this, dataToolHeaderRow.getMaxIndex() + 1, string2);
            dataToolHeaderRow.add(dataToolHeader);
        }
        DataToolEntry dataToolEntry = new DataToolEntry(this, dataToolHeader.getColumnIndex(), teXObject);
        dataToolEntryRow.add(dataToolEntry);
        TeXObject teXObject2 = dataToolEntry.getContents();
        if (teXObject2 instanceof DataElement) {
            dataToolHeader.updateType((DataElement)teXObject2);
        }
        this.update(string, dataToolRows);
        return dataToolEntry;
    }

    public void removeDataBase(String string, boolean bl) {
        DataBase dataBase = null;
        if (this.databases != null) {
            dataBase = this.databases.remove(string);
        }
        TeXSettings teXSettings = this.getListener().getParser().getSettings();
        if (dataBase != null) {
            DataToolHeaderRow dataToolHeaderRow = dataBase.getHeaders();
            for (DataToolHeader dataToolHeader : dataToolHeaderRow) {
                if (bl) {
                    teXSettings.removeGlobalControlSequence(DataToolSty.getColumnHeaderName(string, dataToolHeader));
                    continue;
                }
                teXSettings.removeLocalControlSequence(DataToolSty.getColumnHeaderName(string, dataToolHeader));
            }
        }
        if (bl) {
            teXSettings.removeGlobalControlSequence(DataToolSty.getContentsRegisterName(string));
            teXSettings.removeGlobalControlSequence(DataToolSty.getHeaderRegisterName(string));
            teXSettings.removeGlobalControlSequence(DataToolSty.getRowCountRegisterName(string));
            teXSettings.removeGlobalControlSequence(DataToolSty.getColumnCountRegisterName(string));
        } else {
            teXSettings.removeLocalControlSequence(DataToolSty.getContentsRegisterName(string));
            teXSettings.removeLocalControlSequence(DataToolSty.getHeaderRegisterName(string));
            teXSettings.removeLocalControlSequence(DataToolSty.getRowCountRegisterName(string));
            teXSettings.removeLocalControlSequence(DataToolSty.getColumnCountRegisterName(string));
        }
    }

    public DataToolHeaderRow getHeaderContents(String string) throws IOException {
        TeXParser teXParser = this.getListener().getParser();
        ControlSequence controlSequence = teXParser.getControlSequence(DataToolSty.getHeaderRegisterName(string));
        if (controlSequence == null || !(controlSequence instanceof TokenRegister)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DB_DOESNT_EXIST, string);
        }
        TokenRegister tokenRegister = (TokenRegister)controlSequence;
        TeXObject teXObject = tokenRegister.getContents(teXParser);
        if (teXObject instanceof DataToolHeaderRow) {
            return (DataToolHeaderRow)teXObject;
        }
        if (!(teXObject instanceof TeXObjectList)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_HEADER, teXObject.toString(teXParser));
        }
        DataToolHeaderRow dataToolHeaderRow = DataToolHeaderRow.toHeaderRow(teXParser, (TeXObjectList)teXObject, this);
        tokenRegister.setContents(teXParser, dataToolHeaderRow);
        return dataToolHeaderRow;
    }

    public DataToolRows getContents(String string) throws IOException {
        DataToolRows dataToolRows;
        TeXParser teXParser = this.getListener().getParser();
        ControlSequence controlSequence = teXParser.getControlSequence(DataToolSty.getContentsRegisterName(string));
        if (controlSequence == null || !(controlSequence instanceof TokenRegister)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DB_DOESNT_EXIST, string);
        }
        TokenRegister tokenRegister = (TokenRegister)controlSequence;
        TeXObject teXObject = tokenRegister.getContents(teXParser);
        if (teXObject instanceof DataToolRows) {
            return (DataToolRows)teXObject;
        }
        if (!(teXObject instanceof TeXObjectList)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONTENTS, teXObject);
        }
        int n = ((TeXObjectList)teXObject).size();
        if (n == 0) {
            dataToolRows = new DataToolRows(this);
        } else {
            controlSequence = teXParser.getControlSequence(DataToolSty.getRowCountRegisterName(string));
            int n2 = 0;
            if (controlSequence instanceof CountRegister) {
                n2 = ((CountRegister)controlSequence).getValue();
            }
            dataToolRows = DataToolRows.toRows(teXParser, (TeXObjectList)teXObject, this, n2);
        }
        tokenRegister.setContents(teXParser, dataToolRows);
        return dataToolRows;
    }

    protected synchronized DataBase update(String string) throws IOException {
        return this.update(string, this.getHeaderContents(string), this.getContents(string));
    }

    protected synchronized DataBase update(String string, DataToolHeaderRow dataToolHeaderRow) throws IOException {
        return this.update(string, dataToolHeaderRow, this.getContents(string));
    }

    protected synchronized DataBase update(String string, DataToolRows dataToolRows) throws IOException {
        return this.update(string, this.getHeaderContents(string), dataToolRows);
    }

    protected synchronized DataBase update(String string, DataToolHeaderRow dataToolHeaderRow, DataToolRows dataToolRows) throws TeXSyntaxException {
        DataBase dataBase = null;
        if (this.databases == null) {
            this.databases = new ConcurrentHashMap();
        } else {
            dataBase = this.databases.get(string);
        }
        if (dataBase == null) {
            dataBase = new DataBase(string, dataToolHeaderRow, dataToolRows);
            this.databases.put(string, dataBase);
        } else {
            dataBase.update(dataToolHeaderRow, dataToolRows);
        }
        TeXParser teXParser = this.getListener().getParser();
        ControlSequence controlSequence = teXParser.getControlSequence(DataToolSty.getColumnCountRegisterName(string));
        if (controlSequence == null || !(controlSequence instanceof CountRegister)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DB_DOESNT_EXIST, string);
        }
        ((CountRegister)controlSequence).setValue(dataBase.getColumnCount());
        controlSequence = teXParser.getControlSequence(DataToolSty.getRowCountRegisterName(string));
        if (controlSequence == null || !(controlSequence instanceof CountRegister)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DB_DOESNT_EXIST, string);
        }
        ((CountRegister)controlSequence).setValue(dataBase.getRowCount());
        return dataBase;
    }

    public DataToolBaseSty getDataToolBaseSty() {
        return this.dataToolBaseSty;
    }

    public IfThenSty getIfThenSty() {
        return this.dataToolBaseSty.getIfThenSty();
    }

    public Iterator<String> getDataBaseKeySetIterator() {
        return this.databases == null ? null : ((ConcurrentHashMap.KeySetView)this.databases.keySet()).iterator();
    }

    public int getSeparator() {
        return this.separator;
    }

    public int getDelimiter() {
        return this.delimiter;
    }

    public void setSeparator(int n) {
        this.separator = n;
    }

    public void setDelimiter(int n) {
        this.delimiter = n;
    }
}

