/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.ChangesetDiscussionComment;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class Changeset
implements Tagged,
Comparable<Changeset> {
    public static final int MAX_CHANGESET_TAG_LENGTH = 255;
    private int id;
    private User user;
    private Date createdAt;
    private Date closedAt;
    private boolean open;
    private LatLon min;
    private LatLon max;
    private int commentsCount;
    private Map<String, String> tags;
    private boolean incomplete;
    private ChangesetDataSet content;
    private List<ChangesetDiscussionComment> discussion;

    public Changeset() {
        this(0);
    }

    public Changeset(int id) {
        this.id = id;
        this.incomplete = id > 0;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(Changeset other) {
        if (other == null) {
            this.id = 0;
            this.tags = new HashMap<String, String>();
        } else if (other.isIncomplete()) {
            this.setId(other.getId());
            this.incomplete = true;
            this.tags = new HashMap<String, String>();
        } else {
            this.id = other.id;
            this.mergeFrom(other);
            this.incomplete = false;
        }
    }

    public static Changeset fromPrimitive(OsmPrimitive primitive) {
        Changeset changeset = new Changeset(primitive.getChangesetId());
        changeset.setUser(primitive.getUser());
        changeset.setCreatedAt(primitive.getTimestamp());
        return changeset;
    }

    @Override
    public int compareTo(Changeset other) {
        return Integer.compare(this.getId(), other.getId());
    }

    public String getName() {
        return "changeset " + this.getId();
    }

    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getCreatedAt() {
        return DateUtils.cloneDate(this.createdAt);
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = DateUtils.cloneDate(createdAt);
    }

    public Date getClosedAt() {
        return DateUtils.cloneDate(this.closedAt);
    }

    public void setClosedAt(Date closedAt) {
        this.closedAt = DateUtils.cloneDate(closedAt);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public LatLon getMin() {
        return this.min;
    }

    public void setMin(LatLon min) {
        this.min = min;
    }

    public LatLon getMax() {
        return this.max;
    }

    public void setMax(LatLon max) {
        this.max = max;
    }

    public Bounds getBounds() {
        if (this.min != null && this.max != null) {
            return new Bounds(this.min, this.max);
        }
        return null;
    }

    public String getComment() {
        return Optional.ofNullable(this.get("comment")).orElse("");
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public void setCommentsCount(int commentsCount) {
        this.commentsCount = commentsCount;
    }

    @Override
    public Map<String, String> getKeys() {
        return this.tags;
    }

    @Override
    public void setKeys(Map<String, String> keys) {
        CheckParameterUtil.ensureParameterNotNull(keys, "keys");
        keys.values().stream().filter(value -> value != null && value.length() > 255).findFirst().ifPresent(value -> {
            throw new IllegalArgumentException("Changeset tag value is too long: " + value);
        });
        this.tags = keys;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    @Override
    public void put(String key, String value) {
        CheckParameterUtil.ensureParameterNotNull(key, "key");
        if (value != null && value.length() > 255) {
            throw new IllegalArgumentException("Changeset tag value is too long: " + value);
        }
        this.tags.put(key, value);
    }

    @Override
    public String get(String key) {
        return this.tags.get(key);
    }

    @Override
    public void remove(String key) {
        this.tags.remove(key);
    }

    @Override
    public void removeAll() {
        this.tags.clear();
    }

    public boolean hasEqualSemanticAttributes(Changeset other) {
        if (other == null) {
            return false;
        }
        if (this.closedAt == null ? other.closedAt != null : !this.closedAt.equals(other.closedAt)) {
            return false;
        }
        if (this.createdAt == null ? other.createdAt != null : !this.createdAt.equals(other.createdAt)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
            return false;
        }
        if (this.open != other.open) {
            return false;
        }
        if (!this.tags.equals(other.tags)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        return this.commentsCount == other.commentsCount;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)obj;
        return this.id == changeset.id;
    }

    @Override
    public boolean hasKeys() {
        return !this.tags.keySet().isEmpty();
    }

    @Override
    public Collection<String> keySet() {
        return this.tags.keySet();
    }

    @Override
    public int getNumKeys() {
        return this.tags.size();
    }

    public boolean isNew() {
        return this.id <= 0;
    }

    public void mergeFrom(Changeset other) {
        if (other == null) {
            return;
        }
        if (this.id != other.id) {
            return;
        }
        this.user = other.user;
        this.createdAt = DateUtils.cloneDate(other.createdAt);
        this.closedAt = DateUtils.cloneDate(other.closedAt);
        this.open = other.open;
        this.min = other.min;
        this.max = other.max;
        this.commentsCount = other.commentsCount;
        this.tags = new HashMap<String, String>(other.tags);
        this.incomplete = other.incomplete;
        this.discussion = other.discussion != null ? new ArrayList<ChangesetDiscussionComment>(other.discussion) : null;
        this.content = other.content;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ChangesetDataSet getContent() {
        return this.content;
    }

    public void setContent(ChangesetDataSet content) {
        this.content = content;
    }

    public synchronized List<ChangesetDiscussionComment> getDiscussion() {
        if (this.discussion == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ChangesetDiscussionComment>(this.discussion);
    }

    public synchronized void addDiscussionComment(ChangesetDiscussionComment comment) {
        if (comment == null) {
            return;
        }
        if (this.discussion == null) {
            this.discussion = new ArrayList<ChangesetDiscussionComment>();
        }
        this.discussion.add(comment);
    }
}

