/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.autofilter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.autofilter.AutoFilter;
import org.openstreetmap.josm.gui.autofilter.AutoFilterManager;

public class AutoFilterButton
extends JButton {
    private static final NamedColorProperty PROP_COLOR = new NamedColorProperty("auto.filter.button.color", new Color(0, 160, 160));
    private final AutoFilter filter;

    public AutoFilterButton(final AutoFilter filter) {
        super(new JosmAction(filter.getLabel(), null, filter.getDescription(), null, false){

            @Override
            public synchronized void actionPerformed(ActionEvent e) {
                AutoFilterManager afm = AutoFilterManager.getInstance();
                if (filter.equals(afm.getCurrentAutoFilter())) {
                    afm.setCurrentAutoFilter(null);
                    MainApplication.getMap().filterDialog.getFilterModel().executeFilters();
                } else {
                    afm.setCurrentAutoFilter(filter);
                }
            }
        });
        this.filter = filter;
        this.setForeground(Color.WHITE);
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getModel().isPressed()) {
            g.setColor(PROP_COLOR.get().darker().darker());
        } else if (this.getModel().isRollover() || AutoFilterManager.getInstance().getCurrentAutoFilter() == this.filter) {
            g.setColor(PROP_COLOR.get().darker());
        } else {
            g.setColor(PROP_COLOR.get());
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 3, 3);
        super.paintComponent(g);
    }
}

