/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTable;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;

public abstract class AbstractRelationEditorAction
extends AbstractAction
implements TableModelListener,
ListSelectionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected final transient IRelationEditorActionAccess editorAccess;

    protected AbstractRelationEditorAction(IRelationEditorActionAccess editorAccess, IRelationEditorUpdateOn ... updateOn) {
        Objects.requireNonNull(editorAccess, "editorAccess");
        Objects.requireNonNull(updateOn, "updateOn");
        this.editorAccess = editorAccess;
        for (IRelationEditorUpdateOn u : updateOn) {
            u.register(editorAccess, this);
        }
    }

    protected AbstractRelationEditorAction(IRelationEditorActionAccess editorAccess, String actionMapKey, IRelationEditorUpdateOn ... updateOn) {
        this(editorAccess, updateOn);
        Objects.requireNonNull(actionMapKey, "actionMapKey");
        this.editorAccess.addMemberTableAction(actionMapKey, this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateEnabledState();
    }

    protected abstract void updateEnabledState();

    protected final boolean canDownload() {
        if (this.editorAccess.getEditor().getRelation() == null) {
            return false;
        }
        DataSet ds = this.editorAccess.getEditor().getRelation().getDataSet();
        return !NetworkManager.isOffline(OnlineResource.OSM_API) && ds != null && !ds.isLocked() && !DownloadPolicy.BLOCKED.equals((Object)ds.getDownloadPolicy());
    }

    protected MemberTable getMemberTable() {
        return this.editorAccess.getMemberTable();
    }

    protected MemberTableModel getMemberTableModel() {
        return this.editorAccess.getMemberTableModel();
    }

    protected SelectionTable getSelectionTable() {
        return this.editorAccess.getSelectionTable();
    }

    protected SelectionTableModel getSelectionTableModel() {
        return this.editorAccess.getSelectionTableModel();
    }

    protected IRelationEditor getEditor() {
        return this.editorAccess.getEditor();
    }

    protected TagEditorModel getTagModel() {
        return this.editorAccess.getTagModel();
    }

    protected OsmDataLayer getLayer() {
        return this.editorAccess.getEditor().getLayer();
    }

    public boolean isExpertOnly() {
        return false;
    }
}

