/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.io.ProgressOutputStream;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class HttpClient {
    private URL url;
    private final String requestMethod;
    private int connectTimeout = (int)TimeUnit.SECONDS.toMillis(Config.getPref().getInt("socket.timeout.connect", 15));
    private int readTimeout = (int)TimeUnit.SECONDS.toMillis(Config.getPref().getInt("socket.timeout.read", 30));
    private byte[] requestBody;
    private long ifModifiedSince;
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private int maxRedirects = Config.getPref().getInt("socket.maxredirects", 5);
    private boolean useCache;
    private String reasonForRequest;
    private String outputMessage = I18n.tr("Uploading data ...", new Object[0]);
    private HttpURLConnection connection;
    private Response response;
    private boolean finishOnCloseOutput = true;
    private static final Pattern TOMCAT_ERR_MESSAGE = Pattern.compile(".*<p><b>[^<]+</b>[^<]+</p><p><b>[^<]+</b> (?:<u>)?([^<]*)(?:</u>)?</p><p><b>[^<]+</b> (?:<u>)?[^<]*(?:</u>)?</p>.*", 2);

    private HttpClient(URL url, String requestMethod) {
        this.url = url;
        this.requestMethod = requestMethod;
        this.headers.put("Accept-Encoding", "gzip");
    }

    public Response connect() throws IOException {
        return this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response connect(ProgressMonitor progressMonitor) throws IOException {
        HttpURLConnection connection;
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.connection = connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestMethod(this.requestMethod);
        connection.setRequestProperty("User-Agent", Version.getInstance().getFullAgentString());
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setInstanceFollowRedirects(false);
        if (this.ifModifiedSince > 0L) {
            connection.setIfModifiedSince(this.ifModifiedSince);
        }
        connection.setUseCaches(this.useCache);
        if (!this.useCache) {
            connection.setRequestProperty("Cache-Control", "no-cache");
        }
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            if (header.getValue() == null) continue;
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        progressMonitor.beginTask(I18n.tr("Contacting Server...", new Object[0]), 1);
        progressMonitor.indeterminateSubTask(null);
        if ("PUT".equals(this.requestMethod) || "POST".equals(this.requestMethod) || "DELETE".equals(this.requestMethod)) {
            Map.Entry<String, String> header;
            Logging.info("{0} {1} ({2}) ...", this.requestMethod, this.url, Utils.getSizeString(this.requestBody.length, Locale.getDefault()));
            if (Logging.isTraceEnabled() && this.requestBody.length > 0) {
                Logging.trace("BODY: {0}", new String(this.requestBody, StandardCharsets.UTF_8));
            }
            connection.setFixedLengthStreamingMode(this.requestBody.length);
            connection.setDoOutput(true);
            header = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new ProgressOutputStream(connection.getOutputStream(), this.requestBody.length, progressMonitor, this.outputMessage, this.finishOnCloseOutput));){
                ((OutputStream)out).write(this.requestBody);
            }
            catch (Throwable throwable) {
                header = throwable;
                throw throwable;
            }
        }
        boolean successfulConnection = false;
        try {
            try {
                connection.connect();
                boolean hasReason = this.reasonForRequest != null && !this.reasonForRequest.isEmpty();
                Logging.info("{0} {1}{2} -> {3}{4}", this.requestMethod, this.url, hasReason ? " (" + this.reasonForRequest + ')' : "", connection.getResponseCode(), connection.getContentLengthLong() > 0L ? " (" + Utils.getSizeString(connection.getContentLengthLong(), Locale.getDefault()) + ')' : "");
                if (Logging.isDebugEnabled()) {
                    Logging.debug("RESPONSE: {0}", connection.getHeaderFields());
                }
                if (DefaultAuthenticator.getInstance().isEnabled() && connection.getResponseCode() == 401) {
                    DefaultAuthenticator.getInstance().addFailedCredentialHost(this.url.getHost());
                }
            }
            catch (IOException | IllegalArgumentException | NoSuchElementException e) {
                Logging.info("{0} {1} -> !!!", this.requestMethod, this.url);
                Logging.warn(e);
                NetworkManager.addNetworkError(this.url, Utils.getRootCause(e));
                throw e;
            }
            if (HttpClient.isRedirect(connection.getResponseCode())) {
                String redirectLocation = connection.getHeaderField("Location");
                if (redirectLocation == null) {
                    throw new IOException(I18n.tr("Unexpected response from HTTP server. Got {0} response without ''Location'' header. Can''t redirect. Aborting.", connection.getResponseCode()));
                }
                if (this.maxRedirects > 0) {
                    this.url = new URL(this.url, redirectLocation);
                    --this.maxRedirects;
                    Logging.info(I18n.tr("Download redirected to ''{0}''", redirectLocation));
                    Response response = this.connect();
                    return response;
                }
                if (this.maxRedirects == 0) {
                    String msg = I18n.tr("Too many redirects to the download URL detected. Aborting.", new Object[0]);
                    throw new IOException(msg);
                }
            }
            this.response = new Response(connection, progressMonitor);
            successfulConnection = true;
            Response response = this.response;
            return response;
        }
        finally {
            if (!successfulConnection) {
                connection.disconnect();
            }
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public static HttpClient create(URL url) {
        return HttpClient.create(url, "GET");
    }

    public static HttpClient create(URL url, String requestMethod) {
        return new HttpClient(url, requestMethod);
    }

    public URL getURL() {
        return this.url;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestHeader(String header) {
        return this.headers.get(header);
    }

    public HttpClient useCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public HttpClient keepAlive(boolean keepAlive) {
        return this.setHeader("Connection", keepAlive ? null : "close");
    }

    public HttpClient setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public HttpClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpClient setAccept(String accept) {
        return this.setHeader("Accept", accept);
    }

    public HttpClient setRequestBody(byte[] requestBody) {
        this.requestBody = Utils.copyArray(requestBody);
        return this;
    }

    public HttpClient setIfModifiedSince(long ifModifiedSince) {
        this.ifModifiedSince = ifModifiedSince;
        return this;
    }

    public HttpClient setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    public HttpClient setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HttpClient setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public HttpClient setReasonForRequest(String reasonForRequest) {
        this.reasonForRequest = reasonForRequest;
        return this;
    }

    public HttpClient setOutputMessage(String outputMessage) {
        this.outputMessage = outputMessage;
        return this;
    }

    public HttpClient setFinishOnCloseOutput(boolean finishOnCloseOutput) {
        this.finishOnCloseOutput = finishOnCloseOutput;
        return this;
    }

    private static boolean isRedirect(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public void disconnect() {
        HttpClient.disconnect(this.connection);
    }

    private static void disconnect(HttpURLConnection connection) {
        if (connection != null) {
            connection.setConnectTimeout(100);
            connection.setReadTimeout(100);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logging.warn("InterruptedException in " + HttpClient.class + " during cancel");
                Thread.currentThread().interrupt();
            }
            connection.disconnect();
        }
    }

    public static Matcher getTomcatErrorMatcher(String data) {
        return data != null ? TOMCAT_ERR_MESSAGE.matcher(data) : null;
    }

    static {
        try {
            CookieHandler.setDefault(new CookieManager());
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to set default cookie handler", e);
        }
    }

    public static final class Response {
        private final HttpURLConnection connection;
        private final ProgressMonitor monitor;
        private final int responseCode;
        private final String responseMessage;
        private boolean uncompress;
        private boolean uncompressAccordingToContentDisposition;
        private String responseData;

        private Response(HttpURLConnection connection, ProgressMonitor monitor) throws IOException {
            CheckParameterUtil.ensureParameterNotNull(connection, "connection");
            CheckParameterUtil.ensureParameterNotNull(monitor, "monitor");
            this.connection = connection;
            this.monitor = monitor;
            this.responseCode = connection.getResponseCode();
            this.responseMessage = connection.getResponseMessage();
            if (this.responseCode >= 300) {
                String contentType = this.getContentType();
                if (contentType == null || contentType.contains("text") || contentType.contains("html") || contentType.contains("xml")) {
                    String content = this.fetchContent();
                    if (content.isEmpty()) {
                        Logging.debug("Server did not return any body");
                    } else {
                        Logging.debug("Response body: ");
                        Logging.debug(this.fetchContent());
                    }
                } else {
                    Logging.debug("Server returned content: {0} of length: {1}. Not printing.", contentType, this.getContentLength());
                }
            }
        }

        public Response uncompress(boolean uncompress) {
            this.uncompress = uncompress;
            return this;
        }

        public Response uncompressAccordingToContentDisposition(boolean uncompressAccordingToContentDisposition) {
            this.uncompressAccordingToContentDisposition = uncompressAccordingToContentDisposition;
            return this;
        }

        public URL getURL() {
            return this.connection.getURL();
        }

        public String getRequestMethod() {
            return this.connection.getRequestMethod();
        }

        public InputStream getContent() throws IOException {
            InputStream in;
            try {
                in = this.connection.getInputStream();
            }
            catch (IOException ioe) {
                Logging.debug(ioe);
                in = Optional.ofNullable(this.connection.getErrorStream()).orElseGet(() -> new ByteArrayInputStream(new byte[0]));
            }
            in = new ProgressInputStream(in, this.getContentLength(), this.monitor);
            in = "gzip".equalsIgnoreCase(this.getContentEncoding()) ? new GZIPInputStream(in) : in;
            Compression compression = Compression.NONE;
            if (this.uncompress) {
                String contentType = this.getContentType();
                Logging.debug("Uncompressing input stream according to Content-Type header: {0}", contentType);
                compression = Compression.forContentType(contentType);
            }
            if (this.uncompressAccordingToContentDisposition && Compression.NONE.equals((Object)compression)) {
                String contentDisposition = this.getHeaderField("Content-Disposition");
                Matcher matcher = Pattern.compile("filename=\"([^\"]+)\"").matcher(contentDisposition != null ? contentDisposition : "");
                if (matcher.find()) {
                    Logging.debug("Uncompressing input stream according to Content-Disposition header: {0}", contentDisposition);
                    compression = Compression.byExtension(matcher.group(1));
                }
            }
            in = compression.getUncompressedInputStream(in);
            return in;
        }

        public BufferedReader getContentReader() throws IOException {
            return new BufferedReader(UTFInputStreamReader.create(this.getContent()));
        }

        public synchronized String fetchContent() throws IOException {
            if (this.responseData == null) {
                try (Scanner scanner = new Scanner(this.getContentReader()).useDelimiter("\\A");){
                    this.responseData = scanner.hasNext() ? scanner.next() : "";
                }
            }
            return this.responseData;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public String getContentEncoding() {
            return this.connection.getContentEncoding();
        }

        public String getContentType() {
            return this.connection.getHeaderField("Content-Type");
        }

        public long getExpiration() {
            return this.connection.getExpiration();
        }

        public long getLastModified() {
            return this.connection.getLastModified();
        }

        public long getContentLength() {
            return this.connection.getContentLengthLong();
        }

        public String getHeaderField(String name) {
            return this.connection.getHeaderField(name);
        }

        public Map<String, List<String>> getHeaderFields() {
            TreeMap<String, List<String>> ret = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, List<String>> e : this.connection.getHeaderFields().entrySet()) {
                if (e.getKey() == null) continue;
                ret.put(e.getKey(), e.getValue());
            }
            return Collections.unmodifiableMap(ret);
        }

        public void disconnect() {
            HttpClient.disconnect(this.connection);
        }
    }
}

