/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_lo = "i-Lao";
        final String metaValue_si = "i-Sinhala";
        final String metaValue_type_nu_taml = "izinombolo zesi-Tamil";
        final Object[][] data = new Object[][] {
            { "sbp", "isi-Sangu" },
            { "nyn", "isi-Nyankole" },
            { "key.colStrength", "Amandla Okuhlelwa" },
            { "luo", "isi-Luo" },
            { "Zsym", "amasimbuli" },
            { "fil", "isi-Filipino" },
            { "luy", "isi-Luyia" },
            { "es_ES", "i-European Spanish" },
            { "teo", "isi-Teso" },
            { "ab", "isi-Abkhazian" },
            { "AC", "i-Ascension Island" },
            { "tet", "isi-Tetum" },
            { "key.colCaseFirst", "Ukuhlelwa Ngokwezinhlamvu Ezinkulu/Ezincane" },
            { "AD", "i-Andorra" },
            { "AE", "i-United Arab Emirates" },
            { "nl_BE", "isi-Flemish" },
            { "AF", "i-Afghanistan" },
            { "af", "i-Afrikaans" },
            { "AG", "i-Antigua and Barbuda" },
            { "type.ca.ethiopic", "ikhalenda lesi-Ethiopic" },
            { "AI", "i-Anguilla" },
            { "key.tz", "Izoni yesikhathi:" },
            { "ak", "isi-Akan" },
            { "AL", "i-Albania" },
            { "AM", "i-Armenia" },
            { "am", "isi-Amharic" },
            { "Arab", "i-Arab" },
            { "AO", "i-Angola" },
            { "AQ", "i-Antarctica" },
            { "Jpan", "i-Japanese" },
            { "AR", "i-Argentina" },
            { "ar", "isi-Arabic" },
            { "AS", "i-American Samoa" },
            { "as", "isi-Assamese" },
            { "AT", "i-Austria" },
            { "AU", "i-Australia" },
            { "AW", "i-Aruba" },
            { "sdh", "i-Southern Kurdish" },
            { "en_US", "i-American English" },
            { "AX", "i-\u00c5land Islands" },
            { "key.colNormalization", "Ukuhlelwa Okulinganisiwe" },
            { "ay", "isi-Aymara" },
            { "AZ", "i-Azerbaijan" },
            { "az", "isi-Azerbaijani" },
            { "BA", "i-Bosnia ne-Herzegovina" },
            { "ba", "isi-Bashkir" },
            { "BB", "i-Barbados" },
            { "BD", "i-Bangladesh" },
            { "type.co.unihan", "Ukuhlunga kwe-Radical-Stroke" },
            { "BE", "i-Belgium" },
            { "be", "isi-Belarusian" },
            { "BF", "i-Burkina Faso" },
            { "BG", "i-Bulgaria" },
            { "bg", "isi-Bulgari" },
            { "BH", "i-Bahrain" },
            { "BI", "i-Burundi" },
            { "BJ", "i-Benin" },
            { "BL", "i-Saint Barth\u00e9lemy" },
            { "BM", "i-Bermuda" },
            { "bm", "isi-Bambara" },
            { "BN", "i-Brunei" },
            { "bn", "isi-Bengali" },
            { "BO", "i-Bolivia" },
            { "bo", "isi-Tibetan" },
            { "BQ", "i-Caribbean Netherlands" },
            { "BR", "i-Brazil" },
            { "br", "isi-Breton" },
            { "BS", "i-Bahamas" },
            { "bs", "isi-Bosnian" },
            { "xog", "isi-Soga" },
            { "BT", "i-Bhutan" },
            { "BV", "i-Bouvet Island" },
            { "BW", "iBotswana" },
            { "Mymr", "i-Myanmar" },
            { "type.nu.laoo", "amadijithi esi-Lao" },
            { "BY", "i-Belarus" },
            { "seh", "isi-Sena" },
            { "BZ", "i-Belize" },
            { "type.ca.persian", "ikhalenda lesi-Persian" },
            { "type.nu.hebr", "izinombolo zesi-Hebrew" },
            { "CA", "i-Canada" },
            { "ca", "isi-Catalan" },
            { "CC", "i-Cocos (Keeling) Islands" },
            { "mzn", "isi-Mazanderani" },
            { "ses", "isi-Koyraboro Senni" },
            { "CD", "i-Congo - Kinshasa" },
            { "ce", "isi-Chechen" },
            { "CF", "i-Central African Republic" },
            { "CG", "i-Congo - Brazzaville" },
            { "CH", "i-Switzerland" },
            { "CI", "i-C\u00f4te d\u2019Ivoire" },
            { "CK", "i-Cook Islands" },
            { "CL", "i-Chile" },
            { "CM", "i-Cameroon" },
            { "CN", "i-China" },
            { "CO", "i-Colombia" },
            { "co", "isi-Corsican" },
            { "CP", "i-Clipperton Island" },
            { "Orya", "i-Oriya" },
            { "CR", "i-Costa Rica" },
            { "cs", "isi-Czech" },
            { "CU", "i-Cuba" },
            { "CV", "i-Cape Verde" },
            { "cv", "isi-Chuvash" },
            { "CW", "i-Cura\u00e7ao" },
            { "CX", "i-Christmas Island" },
            { "CY", "i-Cyprus" },
            { "cy", "isi-Welsh" },
            { "CZ", "i-Czech Republic" },
            { "type.nu.ethi", "izinombolo zesi-Ethiopic" },
            { "da", "isi-Danish" },
            { "pt_PT", "isi-European Portuguese" },
            { "DE", "i-Germany" },
            { "de", "isi-German" },
            { "cgg", "isi-Chiga" },
            { "DG", "i-Diego Garcia" },
            { "type.nu.deva", "izinombolo zesi-Devanagari" },
            { "DJ", "i-Djibouti" },
            { "type.colNumeric.no", "Hlela Izinhlamvu Zenombolo Ngazinye" },
            { "DK", "i-Denmark" },
            { "ach", "Isi-Acoli" },
            { "Brai", "i-Braille" },
            { "DM", "i-Dominica" },
            { "type.nu.armnlow", "izinombolo ezincane zesi-Armenian" },
            { "DO", "i-Dominican Republic" },
            { "bem", "isi-Bemba" },
            { "type.nu.mong", "i-Mongolian Digits" },
            { "key.variableTop", "Hlela Njengezimpawu" },
            { "dv", "isi-Divehi" },
            { "es_419", "isi-Latin American Spanish" },
            { "DZ", "i-Algeria" },
            { "dz", "isi-Dzongkha" },
            { "bez", "isi-Bena" },
            { "type.ca.chinese", "ikhalenda lesi-Chinese" },
            { "EA", "i-Cueta ne-Melilla" },
            { "EC", "i-Ecuador" },
            { "dje", "isi-Zarma" },
            { "type.nu.grek", "izinombolo zesi-Greek" },
            { "EE", "i-Estonia" },
            { "ee", "isi-Ewe" },
            { "type.lb.normal", "i-Line Break Style ekahle" },
            { "EG", "i-Egypt" },
            { "EH", "i-Western Sahara" },
            { "ro_MD", "isi-Moldavian" },
            { "type.colNormalization.yes", "Ukuhlelwa Khekhodi Enye Kulinganisiwe" },
            { "el", "isi-Greek" },
            { "en", "i-English" },
            { "eo", "isi-Esperanto" },
            { "chr", "isi-Cherokee" },
            { "ER", "i-Eritrea" },
            { "type.co.big5han", "Ukuhlunga kwe-Traditional Chinese - Big5" },
            { "ES", "i-Spain" },
            { "es", "isi-Spanish" },
            { "ET", "i-Ethiopia" },
            { "et", "isi-Estonia" },
            { "EU", "i-European Union" },
            { "eu", "isi-Basque" },
            { "Hang", "i-Hangul" },
            { "type.ca.gregorian", "ikhalenda lesi-Gregorian" },
            { "shi", "isi-Tachelhit" },
            { "type.nu.gujr", "amadijithi esi-Gujarati" },
            { "hsb", "isi-Upper Sorbian" },
            { "Hani", "i-Han" },
            { "fa", "isi-Persian" },
            { "Hans", "i-Simplified" },
            { "type.nu.latn", "amadijithi ase-Western" },
            { "Hant", "okosiko" },
            { "FI", "i-Finland" },
            { "fi", "isi-Finnish" },
            { "FJ", "i-Fiji" },
            { "fj", "isi-Fijian" },
            { "FK", "i-Falkland Islands" },
            { "FM", "i-Micronesia" },
            { "key.va", "Okokwehlukanisa Kwasendaweni" },
            { "bgn", "isi-Western Balochi" },
            { "FO", "i-Faroe Islands" },
            { "fo", "isi-Faroese" },
            { "Taml", "i-Tamil" },
            { "FR", "i-France" },
            { "fr", "isi-French" },
            { "fy", "isi-Western Frisian" },
            { "type.ca.indian", "i-Indian National Calender" },
            { "GA", "i-Gabon" },
            { "ga", "isi-Irish" },
            { "GB", "i-United Kingdom" },
            { "GD", "i-Grenada" },
            { "gd", "i-Scottish Gaelic" },
            { "GE", "i-Georgia" },
            { "GF", "i-French Guiana" },
            { "GG", "i-Guernsey" },
            { "GH", "i-Ghana" },
            { "GI", "i-Gibraltar" },
            { "key.colCaseLevel", "Ukuhlelwa Okuncike Ezinkinobhweni" },
            { "GL", "i-Greenland" },
            { "gl", "isi-Galicia" },
            { "GM", "i-Gambia" },
            { "GN", "i-Guinea" },
            { "gn", "isi-Guarani" },
            { "GP", "i-Guadeloupe" },
            { "GQ", "i-Equatorial Guinea" },
            { "und", "ulimi olungaziwa" },
            { "GR", "i-Greece" },
            { "type.ca.ethiopic-amete-alem", "i-Ethiopic Amete Alem Calender" },
            { "GS", "i-South Georgia ne-South Sandwich Islands" },
            { "GT", "i-Guatemala" },
            { "GU", "i-Guam" },
            { "gu", "isi-Gujarati" },
            { "gv", "isi-Manx" },
            { "GW", "i-Guinea-Bissau" },
            { "tlh", "Isi-Klingon" },
            { "GY", "i-Guyana" },
            { "ha", "isi-Hausa" },
            { "ckb", "isi-Central Kurdish" },
            { "zxx", "akukho okuqukethwe kolimi" },
            { "he", "isi-Hebrew" },
            { "hi", "isi-Hindi" },
            { "de_AT", "isi-Austrian German" },
            { "HK", "i-Hong Kong SAR China" },
            { "HM", "i-Heard Island ne-McDonald Islands" },
            { "HN", "i-Honduras" },
            { "HR", "i-Croatia" },
            { "hr", "isi-Croatian" },
            { "agq", "isi-Aghem" },
            { "gsw", "isi-Swiss German" },
            { "HT", "i-Haiti" },
            { "ht", "isi-Haitian" },
            { "HU", "i-Hungary" },
            { "hu", "isi-Hungarian" },
            { "hy", "isi-Armenia" },
            { "ia", "Izilimi ezihlangene" },
            { "IC", "i-Canary Islands" },
            { "ID", "i-Indonesia" },
            { "id", "isi-Indonesian" },
            { "type.nu.tibt", "amadijithi esi-Tibetan" },
            { "IE", "i-Ireland" },
            { "ig", "isi-Igbo" },
            { "naq", "isi-Nama" },
            { "ii", "isi-Sichuan Yi" },
            { "IL", "kwa-Israel" },
            { "IM", "i-Isle of Man" },
            { "IN", "i-India" },
            { "IO", "i-British Indian Ocean Territory" },
            { "IQ", "i-Iraq" },
            { "IR", "i-Iran" },
            { "IS", "i-Iceland" },
            { "is", "isi-Icelandic" },
            { "IT", "i-Italy" },
            { "it", "isi-Italian" },
            { "iu", "isi-Inuktitut" },
            { "type.nu.thai", "amadijithi esi-Thai" },
            { "type.nu.beng", "izinombolo zesi-Bengali" },
            { "ja", "isi-Japanese" },
            { "Mlym", "i-Malayam" },
            { "JE", "i-Jersey" },
            { "type.ca.islamic", "ikhalenda lesi-Islamic" },
            { "JM", "i-Jamaica" },
            { "Beng", "i-Bengali" },
            { "JO", "i-Jordan" },
            { "JP", "i-Japan" },
            { "sma", "isi-Southern Sami" },
            { "jv", "isi-Javanese" },
            { "guz", "isi-Gusli" },
            { "type.nu.knda", "amadijithi esi-Kannada" },
            { "smj", "isi-Lule Sami" },
            { "de_CH", "i-Swiss High German" },
            { "smn", "isi-Inari Sami" },
            { "type.co.phonetic", "Hlela Ngokwefonetiki" },
            { "ka", "isi-Georgian" },
            { "type.ca.buddhist", "ikhalenda lesi-Buddhist" },
            { "sms", "isi-Skolt Sami" },
            { "KE", "i-Kenya" },
            { "419", "i-Latin America" },
            { "KG", "i-Kyrgyzstan" },
            { "kg", "Isi-Kongo" },
            { "KH", "i-Cambodia" },
            { "KI", "i-Kiribati" },
            { "ki", "isi-Kikuyu" },
            { "mas", "isi-Masai" },
            { "kk", "isi-Kazakh" },
            { "kl", "isi-Kalaallisut" },
            { "KM", "i-Comoros" },
            { "km", "isi-Khmer" },
            { "KN", "i-Saint Kitts ne-Nevis" },
            { "kn", "isi-Kannada" },
            { "Knda", "i-Kannada" },
            { "fr_CA", "i-Canadian French" },
            { "type.colStrength.identical", "Hlela konke" },
            { "ko", "isi-Korean" },
            { "KP", "i-North Korea" },
            { "KR", "i-South Korea" },
            { "ks", "isi-Kashmiri" },
            { "ku", "isi-Kurdish" },
            { "fr_CH", "i-Swiss French" },
            { "KW", "i-Kuwait" },
            { "kw", "isi-Cornish" },
            { "tpi", "isi-Tok Pisin" },
            { "KY", "i-Cayman Islands" },
            { "ky", "isi-Kyrgyz" },
            { "KZ", "i-Kazakhstan" },
            { "Cyrl", "i-Cyrillic" },
            { "type.colStrength.primary", "Hlela Izinhlamvu Zaphansi Kuphela" },
            { "LA", "i-Laos" },
            { "la", "isi-Latin" },
            { "LB", "i-Lebanon" },
            { "lb", "isi-Luxembourgish" },
            { "LC", "i-Saint Lucia" },
            { "type.nu.mlym", "amadijithi esi-Malayalam" },
            { "lg", "isi-Ganda" },
            { "nds", "nds" },
            { "LI", "i-Liechtenstein" },
            { "LK", "i-Sri Lanka" },
            { "Tibt", "i-Tibetan" },
            { "ln", "isi-Lingala" },
            { "type.colCaseLevel.no", "Hlela Okungancikile Ezinkinobhweni" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "isistimu yokulinganisa ebusayo" },
            { "type.colStrength.tertiary", "Hlela Ukuphimisela/Ukuma kwezinhlamvu/Ububanzi" },
            { "LR", "i-Liberia" },
            { "LS", "iLesotho" },
            { "LT", "i-Lithuania" },
            { "lt", "isi-Lithuanian" },
            { "LU", "i-Luxembourg" },
            { "lu", "isi-Luba-Katanga" },
            { "LV", "i-Latvia" },
            { "lv", "isi-Latvian" },
            { "Kana", "i-Katakana" },
            { "LY", "i-Libya" },
            { "vun", "isiVunjo" },
            { "lag", "isi-Langi" },
            { "Thaa", "i-Thaana" },
            { "MA", "i-Morocco" },
            { "MC", "i-Monaco" },
            { "MD", "i-Moldova" },
            { "ME", "i-Montenegro" },
            { "MF", "i-Saint Martin" },
            { "MG", "i-Madagascar" },
            { "mg", "isi-Malagasy" },
            { "MH", "i-Marshall Islands" },
            { "Thai", "i-Thai" },
            { "type.co.ducet", "Ukuhlunga okuzenzakalelayo kwe-Unicode" },
            { "mi", "isi-Maori" },
            { "type.nu.vaii", "Izinhlazu Zezinombolo ze-Vai" },
            { "MK", "i-Macedonia" },
            { "mk", "isi-Macedonian" },
            { "ML", "iMali" },
            { "ml", "isi-Malayalam" },
            { "MM", "i-Myanmar (Burma)" },
            { "MN", "i-Mongolia" },
            { "mn", "isi-Mongolian" },
            { "MO", "i-Macau SAR China" },
            { "MP", "i-Northern Mariana Islands" },
            { "MQ", "i-Martinique" },
            { "MR", "i-Mauritania" },
            { "mr", "isi-Marathi" },
            { "MS", "i-Montserrat" },
            { "ms", "isi-Malay" },
            { "type.colAlternate.non-ignorable", "Hlela Izimpawu" },
            { "MT", "i-Malta" },
            { "mt", "isi-Maltese" },
            { "MU", "i-Mauritius" },
            { "MV", "i-Maldives" },
            { "MW", "iMalawi" },
            { "MX", "i-Mexico" },
            { "type.ca.japanese", "ikhalenda lesi-Japanese" },
            { "MY", "i-Malaysia" },
            { "my", "isi-Burmese" },
            { "MZ", "i-Mozambique" },
            { "Armn", "i-Armenian" },
            { "dsb", "isi-Lower Sorbian" },
            { "NA", "i-Namibia" },
            { "type.co.search", "Usesho olujwayelekile" },
            { "nb", "isi-Norwegian Bokm\u00e5l" },
            { "type.ca.hebrew", "ikhalenda lesi-Hebrew" },
            { "type.co.dictionary", "Ukuhlunga kwesichazimazwi" },
            { "NC", "i-New Caledonia" },
            { "nd", "isi-North Ndebele" },
            { "NE", "i-Niger" },
            { "ne", "isi-Nepali" },
            { "NF", "i-Norfolk Island" },
            { "NG", "i-Nigeria" },
            { "NI", "i-Nicaragua" },
            { "NL", "i-Netherlands" },
            { "nl", "isi-Dutch" },
            { "nn", "i-Norwegian Nynorsk" },
            { "NO", "i-Norway" },
            { "NP", "i-Nepal" },
            { "NR", "i-Nauru" },
            { "NU", "i-Niue" },
            { "rof", "isi-Rombo" },
            { "ny", "isi-Nyanja" },
            { "NZ", "i-New Zealand" },
            { "kab", "isi-Kabyle" },
            { "type.colCaseFirst.lower", "Hlela Okwezinhlamvu Eziphansi Kuqala" },
            { "oc", "Isi-Osithani" },
            { "kam", "isi-Kamba" },
            { "type.colAlternate.shifted", "Hlela Ukuziba Izimpawu" },
            { "mer", "isi-Meru" },
            { "type.nu.armn", "izinombolo zesi-Armenian" },
            { "OM", "i-Oman" },
            { "om", "i-Oromo" },
            { "or", "isi-Oriya" },
            { "os", "isi-Ossetic" },
            { "mfe", "isi-Morisyen" },
            { "PA", "i-Panama" },
            { "pa", "isi-Punjabi" },
            { "dua", "isi-Duala" },
            { "type.ca.islamic-civil", "i-Islamic-Civil Calendar" },
            { "en_GB", "i-British English" },
            { "PE", "i-Peru" },
            { "PF", "i-French Polynesia" },
            { "PG", "i-Papua New Guinea" },
            { "PH", "i-Philippines" },
            { "PK", "i-Pakistan" },
            { "PL", "i-Poland" },
            { "pl", "isi-Polish" },
            { "PM", "i-Saint Pierre kanye ne-Miquelon" },
            { "PN", "i-Pitcairn Islands" },
            { "type.ca.dangi", "ikhalenda lesi-Dangi" },
            { "type.colBackwards.yes", "Ukuhlelwa Kokuphimisela Kuhlehlisiwe" },
            { "PR", "i-Puerto Rico" },
            { "PS", "i-Palestinian Territories" },
            { "ps", "isi-Pashto" },
            { "PT", "i-Portugal" },
            { "pt", "isi-Portuguese" },
            { "key.co", "Uhlelo lokuhlunga" },
            { "PW", "i-Palau" },
            { "type.nu.greklow", "izinombolo ezincane zesi-Greek" },
            { "PY", "i-Paraguay" },
            { "pt_BR", "isi-Brazillian Portuguese" },
            { "tum", "Isi-Tumbuka" },
            { "mgh", "isi-Makhuwa-Meetto" },
            { "Hebr", "i-Hebrew" },
            { "QA", "i-Qatar" },
            { "key.ca", "Ikhalenda" },
            { "Laoo", metaValue_lo },
            { "mgo", "isi-Meta\u2019" },
            { "type.hc.h23", "isistimu yamahora angu-24 (0-23)" },
            { "type.hc.h24", "isistimu yamahora angu-24 (1-24)" },
            { "type.nu.mymr", "amadijithi esi-Maynmar" },
            { "QO", "i-Outlying Oceania" },
            { "qu", "isi-Quechua" },
            { "brx", "isi-Bodo" },
            { "kde", "isi-Makonde" },
            { "001", "umhlaba" },
            { "Ethi", "i-Ethiopic" },
            { "002", "i-Africa" },
            { "003", "i-North America" },
            { "RE", "i-R\u00e9union" },
            { "type.colNormalization.no", "Hlela Ngaphandle Kokulinganisa" },
            { "type.hc.h12", "isistimu yamahora angu-12 (1-12)" },
            { "005", "i-South America" },
            { "type.hc.h11", "isistimu yamahora angu-12 (0-11)" },
            { "009", "i-Oceania" },
            { "rm", "isi-Romansh" },
            { "rn", "isi-Rundi" },
            { "key.cu", "Ikharensi" },
            { "RO", "i-Romania" },
            { "ro", "isi-Romanian" },
            { "RS", "i-Serbia" },
            { "type.nu.orya", "amadijithi esi-Oriya" },
            { "type.nu.hanidec", "izinombolo zezinombolo zesi-Chinese" },
            { "RU", "i-Russia" },
            { "ru", "isi-Russian" },
            { "RW", "i-Rwanda" },
            { "rw", "isi-Kinyarwanda" },
            { "kea", "isi-Kabuverdianu" },
            { "en_AU", "isi-Austrillian English" },
            { "key.colAlternate", "Ziba Ukuhlelwa Kwezimpawu" },
            { "SA", "i-Saudi Arabia" },
            { "sa", "isi-Sanskrit" },
            { "SB", "i-Solomon Islands" },
            { "twq", "isi-Tasawaq" },
            { "011", "i-Western Africa" },
            { "SC", "i-Seychelles" },
            { "SD", "i-Sudan" },
            { "sd", "isi-Sindhi" },
            { "013", "i-Central America" },
            { "SE", "i-Sweden" },
            { "se", "isi-Northern Sami" },
            { "014", "i-Eastern Africa" },
            { "015", "i-Northern Africa" },
            { "SG", "i-Singapore" },
            { "sg", "isi-Sango" },
            { "SH", "i-Saint Helena" },
            { "type.lb.strict", "i-Line Break Style enomthetho oqinile" },
            { "si", metaValue_si },
            { "017", "i-Middle Africa" },
            { "SI", "i-Slovenia" },
            { "018", "i-Southern Africa" },
            { "SJ", "i-Svalbard ne-Jan Mayen" },
            { "019", "i-Americas" },
            { "SK", "i-Slovakia" },
            { "sk", "isi-Slovak" },
            { "SL", "i-Sierra Leone" },
            { "sl", "isi-Slovenian" },
            { "SM", "i-San Marino" },
            { "sm", "isi-Samoan" },
            { "SN", "i-Senegal" },
            { "sn", "isiShona" },
            { "SO", "i-Somalia" },
            { "so", "isi-Somali" },
            { "arn", "isi-Mapuche" },
            { "type.nu.arab", "amadijithi esi-Arabic-Indic" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "sq", "isi-Albania" },
            { "SR", "i-Suriname" },
            { "sr", "isi-Serbian" },
            { "SS", "i-South Sudan" },
            { "ss", "isiSwati" },
            { "ST", "i-S\u00e3o Tom\u00e9 kanye ne-Pr\u00edncipe" },
            { "st", "isiSuthu" },
            { "su", "isi-Sundanese" },
            { "SV", "i-El Salvador" },
            { "sv", "isi-Swedish" },
            { "sw", "isiSwahili" },
            { "SX", "i-Sint Maarten" },
            { "SY", "i-Syria" },
            { "type.nu.hantfin", "izinombolo zosiko zezezimali zesi-Chinese" },
            { "SZ", "i-Swaziland" },
            { "TA", "i-Tristan da Cunha" },
            { "ta", "isi-Tamil" },
            { "asa", "isi-Asu" },
            { "type.ms.ussystem", "isistimu yokulinganisa yase-US" },
            { "021", "i-Northern America" },
            { "142", "i-Asia" },
            { "TC", "i-Turks and Caicos Islands" },
            { "143", "i-Central Asia" },
            { "TD", "i-Chad" },
            { "te", "isi-Telugu" },
            { "145", "i-Western Asia" },
            { "TF", "i-French Southern Territories" },
            { "TG", "i-Togo" },
            { "tg", "isi-Tajik" },
            { "TH", "i-Thailand" },
            { "th", "isi-Thai" },
            { "ti", "isi-Tigrinya" },
            { "type.colNumeric.yes", "Hlela Izinhlamvu Ngokwezinombolo" },
            { "TJ", "i-Tajikistan" },
            { "en_CA", "i-Canadian English" },
            { "029", "i-Caribbean" },
            { "TK", "i-Tokelau" },
            { "tk", "isi-Turkmen" },
            { "TL", "i-Timor-Leste" },
            { "type.co.searchjl", "Sesha nge-Hangul Ongwaqa Basekuqaleni" },
            { "TM", "i-Turkmenistan" },
            { "TN", "i-Tunisia" },
            { "tn", "isi-Tswana" },
            { "TO", "i-Tonga" },
            { "to", "isi-Tongan" },
            { "dyo", "isi-Jola-Fonyl" },
            { "type.nu.jpan", "izinombolo zesi-Japanese" },
            { "TR", "i-Turkey" },
            { "tr", "isi-Turkish" },
            { "ts", "isi-Tsonga" },
            { "TT", "i-Trinidad ne-Tobago" },
            { "tt", "isi-Tatar" },
            { "TV", "i-Tuvalu" },
            { "TW", "i-Taiwan" },
            { "ty", "isi-Tahitian" },
            { "TZ", "i-Tanzania" },
            { "nmg", "isi-Kwasio" },
            { "Zzzz", "iskripthi esingaziwa" },
            { "150", "i-Europe" },
            { "UA", "i-Ukraine" },
            { "key.colHiraganaQuaternary", "Ukuhlela ngokwe-Kana" },
            { "030", "i-Eastern Asia" },
            { "151", "i-Eastern Europe" },
            { "154", "i-Northern Europe" },
            { "sw_CD", "isi-Congo Swahili" },
            { "034", "i-Southern Asia" },
            { "155", "i-Western Europe" },
            { "035", "i-South-Eastern Asia" },
            { "UG", "i-Uganda" },
            { "ug", "isi-Uighur" },
            { "type.co.pinyin", "Ukuhlunga nge-Pinyin" },
            { "Kore", "i-Korean" },
            { "Zyyy", "ejwayelekile" },
            { "type.colHiraganaQuaternary.yes", "Hlela i-Kana Ngendlela Ehlukile" },
            { "039", "i-Southern Europe" },
            { "uk", "isi-Ukrainian" },
            { "Sinh", metaValue_si },
            { "type.colCaseFirst.no", "Hlela Ngokwenhlamvu Ezejwayelekile" },
            { "UM", "i-U.S. Minor Outlying Islands" },
            { "type.colStrength.quaternary", "Hlola Ukuphimisela/Ukuma kwezinhlamvu/Ububanzi/i-Kana" },
            { "type.ca.coptic", "i-Coptic Calender" },
            { "ur", "isi-Urdu" },
            { "US", "i-United States" },
            { "haw", "isi-Hawaiian" },
            { "type.co.gb2312han", "Ukuhlunga kwe-Simplified Chinese - GB2312" },
            { "UY", "i-Uruguay" },
            { "UZ", "i-Uzbekistan" },
            { "uz", "isi-Uzbek" },
            { "tzm", "isi-Central Atlas Tamazight" },
            { "type.co.stroke", "Ukuhlunga kwe-Stroke" },
            { "VA", "i-Vatican City" },
            { "nds_NL", "isi-Low Saxon" },
            { "VC", "i-Saint Vincent ne-Grenadines" },
            { "VE", "i-Venezuela" },
            { "ve", "isi-Venda" },
            { "type.ca.roc", "ikhalenda lesi-Minguo" },
            { "VG", "i-British Virgin Islands" },
            { "VI", "i-U.S. Virgin Islands" },
            { "vi", "isi-Vietnamese" },
            { "khq", "isi-Koyra Chiini" },
            { "key.hc", "Umjikelezo wehora (12 vs 24" },
            { "VN", "i-Vietnam" },
            { "type.colBackwards.no", "Hlela Izindlela Zokuphimisela Ngokujwayelekile" },
            { "key.x", "i-Private-Use" },
            { "quc", "isi-K\u02bciche\u02bc" },
            { "VU", "i-Vanuatu" },
            { "gaa", "Isi-Ga" },
            { "rwk", "isi-Rwa" },
            { "gag", "isi-Gagauz" },
            { "053", "i-Australasia" },
            { "054", "i-Melanesia" },
            { "WF", "i-Wallis ne-Futuna" },
            { "Grek", "i-Greek" },
            { "type.co.traditional", "Ukuhlunga ngokisiko" },
            { "057", "i-Micronesian Region" },
            { "jgo", "isi-Ngomba" },
            { "lkt", "isi-Lakota" },
            { "type.nu.finance", "Izinombolo Zezomnotho" },
            { "wo", "isi-Wolof" },
            { "zgh", "isi-Standard Moroccan Tamazight" },
            { "ar_001", "isi-Arabic esivamile sesimanje" },
            { "WS", "i-Samoa" },
            { "key.colNumeric", "Ukuhlelwa Ngezinombolo" },
            { "Mong", "i-Mongolian" },
            { "061", "i-Polynesia" },
            { "Latn", "i-Latin" },
            { "type.nu.hans", "izinombolo ezicacile zesi-Chinese" },
            { "type.nu.hant", "izinombolo zosiko zesi-Chinese" },
            { "xh", "isiXhosa" },
            { "type.nu.romanlow", metaValue_type_nu_taml },
            { "XK", "i-Kosovo" },
            { "Gujr", "i-Gujarati" },
            { "Zxxx", "okungabhaliwe" },
            { "wbp", "isi-Warlpiri" },
            { "moh", "isi-Mohawk" },
            { "YE", "i-Yemen" },
            { "nqo", "isi-N\u2019Ko" },
            { "type.co.standard", "I-oda yokuhlunga ejwayelekile" },
            { "yi", "Isi-Yidish" },
            { "yo", "isi-Yoruba" },
            { "type.nu.traditional", "Izinombolo Ezijwayelekile" },
            { "es_MX", "i-Mexican Spanish" },
            { "YT", "i-Mayotte" },
            { "vai", "isi-Vai" },
            { "ZA", "i-South Africa" },
            { "type.lb.loose", "i-Line Break Style exegayo" },
            { "kln", "isi-Kalenjin" },
            { "Deva", "i-Devanagari" },
            { "zh", "isi-Chinese" },
            { "type.nu.geor", "izinombolo zesi-Georgian" },
            { "Hira", "i-Hiragana" },
            { "ZM", "i-Zambia" },
            { "Bopo", "i-Bopomofo" },
            { "key.lb", "I-Line Break Style" },
            { "zu", "isiZulu" },
            { "ZW", "iZimbabwe" },
            { "type.co.phonebook", "Ukuhlunga kwebhuku lefoni" },
            { "ZZ", "iSifunda esingaziwa" },
            { "Geor", "i-Georgian" },
            { "type.colCaseLevel.yes", "Hlela Okuncike Ekumeni Kwezinkinobho" },
            { "type.ms.metric", "isistimu ye-Metric" },
            { "type.ca.iso8601", "ikhalenda le-ISO-8601" },
            { "nso", "isi-Northern Sotho" },
            { "type.nu.telu", "amadijithi esi-Telegu" },
            { "type.nu.jpanfin", "izinombolo zezezimali zesi-Japanese" },
            { "loz", "Isi-Lozi" },
            { "type.co.reformed", "Ukuhlunga okwenziwe kabusha" },
            { "key.colBackwards", "Ukuhlelwa Kwendlela Yokubiza Okuhlehlisiwe" },
            { "type.colHiraganaQuaternary.no", "Hlela i-Kana Eceleni" },
            { "ebu", "isi-Embu" },
            { "jmc", "isi-Machame" },
            { "koi", "isi-Komi-Permyak" },
            { "type.nu.hansfin", "izinombolo ezicacile zezezimali zesi-Chinese" },
            { "type.colStrength.secondary", "Hlela Ukuphimisela" },
            { "kok", "isi-Konkani" },
            { "type.nu.arabext", "amadijithi esi-Arabic-Indic eluliwe" },
            { "nus", "isi-Nuer" },
            { "type.nu.fullwide", "ububanzi obugcwele bamadijithi" },
            { "dav", "isi-Taita" },
            { "lrc", "isi-Northern Luri" },
            { "zh_Hant", "isi-Chinese (Okosiko)" },
            { "type.nu.khmr", "amadijithi esi-Khmer" },
            { "mua", "isi-Mundang" },
            { "type.nu.guru", "amadijithi esi-Gurmukhi" },
            { "Khmr", "i-Khmer" },
            { "key.ms", "Isistimu yokulinganisa" },
            { "type.nu.roman", "izinombolo zesi-Roman" },
            { "type.nu.tamldec", "amadijithi esi-Tamil" },
            { "saq", "isi-Samburu" },
            { "efi", "isi-Efik" },
            { "key.nu", "Izinombolo" },
            { "type.nu.native", "Izinkinobho Zasendaweni" },
            { "Guru", "i-Gurmukhi" },
            { "lua", "Isi-Luba-Lulua" },
            { "ksb", "isiShambala" },
            { "type.colCaseFirst.upper", "Hlela Izinhlamvu Ezinkulu Kuqala" },
            { "Telu", "i-Telegu" },
            { "ksf", "isi-Bafia" },
        };
        return data;
    }
}
