/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model.config;

import groovy.lang.Closure;
import groovy.lang.MetaProperty;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.IllegalMappingException;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.ReflectionUtils;
import org.springframework.util.StringUtils;

public class GormMappingConfigurationStrategy
implements MappingConfigurationStrategy {
    private static final String IDENTITY_PROPERTY = "id";
    private static final String VERSION_PROPERTY = "version";
    public static final String MAPPED_BY_NONE = "none";
    protected MappingFactory propertyFactory;
    private static final Set EXCLUDED_PROPERTIES = ClassPropertyFetcher.EXCLUDED_PROPERTIES;
    private boolean canExpandMappingContext = true;

    public GormMappingConfigurationStrategy(MappingFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
    }

    @Override
    public void setCanExpandMappingContext(boolean canExpandMappingContext) {
        this.canExpandMappingContext = canExpandMappingContext;
    }

    @Override
    public boolean isPersistentEntity(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (Closure.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isAnnotationPresent(Entity.class)) {
            return true;
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            String annName = annotation.annotationType().getName();
            if (annName.equals("grails.persistence.Entity")) {
                return true;
            }
            if (!annName.equals("grails.gorm.annotation.Entity")) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PersistentProperty> getPersistentProperties(Class javaClass, MappingContext context) {
        return this.getPersistentProperties(javaClass, context, null);
    }

    @Override
    public List<PersistentProperty> getPersistentProperties(Class javaClass, MappingContext context, ClassMapping classMapping) {
        PersistentEntity entity = this.getPersistentEntity(javaClass, context, classMapping);
        if (entity != null) {
            return this.getPersistentProperties(entity, context, classMapping);
        }
        return Collections.emptyList();
    }

    @Override
    public List<PersistentProperty> getPersistentProperties(PersistentEntity entity, MappingContext context, ClassMapping classMapping, boolean includeIdentifiers) {
        ArrayList<PersistentProperty> persistentProperties = new ArrayList<PersistentProperty>();
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(entity.getJavaClass());
        List embedded = this.getCollectionStaticProperty(cpf, "embedded");
        List transients = this.getCollectionStaticProperty(cpf, "transients");
        Map hasManyMap = this.getAssociationMap(cpf);
        Map mappedByMap = this.getMapStaticProperty(cpf, "mappedBy");
        Map hasOneMap = this.getAssociationMap(cpf, "hasOne");
        for (MetaProperty metaProperty : cpf.getMetaProperties()) {
            Association association;
            Field field;
            String propertyName;
            Method readMethod;
            Class propertyType;
            PropertyDescriptor propertyDescriptor = this.propertyFactory.createPropertyDescriptor(entity.getJavaClass(), metaProperty);
            if (propertyDescriptor == null || (propertyType = metaProperty.getType()) == null || propertyType == Object.class || (readMethod = propertyDescriptor.getReadMethod()) == null || propertyDescriptor.getWriteMethod() == null || (propertyName = metaProperty.getName()).equals(VERSION_PROPERTY) && !entity.isVersioned() || (field = cpf.getDeclaredField(propertyName)) != null && Modifier.isTransient(field.getModifiers()) || Modifier.isTransient(readMethod.getModifiers()) || this.isExcludedProperty(propertyName, classMapping, transients, includeIdentifiers)) continue;
            Class currentPropType = propertyType;
            if (embedded.contains(propertyName)) {
                if (this.isCollectionType(currentPropType)) {
                    association = this.establishRelationshipForCollection(propertyDescriptor, entity, context, hasManyMap, mappedByMap, true);
                    if (association == null) continue;
                    persistentProperties.add(association);
                    continue;
                }
                association = this.establishDomainClassRelationship(entity, propertyDescriptor, context, hasOneMap, true);
                if (association == null) continue;
                persistentProperties.add(association);
                continue;
            }
            if (this.isCollectionType(currentPropType)) {
                association = this.establishRelationshipForCollection(propertyDescriptor, entity, context, hasManyMap, mappedByMap, false);
                if (association == null) continue;
                this.configureOwningSide(association);
                persistentProperties.add(association);
                continue;
            }
            if (this.isPersistentEntity(currentPropType)) {
                association = this.establishDomainClassRelationship(entity, propertyDescriptor, context, hasOneMap, false);
                if (association == null) continue;
                this.configureOwningSide(association);
                persistentProperties.add(association);
                continue;
            }
            if (this.propertyFactory.isTenantId(entity, context, propertyDescriptor)) {
                persistentProperties.add(this.propertyFactory.createTenantId(entity, context, propertyDescriptor));
                continue;
            }
            if (this.propertyFactory.isSimpleType(propertyType)) {
                persistentProperties.add(this.propertyFactory.createSimple(entity, context, propertyDescriptor));
                continue;
            }
            if (!this.supportsCustomType(propertyType)) continue;
            persistentProperties.add(this.propertyFactory.createCustom(entity, context, propertyDescriptor));
        }
        return persistentProperties;
    }

    protected boolean supportsCustomType(Class<?> propertyType) {
        return this.propertyFactory.isCustomType(propertyType);
    }

    private List getCollectionStaticProperty(ClassPropertyFetcher cpf, String property) {
        List<Collection> colls = cpf.getStaticPropertyValuesFromInheritanceHierarchy(property, Collection.class);
        if (colls == null) {
            return Collections.emptyList();
        }
        ArrayList values = new ArrayList();
        for (Collection coll : colls) {
            values.addAll(coll);
        }
        return values;
    }

    @Override
    public List<PersistentProperty> getPersistentProperties(PersistentEntity entity, MappingContext context, ClassMapping classMapping) {
        return this.getPersistentProperties(entity, context, classMapping, false);
    }

    private Map getMapStaticProperty(ClassPropertyFetcher cpf, String property) {
        List<Map> maps = cpf.getStaticPropertyValuesFromInheritanceHierarchy(property, Map.class);
        if (maps == null) {
            return Collections.emptyMap();
        }
        HashMap values = new HashMap();
        for (int i = maps.size(); i > 0; --i) {
            Map map = maps.get(i - 1);
            values.putAll(map);
        }
        return values;
    }

    protected void configureOwningSide(Association association) {
        PersistentEntity associatedEntity = association.getAssociatedEntity();
        if (associatedEntity == null) {
            association.setOwningSide(true);
        } else if (association.isBidirectional()) {
            if (associatedEntity.isOwningEntity(association.getOwner())) {
                association.setOwningSide(true);
            }
        } else if (association instanceof OneToOne) {
            if (associatedEntity.isOwningEntity(association.getOwner())) {
                association.setOwningSide(true);
            }
        } else if (!(association instanceof Basic)) {
            if (associatedEntity.isOwningEntity(association.getOwner())) {
                association.setOwningSide(true);
            } else {
                association.setOwningSide(false);
            }
        }
    }

    private Set establishRelationshipOwners(ClassPropertyFetcher cpf) {
        HashSet<Class<Object>> owners = new HashSet<Class<Object>>();
        owners.addAll(cpf.getStaticPropertyValuesFromInheritanceHierarchy("belongsTo", Class.class));
        owners.addAll(this.getCollectionStaticProperty(cpf, "belongsTo"));
        owners.addAll(this.getMapStaticProperty(cpf, "belongsTo").values());
        return owners;
    }

    protected Association establishRelationshipForCollection(PropertyDescriptor property, PersistentEntity entity, MappingContext context, Map<String, Class> hasManyMap, Map mappedByMap, boolean embedded) {
        Class javaClass;
        Class genericClass;
        Class relatedClassType = hasManyMap.get(property.getName());
        if (relatedClassType == null && entity != null && (genericClass = MappingUtils.getGenericTypeForProperty(javaClass = entity.getJavaClass(), property.getName())) != null) {
            relatedClassType = genericClass;
        }
        if (relatedClassType == null) {
            return this.propertyFactory.createBasicCollection(entity, context, property);
        }
        if (embedded) {
            if (this.propertyFactory.isSimpleType(relatedClassType)) {
                return this.propertyFactory.createBasicCollection(entity, context, property, relatedClassType);
            }
            if (!this.isPersistentEntity(relatedClassType)) {
                EmbeddedCollection association = this.propertyFactory.createEmbeddedCollection(entity, context, property);
                PersistentEntity associatedEntity = this.getOrCreateEmbeddedEntity(entity, context, relatedClassType);
                association.setAssociatedEntity(associatedEntity);
                return association;
            }
        } else if (!this.isPersistentEntity(relatedClassType) && !relatedClassType.equals(entity.getJavaClass())) {
            return this.propertyFactory.createBasicCollection(entity, context, property, relatedClassType);
        }
        ClassPropertyFetcher referencedCpf = ClassPropertyFetcher.forClass(relatedClassType);
        String referencedPropertyName = null;
        Map relatedClassRelationships = this.getAssociationMap(referencedCpf, "hasMany");
        Class<?> relatedClassPropertyType = null;
        String relatedClassPropertyName = null;
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(entity.getJavaClass());
        String mappingProperty = (String)mappedByMap.get(property.getName());
        if (StringUtils.hasText((String)mappingProperty)) {
            PropertyDescriptor pd = this.findProperty(this.getPropertiesAssignableFromType(entity.getJavaClass(), referencedCpf), mappingProperty);
            if (pd == null) {
                pd = this.findProperty(referencedCpf.getPropertiesAssignableToType(Collection.class), mappingProperty);
            }
            if (pd == null && !MAPPED_BY_NONE.equals(mappingProperty)) {
                if (entity.isExternal()) {
                    return null;
                }
                throw new IllegalMappingException("Non-existent mapping property [" + mappingProperty + "] specified for property [" + property.getName() + "] in class [" + entity.getJavaClass().getName() + "]");
            }
            if (pd != null) {
                relatedClassPropertyType = pd.getPropertyType();
                relatedClassPropertyName = referencedPropertyName = pd.getName();
            }
        } else if (!this.forceUnidirectional(property, mappedByMap)) {
            if (this.isRelationshipToMany(entity, relatedClassType, relatedClassRelationships)) {
                Map relatedClassMappedBy = this.getMapStaticProperty(referencedCpf, "mappedBy");
                for (Object o : relatedClassRelationships.keySet()) {
                    Class currentClass;
                    String currentKey = (String)o;
                    String mappedByProperty = (String)relatedClassMappedBy.get(currentKey);
                    if (mappedByProperty != null && !mappedByProperty.equals(property.getName()) || !(currentClass = (Class)relatedClassRelationships.get(currentKey)).isAssignableFrom(entity.getJavaClass())) continue;
                    relatedClassPropertyName = currentKey;
                    break;
                }
                if (relatedClassPropertyName != null) {
                    relatedClassPropertyType = referencedCpf.getPropertyType(relatedClassPropertyName);
                }
            }
            if (relatedClassPropertyType == null || Collection.class.isAssignableFrom(relatedClassPropertyType)) {
                List<PropertyDescriptor> descriptors = this.getPropertiesAssignableFromType(entity.getJavaClass(), referencedCpf);
                Map relatedMappedBy = referencedCpf.getStaticPropertyValue("mappedBy", Map.class);
                List referencedTransients = referencedCpf.getStaticPropertyValue("transients", List.class);
                List referencedEmbedded = referencedCpf.getStaticPropertyValue("embedded", List.class);
                if (referencedTransients == null) {
                    referencedTransients = Collections.emptyList();
                }
                if (referencedEmbedded == null) {
                    referencedEmbedded = Collections.emptyList();
                }
                if (relatedMappedBy == null) {
                    relatedMappedBy = Collections.emptyMap();
                }
                if (descriptors.size() == 1) {
                    PropertyDescriptor pd = descriptors.get(0);
                    if (!referencedTransients.contains(pd.getName()) && !referencedEmbedded.contains(pd.getName()) && this.isNotMappedToDifferentProperty(property, pd.getName(), relatedMappedBy)) {
                        relatedClassPropertyType = pd.getPropertyType();
                        referencedPropertyName = pd.getName();
                    }
                } else if (descriptors.size() > 1) {
                    String classPropertyName = entity.getDecapitalizedName();
                    PropertyDescriptor pd = this.findProperty(descriptors, classPropertyName);
                    if (pd == null) {
                        if (entity.isExternal()) {
                            return null;
                        }
                        pd = descriptors.get(0);
                    }
                    if (pd != null && this.isNotMappedToDifferentProperty(property, pd.getName(), relatedMappedBy)) {
                        relatedClassPropertyType = pd.getPropertyType();
                        referencedPropertyName = pd.getName();
                    }
                }
            }
        }
        boolean isInverseSideEntity = this.isPersistentEntity(relatedClassPropertyType);
        Association association = null;
        boolean many = false;
        if (embedded) {
            association = this.propertyFactory.createEmbeddedCollection(entity, context, property);
        } else if (relatedClassPropertyType == null || isInverseSideEntity) {
            association = this.propertyFactory.createOneToMany(entity, context, property);
        } else if (Collection.class.isAssignableFrom(relatedClassPropertyType) || Map.class.isAssignableFrom(relatedClassPropertyType)) {
            association = this.propertyFactory.createManyToMany(entity, context, property);
            ((ManyToMany)association).setInversePropertyName(relatedClassPropertyName);
            many = true;
        } else {
            association = this.propertyFactory.createOneToMany(entity, context, property);
        }
        PersistentEntity associatedEntity = this.getOrCreateAssociatedEntity(entity, context, relatedClassType);
        if (many) {
            Map classRelationships = referencedCpf.getPropertyValue("hasMany", Map.class);
            referencedPropertyName = this.findManyRelatedClassPropertyName(null, referencedCpf, classRelationships, entity.getJavaClass());
        }
        if (association != null) {
            association.setAssociatedEntity(associatedEntity);
            if (referencedPropertyName != null) {
                association.setReferencedPropertyName(referencedPropertyName);
            }
        }
        return association;
    }

    private List<PropertyDescriptor> getPropertiesAssignableFromType(Class type, ClassPropertyFetcher propertyFetcher) {
        List<PropertyDescriptor> props = propertyFetcher.getPropertiesAssignableFromType(type);
        ArrayList<PropertyDescriptor> valid = new ArrayList<PropertyDescriptor>(props.size());
        for (PropertyDescriptor prop : props) {
            if (prop.getPropertyType() == null || prop.getPropertyType().equals(Object.class)) continue;
            valid.add(prop);
        }
        return valid;
    }

    private String findManyRelatedClassPropertyName(String propertyName, ClassPropertyFetcher cpf, Map classRelationships, Class<?> classType) {
        Map mappedBy = this.getMapStaticProperty(cpf, "mappedBy");
        for (Object o : classRelationships.keySet()) {
            Class currentClass;
            String currentKey = (String)o;
            String mappedByProperty = (String)mappedBy.get(currentKey);
            if (mappedByProperty != null && !mappedByProperty.equals(propertyName) || !(currentClass = (Class)classRelationships.get(currentKey)).isAssignableFrom(classType)) continue;
            return currentKey;
        }
        return null;
    }

    private boolean isRelationshipToMany(PersistentEntity entity, Class<?> relatedClassType, Map relatedClassRelationships) {
        return relatedClassRelationships != null && !relatedClassRelationships.isEmpty() && !relatedClassType.equals(entity.getJavaClass());
    }

    private PropertyDescriptor findProperty(List<PropertyDescriptor> descriptors, String propertyName) {
        for (PropertyDescriptor descriptor : descriptors) {
            if (!descriptor.getName().equals(propertyName)) continue;
            return descriptor;
        }
        return null;
    }

    private ToOne establishDomainClassRelationship(PersistentEntity entity, PropertyDescriptor property, MappingContext context, Map hasOneMap, boolean embedded) {
        ToOne association = null;
        Class<?> propType = property.getPropertyType();
        if (embedded && !this.isPersistentEntity(propType)) {
            PersistentEntity associatedEntity = this.getOrCreateEmbeddedEntity(entity, context, propType);
            association = this.propertyFactory.createEmbedded(entity, context, property);
            association.setAssociatedEntity(associatedEntity);
            return association;
        }
        ClassPropertyFetcher relatedCpf = ClassPropertyFetcher.forClass(propType);
        Map relatedClassRelationships = this.getAllAssociationMap(relatedCpf);
        Map mappedBy = this.getMapStaticProperty(relatedCpf, "mappedBy");
        Class relatedClassPropertyType = null;
        String relatedClassPropertyName = null;
        if (!this.forceUnidirectional(property, mappedBy)) {
            PropertyDescriptor first;
            Object descriptors;
            if (relatedClassRelationships != null && !relatedClassRelationships.isEmpty()) {
                Object mappedByValue;
                descriptors = ReflectionUtils.getPropertiesOfType(entity.getJavaClass(), propType);
                relatedClassPropertyName = this.findOneToManyThatMatchesType(entity, property, relatedClassRelationships, mappedBy, relatedCpf);
                Object v0 = mappedByValue = relatedClassPropertyName != null ? mappedBy.get(relatedClassPropertyName) : null;
                if (mappedByValue != null && property.getName().equals(mappedByValue)) {
                    relatedClassPropertyType = relatedCpf.getPropertyType(relatedClassPropertyName, true);
                } else if (((Object)descriptors).length == 1 && this.isNotMappedToDifferentProperty(property, relatedClassPropertyName, mappedBy)) {
                    PropertyDescriptor potentialProperty;
                    if (StringUtils.hasText((String)relatedClassPropertyName) && !(potentialProperty = relatedCpf.getPropertyDescriptor(relatedClassPropertyName)).equals(property)) {
                        relatedClassPropertyType = potentialProperty.getPropertyType();
                    }
                } else if (((Object)descriptors).length > 1) {
                    if (mappedBy.containsValue(property.getName())) {
                        for (Object o : mappedBy.keySet()) {
                            Class mappedByRelatedType;
                            String mappedByPropertyName = (String)o;
                            if (!property.getName().equals(mappedBy.get(mappedByPropertyName)) || (mappedByRelatedType = (Class)relatedClassRelationships.get(mappedByPropertyName)) == null || !propType.isAssignableFrom(mappedByRelatedType)) continue;
                            relatedClassPropertyType = relatedCpf.getPropertyType(mappedByPropertyName);
                        }
                    } else if (relatedClassPropertyName != null) {
                        String classNameAsProperty = Introspector.decapitalize(propType.getSimpleName());
                        if (property.getName().equals(classNameAsProperty) && !mappedBy.containsKey(relatedClassPropertyName)) {
                            relatedClassPropertyType = relatedCpf.getPropertyType(relatedClassPropertyName);
                        }
                    }
                }
            }
            if (relatedClassPropertyType == null && (descriptors = this.getPropertiesAssignableFromType(entity.getJavaClass(), relatedCpf)).size() == 1 && !(first = (PropertyDescriptor)descriptors.get(0)).equals(property)) {
                String otherSidePropertyName = first.getName();
                if (mappedBy.containsKey(otherSidePropertyName)) {
                    Object mapping = mappedBy.get(otherSidePropertyName);
                    if (mapping != null && mapping.equals(property.getName())) {
                        relatedClassPropertyType = first.getPropertyType();
                        relatedClassPropertyName = otherSidePropertyName;
                    }
                } else {
                    relatedClassPropertyType = first.getPropertyType();
                    relatedClassPropertyName = otherSidePropertyName;
                }
            }
        }
        boolean isAssociationEntity = this.isPersistentEntity(relatedClassPropertyType);
        if (relatedClassPropertyType == null || isAssociationEntity) {
            ToOne toOne = association = embedded ? this.propertyFactory.createEmbedded(entity, context, property) : this.propertyFactory.createOneToOne(entity, context, property);
            if (hasOneMap.containsKey(property.getName()) && !embedded) {
                association.setForeignKeyInChild(true);
            }
        } else if (!embedded && Collection.class.isAssignableFrom(relatedClassPropertyType) || Map.class.isAssignableFrom(relatedClassPropertyType)) {
            association = this.propertyFactory.createManyToOne(entity, context, property);
        }
        if (association != null) {
            PersistentEntity associatedEntity = this.getOrCreateAssociatedEntity(entity, context, propType);
            association.setAssociatedEntity(associatedEntity);
            if (relatedClassPropertyName != null && relatedClassPropertyType != null) {
                association.setReferencedPropertyName(relatedClassPropertyName);
            }
        }
        return association;
    }

    private boolean forceUnidirectional(PropertyDescriptor property, Map mappedBy) {
        return mappedBy.containsKey(property.getName()) && mappedBy.get(property.getName()) == null;
    }

    protected PersistentEntity getOrCreateAssociatedEntity(PersistentEntity entity, MappingContext context, Class propType) {
        PersistentEntity associatedEntity = context.getPersistentEntity(propType.getName());
        if (associatedEntity == null) {
            if (this.canExpandMappingContext) {
                associatedEntity = entity.isExternal() ? context.addExternalPersistentEntity(propType) : context.addPersistentEntity(propType);
            }
        } else if (!associatedEntity.isInitialized()) {
            associatedEntity.initialize();
        }
        return associatedEntity;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected PersistentEntity getOrCreateEmbeddedEntity(PersistentEntity entity, MappingContext context, Class type) {
        PersistentEntity associatedEntity = context.getPersistentEntity(type.getName());
        if (associatedEntity != null) {
            if (associatedEntity.isInitialized()) return associatedEntity;
            associatedEntity.initialize();
            return associatedEntity;
        }
        if (!this.isPersistentEntity(type)) {
            PersistentEntity embeddedEntity = context.createEmbeddedEntity(type);
            embeddedEntity.initialize();
            return embeddedEntity;
        }
        if (entity.isExternal()) {
            associatedEntity = context.addExternalPersistentEntity(type);
            associatedEntity.initialize();
            return associatedEntity;
        }
        associatedEntity = context.addPersistentEntity(type);
        associatedEntity.initialize();
        return associatedEntity;
    }

    private boolean isNotMappedToDifferentProperty(PropertyDescriptor property, String relatedClassPropertyName, Map mappedBy) {
        String mappedByForRelation = (String)mappedBy.get(relatedClassPropertyName);
        if (mappedByForRelation == null) {
            return true;
        }
        return property.getName().equals(mappedByForRelation);
    }

    private String findOneToManyThatMatchesType(PersistentEntity entity, PropertyDescriptor pd, Map relatedClassRelationships, Map mappedBy, ClassPropertyFetcher relatedCpf) {
        for (Object o : relatedClassRelationships.keySet()) {
            PropertyDescriptor candidate;
            String currentKey = (String)o;
            Class currentClass = (Class)relatedClassRelationships.get(currentKey);
            Object mappedByValue = mappedBy.get(currentKey);
            if (!currentClass.isAssignableFrom(entity.getJavaClass()) || mappedByValue != null && !pd.getName().equals(mappedByValue) || (candidate = relatedCpf.getPropertyDescriptor(currentKey)) == null || candidate.equals(pd)) continue;
            return currentKey;
        }
        return null;
    }

    protected boolean isCollectionType(Class type) {
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    protected boolean isExcludedProperty(String propertyName, ClassMapping classMapping, Collection transients, boolean includeIdentifiers) {
        IdentityMapping id = classMapping != null ? classMapping.getIdentifier() : null;
        String[] identifierName = id != null && !includeIdentifiers ? id.getIdentifierName() : null;
        return this.isExcludeId(propertyName, id, identifierName, includeIdentifiers) || EXCLUDED_PROPERTIES.contains(propertyName) || transients.contains(propertyName);
    }

    private boolean isExcludeId(String propertyName, IdentityMapping id, String[] identifierName, boolean includeIdentifiers) {
        return !includeIdentifiers && (identifierName != null && this.isIdentifierProperty(propertyName, identifierName) || id == null && propertyName.equals(IDENTITY_PROPERTY));
    }

    private boolean isIdentifierProperty(String propertyName, String[] identifierName) {
        for (String n : identifierName) {
            if (!propertyName.equals(n)) continue;
            return true;
        }
        return false;
    }

    public Map getAssociationMap(ClassPropertyFetcher cpf) {
        return this.getAssociationMap(cpf, "hasMany");
    }

    protected Map getAllAssociationMap(ClassPropertyFetcher cpf) {
        Map associationMap = this.getAssociationMap(cpf, "hasMany");
        associationMap.putAll(this.getAssociationMap(cpf, "hasOne"));
        associationMap.putAll(this.getAssociationMap(cpf, "belongsTo"));
        return associationMap;
    }

    private Map getAssociationMap(ClassPropertyFetcher cpf, String relationshipType) {
        return this.getMapStaticProperty(cpf, relationshipType);
    }

    private PersistentEntity getPersistentEntity(Class javaClass, MappingContext context, ClassMapping classMapping) {
        if (classMapping != null) {
            return classMapping.getEntity();
        }
        return context.getPersistentEntity(javaClass.getName());
    }

    @Override
    public Set getOwningEntities(Class javaClass, MappingContext context) {
        return this.establishRelationshipOwners(ClassPropertyFetcher.forClass(javaClass));
    }

    @Override
    public PersistentProperty[] getCompositeIdentity(Class javaClass, MappingContext context) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(javaClass);
        PersistentEntity entity = context.getPersistentEntity(javaClass.getName());
        ClassMapping mapping = entity.getMapping();
        IdentityMapping id = mapping.getIdentifier();
        String[] names = id.getIdentifierName();
        PersistentProperty[] identifiers = new PersistentProperty[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            PersistentProperty p = entity.getPropertyByName(name);
            if (p != null) {
                identifiers[i] = p;
                continue;
            }
            PropertyDescriptor pd = cpf.getPropertyDescriptor(name);
            if (pd != null) {
                identifiers[i] = this.propertyFactory.createIdentity(entity, context, pd);
                continue;
            }
            throw new IllegalMappingException("Invalid composite id mapping. Could not resolve property [" + name + "] for entity [" + javaClass.getName() + "]");
        }
        return identifiers;
    }

    @Override
    public PersistentProperty getIdentity(Class javaClass, MappingContext context) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(javaClass);
        PersistentEntity entity = context.getPersistentEntity(javaClass.getName());
        ClassMapping mapping = entity.getMapping();
        IdentityMapping id = mapping.getIdentifier();
        String[] names = id.getIdentifierName();
        if (names.length == 1) {
            PropertyDescriptor pd = cpf.getPropertyDescriptor(names[0]);
            if (pd != null) {
                return this.propertyFactory.createIdentity(entity, context, pd);
            }
            if (!entity.isExternal() && GormMappingConfigurationStrategy.isAbstract(entity)) {
                throw new IllegalMappingException("Mapped identifier [" + names[0] + "] for class [" + javaClass.getName() + "] is not a valid property");
            }
            return null;
        }
        return null;
    }

    public static boolean isAbstract(PersistentEntity entity) {
        return Modifier.isAbstract(entity.getJavaClass().getModifiers());
    }

    @Override
    public IdentityMapping getIdentityMapping(ClassMapping classMapping) {
        return this.propertyFactory.createIdentityMapping(classMapping);
    }

    @Override
    public IdentityMapping getDefaultIdentityMapping(ClassMapping classMapping) {
        return this.propertyFactory.createDefaultIdentityMapping(classMapping);
    }
}

