/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum HorizontalAlignment {
    LEFT,
    CENTER,
    RIGHT;


    public void format(StringBuilder buffer, String text, int width) {
        int i;
        int spacesAfter;
        int spacesBefore;
        int length = text.length();
        if (length >= width) {
            buffer.append(text.substring(0, width));
            return;
        }
        switch (this) {
            case LEFT: {
                spacesBefore = 0;
                spacesAfter = width - length;
                break;
            }
            case CENTER: {
                int totalSpaces = width - length;
                spacesBefore = totalSpaces / 2;
                spacesAfter = totalSpaces - spacesBefore;
                break;
            }
            default: {
                spacesBefore = width - length;
                spacesAfter = 0;
            }
        }
        for (i = 0; i < spacesBefore; ++i) {
            buffer.append(' ');
        }
        buffer.append(text);
        for (i = 0; i < spacesAfter; ++i) {
            buffer.append(' ');
        }
    }
}

