/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;
import org.elasticsearch.xpack.core.security.authc.support.CharArrays;

public class ChangePasswordRequest
extends ActionRequest
implements UserRequest,
WriteRequest<ChangePasswordRequest> {
    private String username;
    private char[] passwordHash;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.username == null) {
            validationException = ValidateActions.addValidationError((String)"username is missing", validationException);
        }
        if (this.passwordHash == null) {
            validationException = ValidateActions.addValidationError((String)"password is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String username() {
        return this.username;
    }

    public void username(String username) {
        this.username = username;
    }

    public char[] passwordHash() {
        return this.passwordHash;
    }

    public void passwordHash(char[] passwordHash) {
        this.passwordHash = passwordHash;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public ChangePasswordRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public String[] usernames() {
        return new String[]{this.username};
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.username = in.readString();
        this.passwordHash = CharArrays.utf8BytesToChars(BytesReference.toBytes((BytesReference)in.readBytesReference()));
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.username);
        out.writeBytesReference((BytesReference)new BytesArray(CharArrays.toUtf8Bytes(this.passwordHash)));
        this.refreshPolicy.writeTo(out);
    }
}

