/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade.actions;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.upgrade.UpgradeActionRequired;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeInfoAction;
import org.elasticsearch.xpack.upgrade.IndexUpgradeService;

public class TransportIndexUpgradeInfoAction
extends TransportMasterNodeReadAction<IndexUpgradeInfoAction.Request, IndexUpgradeInfoAction.Response> {
    private final IndexUpgradeService indexUpgradeService;
    private final XPackLicenseState licenseState;

    @Inject
    public TransportIndexUpgradeInfoAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexUpgradeService indexUpgradeService, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState) {
        super(settings, "cluster:admin/xpack/upgrade/info", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, IndexUpgradeInfoAction.Request::new);
        this.indexUpgradeService = indexUpgradeService;
        this.licenseState = licenseState;
    }

    protected String executor() {
        return "generic";
    }

    protected IndexUpgradeInfoAction.Response newResponse() {
        return new IndexUpgradeInfoAction.Response();
    }

    protected ClusterBlockException checkBlock(IndexUpgradeInfoAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected final void masterOperation(IndexUpgradeInfoAction.Request request, ClusterState state, ActionListener<IndexUpgradeInfoAction.Response> listener) {
        if (this.licenseState.isUpgradeAllowed()) {
            Map<String, UpgradeActionRequired> results = this.indexUpgradeService.upgradeInfo(request.indices(), request.indicesOptions(), state);
            listener.onResponse((Object)new IndexUpgradeInfoAction.Response(results));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"upgrade"));
        }
    }
}

