/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

final class LatLonDocValuesDistanceQuery
extends Query {
    private final String field;
    private final double latitude;
    private final double longitude;
    private final double radiusMeters;

    LatLonDocValuesDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        GeoUtils.checkLatitude((double)latitude);
        GeoUtils.checkLongitude((double)longitude);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LatLonDocValuesDistanceQuery other = (LatLonDocValuesDistanceQuery)((Object)obj);
        return this.field.equals(other.field) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(other.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude) && Double.doubleToLongBits(this.radiusMeters) == Double.doubleToLongBits(other.radiusMeters);
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Double.hashCode(this.latitude);
        h = 31 * h + Double.hashCode(this.longitude);
        h = 31 * h + Double.hashCode(this.radiusMeters);
        return h;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){
            private final GeoEncodingUtils.DistancePredicate distancePredicate;
            {
                super(x0, x1);
                this.distancePredicate = GeoEncodingUtils.createDistancePredicate((double)LatLonDocValuesDistanceQuery.this.latitude, (double)LatLonDocValuesDistanceQuery.this.longitude, (double)LatLonDocValuesDistanceQuery.this.radiusMeters);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = context.reader().getSortedNumericDocValues(LatLonDocValuesDistanceQuery.this.field);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            int lat = (int)(value >>> 32);
                            int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                            if (!distancePredicate.test(lat, lon)) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 100.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, boost, iterator);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{LatLonDocValuesDistanceQuery.this.field});
            }
        };
    }
}

