/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.pagerduty;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.pagerduty.IncidentEventDefaults;

public class IncidentEventContext
implements ToXContentObject {
    final Type type;
    final String href;
    final String text;
    final String src;
    final String alt;

    public static IncidentEventContext link(String href, @Nullable String text) {
        assert (href != null);
        return new IncidentEventContext(Type.LINK, href, text, null, null);
    }

    public static IncidentEventContext image(String src, @Nullable String href, @Nullable String alt) {
        assert (src != null);
        return new IncidentEventContext(Type.IMAGE, href, null, src, alt);
    }

    private IncidentEventContext(Type type, String href, String text, String src, String alt) {
        this.type = type;
        this.href = href;
        this.text = text;
        this.src = src;
        this.alt = alt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentEventContext that = (IncidentEventContext)o;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.href, that.href) && Objects.equals(this.text, that.text) && Objects.equals(this.src, that.src) && Objects.equals(this.alt, that.alt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.href, this.text, this.src, this.alt});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(XField.TYPE.getPreferredName(), this.type.name().toLowerCase(Locale.ROOT));
        switch (this.type) {
            case LINK: {
                builder.field(XField.HREF.getPreferredName(), this.href);
                if (this.text == null) break;
                builder.field(XField.TEXT.getPreferredName(), this.text);
                break;
            }
            case IMAGE: {
                builder.field(XField.SRC.getPreferredName(), this.src);
                if (this.href != null) {
                    builder.field(XField.HREF.getPreferredName(), this.href);
                }
                if (this.alt == null) break;
                builder.field(XField.ALT.getPreferredName(), this.alt);
            }
        }
        return builder.endObject();
    }

    static interface XField {
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField HREF = new ParseField("href", new String[0]);
        public static final ParseField TEXT = new ParseField("text", new String[0]);
        public static final ParseField SRC = new ParseField("src", new String[0]);
        public static final ParseField ALT = new ParseField("alt", new String[0]);
    }

    public static class Template
    implements ToXContentObject {
        final Type type;
        final TextTemplate href;
        final TextTemplate text;
        final TextTemplate src;
        final TextTemplate alt;

        public static Template link(TextTemplate href, @Nullable TextTemplate text) {
            if (href == null) {
                throw new IllegalStateException("could not create link context for pager duty trigger incident event. missing required [href] setting");
            }
            return new Template(Type.LINK, href, text, null, null);
        }

        public static Template image(TextTemplate src, @Nullable TextTemplate href, @Nullable TextTemplate alt) {
            if (src == null) {
                throw new IllegalStateException("could not create link context for pager duty trigger incident event. missing required [src] setting");
            }
            return new Template(Type.IMAGE, href, null, src, alt);
        }

        private Template(Type type, TextTemplate href, TextTemplate text, TextTemplate src, TextTemplate alt) {
            this.type = type;
            this.href = href;
            this.text = text;
            this.src = src;
            this.alt = alt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template that = (Template)o;
            return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.href, that.href) && Objects.equals(this.text, that.text) && Objects.equals(this.src, that.src) && Objects.equals(this.alt, that.alt);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.href, this.text, this.src, this.alt});
        }

        public IncidentEventContext render(TextTemplateEngine engine, Map<String, Object> model, IncidentEventDefaults defaults) {
            switch (this.type) {
                case LINK: {
                    String href = this.href != null ? engine.render(this.href, model) : defaults.link.href;
                    String text = this.text != null ? engine.render(this.text, model) : defaults.link.text;
                    return IncidentEventContext.link(href, text);
                }
            }
            assert (this.type == Type.IMAGE);
            String src = this.src != null ? engine.render(this.src, model) : defaults.image.src;
            String href = this.href != null ? engine.render(this.href, model) : defaults.image.href;
            String alt = this.alt != null ? engine.render(this.alt, model) : defaults.image.alt;
            return IncidentEventContext.image(src, href, alt);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(XField.TYPE.getPreferredName(), this.type.name().toLowerCase(Locale.ROOT));
            switch (this.type) {
                case LINK: {
                    builder.field(XField.HREF.getPreferredName(), (ToXContent)this.href, params);
                    if (this.text == null) break;
                    builder.field(XField.TEXT.getPreferredName(), (ToXContent)this.text, params);
                    break;
                }
                case IMAGE: {
                    builder.field(XField.SRC.getPreferredName(), (ToXContent)this.src, params);
                    if (this.href != null) {
                        builder.field(XField.HREF.getPreferredName(), (ToXContent)this.href, params);
                    }
                    if (this.alt == null) break;
                    builder.field(XField.ALT.getPreferredName(), (ToXContent)this.alt, params);
                }
            }
            return builder.endObject();
        }

        public static Template parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            Type type = null;
            TextTemplate href = null;
            TextTemplate text = null;
            TextTemplate src = null;
            TextTemplate alt = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                TextTemplate parsedTemplate;
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (!Strings.hasLength(currentFieldName)) continue;
                if (XField.TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        type = Type.valueOf(parser.text().toUpperCase(Locale.ROOT));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        String msg = "could not parse trigger incident event context. unknown context type [{}]";
                        throw new ElasticsearchParseException(msg, new Object[]{parser.text()});
                    }
                }
                try {
                    parsedTemplate = TextTemplate.parse(parser);
                }
                catch (ElasticsearchParseException e) {
                    String msg = "could not parse trigger incident event context. failed to parse [{}] field";
                    throw new ElasticsearchParseException(msg, (Throwable)e, new Object[]{currentFieldName});
                }
                if (XField.HREF.match(currentFieldName, parser.getDeprecationHandler())) {
                    href = parsedTemplate;
                    continue;
                }
                if (XField.TEXT.match(currentFieldName, parser.getDeprecationHandler())) {
                    text = parsedTemplate;
                    continue;
                }
                if (XField.SRC.match(currentFieldName, parser.getDeprecationHandler())) {
                    src = parsedTemplate;
                    continue;
                }
                if (XField.ALT.match(currentFieldName, parser.getDeprecationHandler())) {
                    alt = parsedTemplate;
                    continue;
                }
                String msg = "could not parse trigger incident event context. unknown field [{}]";
                throw new ElasticsearchParseException(msg, new Object[]{currentFieldName});
            }
            return Template.createAndValidateTemplate(type, href, src, alt, text);
        }

        private static Template createAndValidateTemplate(Type type, TextTemplate href, TextTemplate src, TextTemplate alt, TextTemplate text) {
            if (type == null) {
                throw new ElasticsearchParseException("could not parse trigger incident event context. missing required field [{}]", new Object[]{XField.TYPE.getPreferredName()});
            }
            switch (type) {
                case LINK: {
                    if (href == null) {
                        throw new ElasticsearchParseException("could not parse trigger incident event context. missing required field [{}] for [{}] context", new Object[]{XField.HREF.getPreferredName(), Type.LINK.name().toLowerCase(Locale.ROOT)});
                    }
                    if (src != null) {
                        throw new ElasticsearchParseException("could not parse trigger incident event context. unexpected field [{}] for [{}] context", new Object[]{XField.SRC.getPreferredName(), Type.LINK.name().toLowerCase(Locale.ROOT)});
                    }
                    if (alt != null) {
                        throw new ElasticsearchParseException("could not parse trigger incident event context. unexpected field [{}] for [{}] context", new Object[]{XField.ALT.getPreferredName(), Type.LINK.name().toLowerCase(Locale.ROOT)});
                    }
                    return Template.link(href, text);
                }
                case IMAGE: {
                    if (src == null) {
                        throw new ElasticsearchParseException("could not parse trigger incident event context. missing required field [{}] for [{}] context", new Object[]{XField.SRC.getPreferredName(), Type.IMAGE.name().toLowerCase(Locale.ROOT)});
                    }
                    if (text != null) {
                        throw new ElasticsearchParseException("could not parse trigger incident event context. unexpected field [{}] for [{}] context", new Object[]{XField.TEXT.getPreferredName(), Type.IMAGE.name().toLowerCase(Locale.ROOT)});
                    }
                    return Template.image(src, href, alt);
                }
            }
            throw new ElasticsearchParseException("could not parse trigger incident event context. unknown context type [{}]", new Object[]{type});
        }
    }

    static enum Type {
        LINK,
        IMAGE;

    }
}

