/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStats;

public abstract class Engine
implements Closeable {
    public static final String SYNC_COMMIT_ID = "sync_id";
    public static final String HISTORY_UUID_KEY = "history_uuid";
    protected final ShardId shardId;
    protected final String allocationId;
    protected final Logger logger;
    protected final EngineConfig engineConfig;
    protected final Store store;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    protected final EventListener eventListener;
    protected final ReentrantLock failEngineLock = new ReentrantLock();
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final ReleasableLock readLock = new ReleasableLock(this.rwl.readLock());
    protected final ReleasableLock writeLock = new ReleasableLock(this.rwl.writeLock());
    protected final SetOnce<Exception> failedEngine = new SetOnce();
    protected volatile long lastWriteNanos = System.nanoTime();

    protected Engine(EngineConfig engineConfig) {
        Objects.requireNonNull(engineConfig.getStore(), "Store must be provided to the engine");
        this.engineConfig = engineConfig;
        this.shardId = engineConfig.getShardId();
        this.allocationId = engineConfig.getAllocationId();
        this.store = engineConfig.getStore();
        this.logger = Loggers.getLogger(Engine.class, engineConfig.getIndexSettings().getSettings(), engineConfig.getShardId(), new String[0]);
        this.eventListener = engineConfig.getEventListener();
    }

    protected static long guardedRamBytesUsed(Accountable a) {
        if (a == null) {
            return 0L;
        }
        return a.ramBytesUsed();
    }

    protected static boolean isMergedSegment(LeafReader reader) {
        Map diagnostics = Lucene.segmentReader((LeafReader)reader).getSegmentInfo().info.getDiagnostics();
        String source = (String)diagnostics.get("source");
        assert (Arrays.asList("addIndexes(CodecReader...)", "flush", "merge").contains(source)) : "Unknown source " + source;
        return "merge".equals(source);
    }

    public final EngineConfig config() {
        return this.engineConfig;
    }

    protected abstract SegmentInfos getLastCommittedSegmentInfos();

    public MergeStats getMergeStats() {
        return new MergeStats();
    }

    public abstract String getHistoryUUID();

    public abstract long getWritingBytes();

    public abstract long getIndexThrottleTimeInMillis();

    public abstract boolean isThrottled();

    public abstract void trimOperationsFromTranslog(long var1, long var3) throws EngineException;

    public abstract IndexResult index(Index var1) throws IOException;

    public abstract DeleteResult delete(Delete var1) throws IOException;

    public abstract NoOpResult noOp(NoOp var1);

    public abstract SyncedFlushResult syncFlush(String var1, CommitId var2) throws EngineException;

    protected final GetResult getFromSearcher(Get get, BiFunction<String, SearcherScope, Searcher> searcherFactory, SearcherScope scope) throws EngineException {
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion;
        Searcher searcher = searcherFactory.apply("get", scope);
        try {
            docIdAndVersion = VersionsAndSeqNoResolver.loadDocIdAndVersion(searcher.reader(), get.uid());
        }
        catch (Exception e) {
            Releasables.closeWhileHandlingException(searcher);
            throw new EngineException(this.shardId, "Couldn't resolve version", e, new Object[0]);
        }
        if (docIdAndVersion != null && get.versionType().isVersionConflictForReads(docIdAndVersion.version, get.version())) {
            Releasables.close(searcher);
            throw new VersionConflictEngineException(this.shardId, get.type(), get.id(), get.versionType().explainConflictForReads(docIdAndVersion.version, get.version()));
        }
        if (docIdAndVersion != null) {
            return new GetResult(searcher, docIdAndVersion);
        }
        Releasables.close(searcher);
        return GetResult.NOT_EXISTS;
    }

    public abstract GetResult get(Get var1, BiFunction<String, SearcherScope, Searcher> var2) throws EngineException;

    public final Searcher acquireSearcher(String source) throws EngineException {
        return this.acquireSearcher(source, SearcherScope.EXTERNAL);
    }

    public abstract Searcher acquireSearcher(String var1, SearcherScope var2) throws EngineException;

    public abstract boolean isTranslogSyncNeeded();

    public abstract boolean ensureTranslogSynced(Stream<Translog.Location> var1) throws IOException;

    public abstract void syncTranslog() throws IOException;

    public abstract Closeable acquireTranslogRetentionLock();

    public abstract Translog.Snapshot newTranslogSnapshotFromMinSeqNo(long var1) throws IOException;

    public abstract int estimateTranslogOperationsFromMinSeq(long var1);

    public abstract TranslogStats getTranslogStats();

    public abstract Translog.Location getTranslogLastWriteLocation();

    protected final void ensureOpen(Exception suppressed) {
        if (this.isClosed.get()) {
            AlreadyClosedException ace = new AlreadyClosedException(this.shardId + " engine is closed", (Throwable)this.failedEngine.get());
            if (suppressed != null) {
                ace.addSuppressed((Throwable)suppressed);
            }
            throw ace;
        }
    }

    protected final void ensureOpen() {
        this.ensureOpen(null);
    }

    public CommitStats commitStats() {
        return new CommitStats(this.getLastCommittedSegmentInfos());
    }

    public abstract long getLocalCheckpoint();

    public abstract void waitForOpsToComplete(long var1) throws InterruptedException;

    public abstract void resetLocalCheckpoint(long var1);

    public abstract SeqNoStats getSeqNoStats(long var1);

    public abstract long getLastSyncedGlobalCheckpoint();

    public final SegmentsStats segmentsStats(boolean includeSegmentFileSizes) {
        SegmentReader segmentReader;
        this.ensureOpen();
        HashSet<String> segmentName = new HashSet<String>();
        SegmentsStats stats = new SegmentsStats();
        try (Searcher searcher = this.acquireSearcher("segments_stats", SearcherScope.INTERNAL);){
            for (LeafReaderContext ctx : searcher.reader().getContext().leaves()) {
                segmentReader = Lucene.segmentReader(ctx.reader());
                this.fillSegmentStats(segmentReader, includeSegmentFileSizes, stats);
                segmentName.add(segmentReader.getSegmentName());
            }
        }
        searcher = this.acquireSearcher("segments_stats", SearcherScope.EXTERNAL);
        var5_5 = null;
        try {
            for (LeafReaderContext ctx : searcher.reader().getContext().leaves()) {
                segmentReader = Lucene.segmentReader(ctx.reader());
                if (segmentName.contains(segmentReader.getSegmentName())) continue;
                this.fillSegmentStats(segmentReader, includeSegmentFileSizes, stats);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (searcher != null) {
                Engine.$closeResource(var5_5, searcher);
            }
        }
        this.writerSegmentStats(stats);
        return stats;
    }

    private void fillSegmentStats(SegmentReader segmentReader, boolean includeSegmentFileSizes, SegmentsStats stats) {
        stats.add(1L, segmentReader.ramBytesUsed());
        stats.addTermsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getPostingsReader()));
        stats.addStoredFieldsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getFieldsReader()));
        stats.addTermVectorsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getTermVectorsReader()));
        stats.addNormsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getNormsReader()));
        stats.addPointsMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getPointsReader()));
        stats.addDocValuesMemoryInBytes(Engine.guardedRamBytesUsed((Accountable)segmentReader.getDocValuesReader()));
        if (includeSegmentFileSizes) {
            stats.addFileSizes(this.getSegmentFileSizes(segmentReader));
        }
    }

    private ImmutableOpenMap<String, Long> getSegmentFileSizes(SegmentReader segmentReader) {
        String[] files;
        Directory directory = null;
        SegmentCommitInfo segmentCommitInfo = segmentReader.getSegmentInfo();
        boolean useCompoundFile = segmentCommitInfo.info.getUseCompoundFile();
        if (useCompoundFile) {
            try {
                directory = this.engineConfig.getCodec().compoundFormat().getCompoundReader(segmentReader.directory(), segmentCommitInfo.info, IOContext.READ);
            }
            catch (IOException e) {
                this.logger.warn(() -> new ParameterizedMessage("Error when opening compound reader for Directory [{}] and SegmentCommitInfo [{}]", (Object)segmentReader.directory(), (Object)segmentCommitInfo), (Throwable)e);
                return ImmutableOpenMap.of();
            }
        } else {
            directory = segmentReader.directory();
        }
        assert (directory != null);
        if (useCompoundFile) {
            try {
                files = directory.listAll();
            }
            catch (IOException e) {
                Directory finalDirectory = directory;
                this.logger.warn(() -> new ParameterizedMessage("Couldn't list Compound Reader Directory [{}]", (Object)finalDirectory), (Throwable)e);
                return ImmutableOpenMap.of();
            }
        }
        try {
            files = segmentReader.getSegmentInfo().files().toArray(new String[0]);
        }
        catch (IOException e) {
            this.logger.warn(() -> new ParameterizedMessage("Couldn't list Directory from SegmentReader [{}] and SegmentInfo [{}]", (Object)segmentReader, (Object)segmentReader.getSegmentInfo()), (Throwable)e);
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder<String, Long> map = ImmutableOpenMap.builder();
        for (String file : files) {
            Directory finalDirectory;
            String extension = IndexFileNames.getExtension((String)file);
            long length = 0L;
            try {
                length = directory.fileLength(file);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                finalDirectory = directory;
                this.logger.warn(() -> new ParameterizedMessage("Tried to query fileLength but file is gone [{}] [{}]", (Object)finalDirectory, (Object)file), (Throwable)e);
            }
            catch (IOException e) {
                finalDirectory = directory;
                this.logger.warn(() -> new ParameterizedMessage("Error when trying to query fileLength [{}] [{}]", (Object)finalDirectory, (Object)file), (Throwable)e);
            }
            if (length == 0L) continue;
            map.put(extension, length);
        }
        if (useCompoundFile && directory != null) {
            try {
                directory.close();
            }
            catch (IOException e) {
                Directory finalDirectory = directory;
                this.logger.warn(() -> new ParameterizedMessage("Error when closing compound reader on Directory [{}]", (Object)finalDirectory), (Throwable)e);
            }
        }
        return map.build();
    }

    protected void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(0L);
        stats.addIndexWriterMemoryInBytes(0L);
    }

    public abstract long getIndexBufferRAMBytesUsed();

    protected Segment[] getSegmentInfo(SegmentInfos lastCommittedSegmentInfos, boolean verbose) {
        this.ensureOpen();
        HashMap<String, Segment> segments = new HashMap<String, Segment>();
        Searcher searcher = this.acquireSearcher("segments", SearcherScope.EXTERNAL);
        Object object = null;
        try {
            for (LeafReaderContext ctx : searcher.reader().getContext().leaves()) {
                this.fillSegmentInfo(Lucene.segmentReader(ctx.reader()), verbose, true, segments);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (searcher != null) {
                Engine.$closeResource((Throwable)object, searcher);
            }
        }
        searcher = this.acquireSearcher("segments", SearcherScope.INTERNAL);
        object = null;
        try {
            for (LeafReaderContext ctx : searcher.reader().getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader(ctx.reader());
                if (segments.containsKey(segmentReader.getSegmentName())) continue;
                this.fillSegmentInfo(segmentReader, verbose, false, segments);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (searcher != null) {
                Engine.$closeResource((Throwable)object, searcher);
            }
        }
        if (lastCommittedSegmentInfos != null) {
            SegmentInfos infos = lastCommittedSegmentInfos;
            for (SegmentCommitInfo info : infos) {
                Segment segment = (Segment)segments.get(info.info.name);
                if (segment == null) {
                    segment = new Segment(info.info.name);
                    segment.search = false;
                    segment.committed = true;
                    segment.docCount = info.info.maxDoc();
                    segment.delDocCount = info.getDelCount();
                    segment.version = info.info.getVersion();
                    segment.compound = info.info.getUseCompoundFile();
                    try {
                        segment.sizeInBytes = info.sizeInBytes();
                    }
                    catch (IOException e) {
                        this.logger.trace(() -> new ParameterizedMessage("failed to get size for [{}]", (Object)info.info.name), (Throwable)e);
                    }
                    segment.segmentSort = info.info.getIndexSort();
                    segment.attributes = info.info.getAttributes();
                    segments.put(info.info.name, segment);
                    continue;
                }
                segment.committed = true;
            }
        }
        Segment[] segmentsArr = segments.values().toArray(new Segment[segments.values().size()]);
        Arrays.sort(segmentsArr, Comparator.comparingLong(Segment::getGeneration));
        return segmentsArr;
    }

    private void fillSegmentInfo(SegmentReader segmentReader, boolean verbose, boolean search, Map<String, Segment> segments) {
        SegmentCommitInfo info = segmentReader.getSegmentInfo();
        assert (!segments.containsKey(info.info.name));
        Segment segment = new Segment(info.info.name);
        segment.search = search;
        segment.docCount = segmentReader.numDocs();
        segment.delDocCount = segmentReader.numDeletedDocs();
        segment.version = info.info.getVersion();
        segment.compound = info.info.getUseCompoundFile();
        try {
            segment.sizeInBytes = info.sizeInBytes();
        }
        catch (IOException e) {
            this.logger.trace(() -> new ParameterizedMessage("failed to get size for [{}]", (Object)info.info.name), (Throwable)e);
        }
        segment.memoryInBytes = segmentReader.ramBytesUsed();
        segment.segmentSort = info.info.getIndexSort();
        if (verbose) {
            segment.ramTree = Accountables.namedAccountable((String)"root", (Accountable)segmentReader);
        }
        segment.attributes = info.info.getAttributes();
        segments.put(info.info.name, segment);
    }

    public abstract List<Segment> segments(boolean var1);

    /*
     * Exception decompiling
     */
    public final boolean refreshNeeded() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public abstract void refresh(String var1) throws EngineException;

    public abstract void writeIndexingBuffer() throws EngineException;

    public abstract boolean shouldPeriodicallyFlush();

    public abstract CommitId flush(boolean var1, boolean var2) throws EngineException;

    public abstract CommitId flush() throws EngineException;

    public abstract void trimUnreferencedTranslogFiles() throws EngineException;

    public abstract boolean shouldRollTranslogGeneration();

    public abstract void rollTranslogGeneration() throws EngineException;

    public void forceMerge(boolean flush) throws IOException {
        this.forceMerge(flush, 1, false, false, false);
    }

    public abstract void forceMerge(boolean var1, int var2, boolean var3, boolean var4, boolean var5) throws EngineException, IOException;

    public abstract IndexCommitRef acquireLastIndexCommit(boolean var1) throws EngineException;

    public abstract IndexCommitRef acquireSafeIndexCommit() throws EngineException;

    private void maybeDie(String maybeMessage, Throwable maybeFatal) {
        ExceptionsHelper.maybeError(maybeFatal, this.logger).ifPresent(error -> {
            try {
                this.logger.error(maybeMessage, (Throwable)error);
            }
            finally {
                throw error;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failEngine(String reason, @Nullable Exception failure) {
        if (failure != null) {
            this.maybeDie(reason, failure);
        }
        if (this.failEngineLock.tryLock()) {
            this.store.incRef();
            try {
                if (this.failedEngine.get() != null) {
                    this.logger.warn(() -> new ParameterizedMessage("tried to fail engine but engine is already failed. ignoring. [{}]", (Object)reason), (Throwable)failure);
                    return;
                }
                this.failedEngine.set((Object)(failure != null ? failure : new IllegalStateException(reason)));
                try {
                    this.closeNoLock("engine failed on: [" + reason + "]", this.closedLatch);
                }
                finally {
                    this.logger.warn(() -> new ParameterizedMessage("failed engine [{}]", (Object)reason), (Throwable)failure);
                    if (Lucene.isCorruptionException(failure)) {
                        try {
                            this.store.markStoreCorrupted(new IOException("failed engine (reason: [" + reason + "])", ExceptionsHelper.unwrapCorruption(failure)));
                        }
                        catch (IOException e) {
                            this.logger.warn("Couldn't mark store corrupted", (Throwable)e);
                        }
                    }
                    this.eventListener.onFailedEngine(reason, failure);
                }
            }
            catch (Exception inner) {
                if (failure != null) {
                    inner.addSuppressed(failure);
                }
                this.logger.warn("failEngine threw exception", (Throwable)inner);
            }
            finally {
                this.store.decRef();
            }
        } else {
            this.logger.debug(() -> new ParameterizedMessage("tried to fail engine but could not acquire lock - engine should be failed by now [{}]", (Object)reason), (Throwable)failure);
        }
    }

    protected boolean maybeFailEngine(String source, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            this.failEngine("corrupt file (source: [" + source + "])", e);
            return true;
        }
        return false;
    }

    protected abstract void closeNoLock(String var1, CountDownLatch var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndClose() throws IOException {
        if (!this.isClosed.get()) {
            this.logger.trace("flushAndClose now acquire writeLock");
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.logger.trace("flushAndClose now acquired writeLock");
                try {
                    this.logger.debug("flushing shard on close - this might take some time to sync files to disk");
                    try {
                        this.flush();
                    }
                    catch (AlreadyClosedException ex) {
                        this.logger.debug("engine already closed - skipping flushAndClose");
                    }
                }
                finally {
                    this.close();
                }
            }
        }
        this.awaitPendingClose();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.get()) {
            this.logger.debug("close now acquiring writeLock");
            try (ReleasableLock lock = this.writeLock.acquire();){
                this.logger.debug("close acquired writeLock");
                this.closeNoLock("api", this.closedLatch);
            }
        }
        this.awaitPendingClose();
    }

    private void awaitPendingClose() {
        try {
            this.closedLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onSettingsChanged() {
    }

    public long getLastWriteNanos() {
        return this.lastWriteNanos;
    }

    public abstract void activateThrottling();

    public abstract void deactivateThrottling();

    public abstract void restoreLocalCheckpointFromTranslog() throws IOException;

    public abstract int fillSeqNoGaps(long var1) throws IOException;

    public abstract Engine recoverFromTranslog() throws IOException;

    public abstract void skipTranslogRecovery();

    public boolean isRecovering() {
        return false;
    }

    public abstract void maybePruneDeletes();

    public static interface Warmer {
        public void warm(Searcher var1);
    }

    public static class IndexCommitRef
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean();
        private final CheckedRunnable<IOException> onClose;
        private final IndexCommit indexCommit;

        IndexCommitRef(IndexCommit indexCommit, CheckedRunnable<IOException> onClose) {
            this.indexCommit = indexCommit;
            this.onClose = onClose;
        }

        @Override
        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                this.onClose.run();
            }
        }

        public IndexCommit getIndexCommit() {
            return this.indexCommit;
        }
    }

    public static class CommitId
    implements Writeable {
        private final byte[] id;

        public CommitId(byte[] id) {
            assert (id != null);
            this.id = Arrays.copyOf(id, id.length);
        }

        public CommitId(StreamInput in) throws IOException {
            assert (in != null);
            this.id = in.readByteArray();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByteArray(this.id);
        }

        public String toString() {
            return Base64.getEncoder().encodeToString(this.id);
        }

        public boolean idsEqual(byte[] id) {
            return Arrays.equals(id, this.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommitId commitId = (CommitId)o;
            return Arrays.equals(this.id, commitId.id);
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }
    }

    public static class GetResult
    implements Releasable {
        private final boolean exists;
        private final long version;
        private final VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion;
        private final Searcher searcher;
        public static final GetResult NOT_EXISTS = new GetResult(false, -1L, null, null);

        private GetResult(boolean exists, long version, VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion, Searcher searcher) {
            this.exists = exists;
            this.version = version;
            this.docIdAndVersion = docIdAndVersion;
            this.searcher = searcher;
        }

        public GetResult(Searcher searcher, VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion) {
            this(true, docIdAndVersion.version, docIdAndVersion, searcher);
        }

        public boolean exists() {
            return this.exists;
        }

        public long version() {
            return this.version;
        }

        public Searcher searcher() {
            return this.searcher;
        }

        public VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion() {
            return this.docIdAndVersion;
        }

        @Override
        public void close() {
            this.release();
        }

        public void release() {
            Releasables.close(this.searcher);
        }
    }

    public static class Get {
        private final boolean realtime;
        private final Term uid;
        private final String type;
        private final String id;
        private final boolean readFromTranslog;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;

        public Get(boolean realtime, boolean readFromTranslog, String type, String id, Term uid) {
            this.realtime = realtime;
            this.type = type;
            this.id = id;
            this.uid = uid;
            this.readFromTranslog = readFromTranslog;
        }

        public boolean realtime() {
            return this.realtime;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public Get version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Get versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public boolean isReadFromTranslog() {
            return this.readFromTranslog;
        }
    }

    public static class NoOp
    extends Operation {
        private final String reason;

        public String reason() {
            return this.reason;
        }

        public NoOp(long seqNo, long primaryTerm, Operation.Origin origin, long startTime, String reason) {
            super(null, seqNo, primaryTerm, -1L, null, origin, startTime);
            this.reason = reason;
        }

        @Override
        public Term uid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VersionType versionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation.TYPE operationType() {
            return Operation.TYPE.NO_OP;
        }

        @Override
        public int estimatedSizeInBytes() {
            return 2 * this.reason.length() + 16;
        }
    }

    public static class Delete
    extends Operation {
        private final String type;
        private final String id;

        public Delete(String type, String id, Term uid, long seqNo, long primaryTerm, long version, VersionType versionType, Operation.Origin origin, long startTime) {
            super(uid, seqNo, primaryTerm, version, versionType, origin, startTime);
            this.type = Objects.requireNonNull(type);
            this.id = Objects.requireNonNull(id);
        }

        public Delete(String type, String id, Term uid, long primaryTerm) {
            this(type, id, uid, -2L, primaryTerm, -3L, VersionType.INTERNAL, Operation.Origin.PRIMARY, System.nanoTime());
        }

        public Delete(Delete template, VersionType versionType) {
            this(template.type(), template.id(), template.uid(), template.seqNo(), template.primaryTerm(), template.version(), versionType, template.origin(), template.startTime());
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Operation.TYPE operationType() {
            return Operation.TYPE.DELETE;
        }

        @Override
        public int estimatedSizeInBytes() {
            return (this.uid().field().length() + this.uid().text().length()) * 2 + 20;
        }
    }

    public static class Index
    extends Operation {
        private final ParsedDocument doc;
        private final long autoGeneratedIdTimestamp;
        private final boolean isRetry;

        public Index(Term uid, ParsedDocument doc, long seqNo, long primaryTerm, long version, VersionType versionType, Operation.Origin origin, long startTime, long autoGeneratedIdTimestamp, boolean isRetry) {
            super(uid, seqNo, primaryTerm, version, versionType, origin, startTime);
            this.doc = doc;
            this.isRetry = isRetry;
            this.autoGeneratedIdTimestamp = autoGeneratedIdTimestamp;
        }

        public Index(Term uid, long primaryTerm, ParsedDocument doc) {
            this(uid, primaryTerm, doc, -3L);
        }

        Index(Term uid, long primaryTerm, ParsedDocument doc, long version) {
            this(uid, doc, -2L, primaryTerm, version, VersionType.INTERNAL, Operation.Origin.PRIMARY, System.nanoTime(), -1L, false);
        }

        public ParsedDocument parsedDoc() {
            return this.doc;
        }

        @Override
        public String type() {
            return this.doc.type();
        }

        @Override
        public String id() {
            return this.doc.id();
        }

        @Override
        public Operation.TYPE operationType() {
            return Operation.TYPE.INDEX;
        }

        public String routing() {
            return this.doc.routing();
        }

        public String parent() {
            return this.doc.parent();
        }

        public List<ParseContext.Document> docs() {
            return this.doc.docs();
        }

        public BytesReference source() {
            return this.doc.source();
        }

        @Override
        public int estimatedSizeInBytes() {
            return (this.id().length() + this.type().length()) * 2 + this.source().length() + 12;
        }

        public long getAutoGeneratedIdTimestamp() {
            return this.autoGeneratedIdTimestamp;
        }

        public boolean isRetry() {
            return this.isRetry;
        }
    }

    public static abstract class Operation {
        private final Term uid;
        private final long version;
        private final long seqNo;
        private final long primaryTerm;
        private final VersionType versionType;
        private final Origin origin;
        private final long startTime;

        public Operation(Term uid, long seqNo, long primaryTerm, long version, VersionType versionType, Origin origin, long startTime) {
            this.uid = uid;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.version = version;
            this.versionType = versionType;
            this.origin = origin;
            this.startTime = startTime;
        }

        public Origin origin() {
            return this.origin;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public long seqNo() {
            return this.seqNo;
        }

        public long primaryTerm() {
            return this.primaryTerm;
        }

        public abstract int estimatedSizeInBytes();

        public VersionType versionType() {
            return this.versionType;
        }

        public long startTime() {
            return this.startTime;
        }

        public abstract String type();

        abstract String id();

        public abstract TYPE operationType();

        public static enum Origin {
            PRIMARY,
            REPLICA,
            PEER_RECOVERY,
            LOCAL_TRANSLOG_RECOVERY;


            public boolean isRecovery() {
                return this == PEER_RECOVERY || this == LOCAL_TRANSLOG_RECOVERY;
            }
        }

        public static enum TYPE {
            INDEX,
            DELETE,
            NO_OP;

            private final String lowercase = this.toString().toLowerCase(Locale.ROOT);

            public String getLowercase() {
                return this.lowercase;
            }
        }
    }

    public static class Searcher
    implements Releasable {
        private final String source;
        private final IndexSearcher searcher;

        public Searcher(String source, IndexSearcher searcher) {
            this.source = source;
            this.searcher = searcher;
        }

        public String source() {
            return this.source;
        }

        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        public DirectoryReader getDirectoryReader() {
            if (this.reader() instanceof DirectoryReader) {
                return (DirectoryReader)this.reader();
            }
            throw new IllegalStateException("Can't use " + this.reader().getClass() + " as a directory reader");
        }

        public IndexSearcher searcher() {
            return this.searcher;
        }

        @Override
        public void close() {
        }
    }

    public static interface EventListener {
        default public void onFailedEngine(String reason, @Nullable Exception e) {
        }
    }

    public static enum SearcherScope {
        EXTERNAL,
        INTERNAL;

    }

    public static enum SyncedFlushResult {
        SUCCESS,
        COMMIT_MISMATCH,
        PENDING_OPERATIONS;

    }

    public static class NoOpResult
    extends Result {
        NoOpResult(long term, long seqNo) {
            super(Operation.TYPE.NO_OP, term, 0L, seqNo);
        }

        NoOpResult(long term, long seqNo, Exception failure) {
            super(Operation.TYPE.NO_OP, failure, term, 0L, seqNo);
        }
    }

    public static class DeleteResult
    extends Result {
        private final boolean found;

        public DeleteResult(long version, long term, long seqNo, boolean found) {
            super(Operation.TYPE.DELETE, version, term, seqNo);
            this.found = found;
        }

        public DeleteResult(Exception failure, long version, long term) {
            this(failure, version, term, -2L, false);
        }

        public DeleteResult(Exception failure, long version, long term, long seqNo, boolean found) {
            super(Operation.TYPE.DELETE, failure, version, term, seqNo);
            this.found = found;
        }

        public DeleteResult(Mapping requiredMappingUpdate) {
            super(Operation.TYPE.DELETE, requiredMappingUpdate);
            this.found = false;
        }

        public boolean isFound() {
            return this.found;
        }
    }

    public static class IndexResult
    extends Result {
        private final boolean created;

        public IndexResult(long version, long term, long seqNo, boolean created) {
            super(Operation.TYPE.INDEX, version, term, seqNo);
            this.created = created;
        }

        public IndexResult(Exception failure, long version, long term) {
            this(failure, version, term, -2L);
        }

        public IndexResult(Exception failure, long version, long term, long seqNo) {
            super(Operation.TYPE.INDEX, failure, version, term, seqNo);
            this.created = false;
        }

        public IndexResult(Mapping requiredMappingUpdate) {
            super(Operation.TYPE.INDEX, requiredMappingUpdate);
            this.created = false;
        }

        public boolean isCreated() {
            return this.created;
        }
    }

    public static abstract class Result {
        private final Operation.TYPE operationType;
        private final Type resultType;
        private final long version;
        private final long term;
        private final long seqNo;
        private final Exception failure;
        private final SetOnce<Boolean> freeze = new SetOnce();
        private final Mapping requiredMappingUpdate;
        private Translog.Location translogLocation;
        private long took;

        protected Result(Operation.TYPE operationType, Exception failure, long version, long term, long seqNo) {
            this.operationType = operationType;
            this.failure = Objects.requireNonNull(failure);
            this.version = version;
            this.term = term;
            this.seqNo = seqNo;
            this.requiredMappingUpdate = null;
            this.resultType = Type.FAILURE;
        }

        protected Result(Operation.TYPE operationType, long version, long term, long seqNo) {
            this.operationType = operationType;
            this.version = version;
            this.seqNo = seqNo;
            this.term = term;
            this.failure = null;
            this.requiredMappingUpdate = null;
            this.resultType = Type.SUCCESS;
        }

        protected Result(Operation.TYPE operationType, Mapping requiredMappingUpdate) {
            this.operationType = operationType;
            this.version = -1L;
            this.seqNo = -2L;
            this.term = 0L;
            this.failure = null;
            this.requiredMappingUpdate = requiredMappingUpdate;
            this.resultType = Type.MAPPING_UPDATE_REQUIRED;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public long getVersion() {
            return this.version;
        }

        public long getSeqNo() {
            return this.seqNo;
        }

        public long getTerm() {
            return this.term;
        }

        public Mapping getRequiredMappingUpdate() {
            return this.requiredMappingUpdate;
        }

        public Translog.Location getTranslogLocation() {
            return this.translogLocation;
        }

        public Exception getFailure() {
            return this.failure;
        }

        public long getTook() {
            return this.took;
        }

        public Operation.TYPE getOperationType() {
            return this.operationType;
        }

        void setTranslogLocation(Translog.Location translogLocation) {
            if (this.freeze.get() != null) {
                throw new IllegalStateException("result is already frozen");
            }
            this.translogLocation = translogLocation;
        }

        void setTook(long took) {
            if (this.freeze.get() != null) {
                throw new IllegalStateException("result is already frozen");
            }
            this.took = took;
        }

        void freeze() {
            this.freeze.set((Object)true);
        }

        public static enum Type {
            SUCCESS,
            FAILURE,
            MAPPING_UPDATE_REQUIRED;

        }
    }

    protected static final class NoOpLock
    implements Lock {
        protected NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("NoOpLock can't provide a condition");
        }
    }

    protected static final class IndexThrottle {
        private final CounterMetric throttleTimeMillisMetric = new CounterMetric();
        private volatile long startOfThrottleNS;
        private static final ReleasableLock NOOP_LOCK = new ReleasableLock(new NoOpLock());
        private final ReleasableLock lockReference = new ReleasableLock(new ReentrantLock());
        private volatile ReleasableLock lock = NOOP_LOCK;

        protected IndexThrottle() {
        }

        public Releasable acquireThrottle() {
            return this.lock.acquire();
        }

        public void activate() {
            assert (this.lock == NOOP_LOCK) : "throttling activated while already active";
            this.startOfThrottleNS = System.nanoTime();
            this.lock = this.lockReference;
        }

        public void deactivate() {
            assert (this.lock != NOOP_LOCK) : "throttling deactivated but not active";
            this.lock = NOOP_LOCK;
            assert (this.startOfThrottleNS > 0L) : "Bad state of startOfThrottleNS";
            long throttleTimeNS = System.nanoTime() - this.startOfThrottleNS;
            if (throttleTimeNS >= 0L) {
                this.throttleTimeMillisMetric.inc(TimeValue.nsecToMSec((long)throttleTimeNS));
            }
        }

        long getThrottleTimeInMillis() {
            long currentThrottleNS = 0L;
            if (this.isThrottled() && this.startOfThrottleNS != 0L && (currentThrottleNS += System.nanoTime() - this.startOfThrottleNS) < 0L) {
                currentThrottleNS = 0L;
            }
            return this.throttleTimeMillisMetric.count() + TimeValue.nsecToMSec((long)currentThrottleNS);
        }

        boolean isThrottled() {
            return this.lock != NOOP_LOCK;
        }
    }
}

