/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.text.ParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.shard.ShardId;

class ShardUpgradeResult
implements Streamable {
    private ShardId shardId;
    private org.apache.lucene.util.Version oldestLuceneSegment;
    private Version upgradeVersion;
    private boolean primary;

    ShardUpgradeResult() {
    }

    ShardUpgradeResult(ShardId shardId, boolean primary, Version upgradeVersion, org.apache.lucene.util.Version oldestLuceneSegment) {
        this.shardId = shardId;
        this.primary = primary;
        this.upgradeVersion = upgradeVersion;
        this.oldestLuceneSegment = oldestLuceneSegment;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public org.apache.lucene.util.Version oldestLuceneSegment() {
        return this.oldestLuceneSegment;
    }

    public Version upgradeVersion() {
        return this.upgradeVersion;
    }

    public boolean primary() {
        return this.primary;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = ShardId.readShardId(in);
        this.primary = in.readBoolean();
        this.upgradeVersion = Version.readVersion(in);
        try {
            this.oldestLuceneSegment = org.apache.lucene.util.Version.parse(in.readString());
        }
        catch (ParseException ex) {
            throw new IOException("failed to parse lucene version [" + this.oldestLuceneSegment + "]", ex);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeBoolean(this.primary);
        Version.writeVersion(this.upgradeVersion, out);
        out.writeString(this.oldestLuceneSegment.toString());
    }
}

