/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.ValUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class SimilarNamedWays
extends Test {
    protected static final int SIMILAR_NAMED = 701;
    private Map<Point2D, List<Way>> cellWays;
    private MultiMap<Way, Way> errorWays;
    private final List<NormalizeRule> rules = new ArrayList<NormalizeRule>();

    public SimilarNamedWays() {
        super(I18n.tr("Similarly named ways", new Object[0]), I18n.tr("This test checks for ways with similar names that may have been misspelled.", new Object[0]));
        this.addRegExprRule("\\pN+", "0");
        this.addRegExprRule("M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$", "0");
        this.addRegExprRule("\\d+(st|nd|rd|th)", "0st");
        this.addRegExprRule("^[A-Z] ", "X");
        this.addSynonyms("east", "west", "north", "south");
        this.addSynonyms("first", "second", "third");
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.cellWays = new HashMap<Point2D, List<Way>>(1000);
        this.errorWays = new MultiMap();
    }

    @Override
    public void endTest() {
        this.cellWays = null;
        this.errorWays = null;
        super.endTest();
    }

    @Override
    public void visit(Way w) {
        if (!w.isUsable()) {
            return;
        }
        String name = w.get("name");
        if (name == null || name.length() < 6) {
            return;
        }
        List<List<Way>> theCellWays = ValUtil.getWaysInCell(w, this.cellWays);
        for (List<Way> ways : theCellWays) {
            for (Way w2 : ways) {
                String name2;
                if (this.errorWays.contains(w, w2) || this.errorWays.contains(w2, w) || (name2 = w2.get("name")) == null || name2.length() < 6 || !this.similaryName(name, name2)) continue;
                ArrayList<Way> primitives = new ArrayList<Way>(2);
                primitives.add(w);
                primitives.add(w2);
                this.errors.add(TestError.builder(this, Severity.WARNING, 701).message(I18n.tr("Similarly named ways", new Object[0])).primitives(primitives).build());
                this.errorWays.put(w, w2);
            }
            ways.add(w);
        }
    }

    public static int getLevenshteinDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char si = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char tj = t.charAt(j - 1);
                int cost = si == tj ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public void addRegExprRule(String regExpr, String replacement) {
        this.rules.add(new RegExprRule(regExpr, replacement));
    }

    public void addSynonyms(String ... words) {
        for (String word : words) {
            this.rules.add(new SynonymRule(word, words));
        }
    }

    public boolean similaryName(String name, String name2) {
        boolean similar;
        int distance = SimilarNamedWays.getLevenshteinDistance(name, name2);
        boolean bl = similar = distance > 0 && distance <= 2;
        if (distance > 2 && name.length() == name2.length()) {
            similar = Utils.deAccent(name).equalsIgnoreCase(Utils.deAccent(name2));
        }
        for (NormalizeRule rule : this.rules) {
            int levenshteinDistance = SimilarNamedWays.getLevenshteinDistance(rule.normalize(name), rule.normalize(name2));
            if (levenshteinDistance == 0) {
                return false;
            }
            if (levenshteinDistance > 2) continue;
            similar = true;
        }
        return similar;
    }

    public static class SynonymRule
    implements NormalizeRule {
        private final String[] words;
        private final Pattern regExpr;
        private final String replacement;

        public SynonymRule(String replacement, String ... words) {
            this.replacement = replacement.toLowerCase(Locale.ENGLISH);
            this.words = words;
            StringBuilder expression = new StringBuilder();
            int maxLength = 0;
            for (int i = 0; i < words.length; ++i) {
                if (words[i].length() > maxLength) {
                    maxLength = words[i].length();
                }
                if (expression.length() > 0) {
                    expression.append('|');
                }
                expression.append(Pattern.quote(words[i]));
            }
            this.regExpr = Pattern.compile(expression.toString(), 66);
        }

        @Override
        public String normalize(String name) {
            String word;
            Matcher matcher = this.regExpr.matcher(name);
            if (!matcher.find()) {
                return name;
            }
            int start = matcher.start();
            String part = "";
            for (int i = 0; i < this.words.length && !(word = this.words[i]).equalsIgnoreCase(part = name.substring(start, start + word.length())); ++i) {
            }
            char[] newName = matcher.replaceFirst(this.replacement).toCharArray();
            int minLength = Math.min(this.replacement.length(), part.length());
            for (int i = 0; i < minLength; ++i) {
                if (!Character.isUpperCase(part.charAt(i))) continue;
                newName[start + i] = Character.toUpperCase(newName[start + i]);
            }
            return new String(newName);
        }

        public String toString() {
            return "synonyms(" + this.replacement + ", " + Arrays.toString(this.words) + ')';
        }
    }

    public static class RegExprRule
    implements NormalizeRule {
        private final Pattern regExpr;
        private final String replacement;

        public RegExprRule(String expression, String replacement) {
            this.regExpr = Pattern.compile(expression);
            this.replacement = replacement;
        }

        @Override
        public String normalize(String name) {
            return this.regExpr.matcher(name).replaceAll(this.replacement);
        }

        public String toString() {
            return "replaceAll(" + this.regExpr + ", " + this.replacement + ')';
        }
    }

    @FunctionalInterface
    public static interface NormalizeRule {
        public String normalize(String var1);
    }
}

