/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.specialized;

import java.util.Set;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.JDKVersion;
import me.qmx.jitescript.JiteClass;
import org.jruby.ReifiedRubyObject;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.CodegenUtils;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.collections.NonBlockingHashMapLong;

public class RubyObjectSpecializer {
    private static final NonBlockingHashMapLong<ObjectAllocator> specializedFactories = new NonBlockingHashMapLong();
    private static ClassDefiningClassLoader CDCL = new OneShotClassLoader(Ruby.getClassLoader());

    private static ObjectAllocator getClassFromSize(int size2) {
        return specializedFactories.get(size2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectAllocator specializeForVariables(RubyClass klass, Set<String> foundVariables) {
        Class p2;
        int size2 = foundVariables.size();
        ObjectAllocator allocator = RubyObjectSpecializer.getClassFromSize(size2);
        if (allocator != null) {
            return allocator;
        }
        String clsPath = "org/jruby/gen/RubyObject" + size2;
        String clsName = clsPath.replaceAll("/", ".");
        try {
            p2 = CDCL.loadClass(clsName);
        }
        catch (ClassNotFoundException cnfe) {
            ClassDefiningClassLoader classDefiningClassLoader = CDCL;
            synchronized (classDefiningClassLoader) {
                try {
                    p2 = CDCL.loadClass(clsName);
                }
                catch (ClassNotFoundException cnfe2) {
                    p2 = RubyObjectSpecializer.generateInternal(klass, foundVariables, clsPath, clsName);
                }
            }
        }
        try {
            Class<?> allocatorCls = p2.getDeclaredClasses()[0];
            allocator = (ObjectAllocator)allocatorCls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        klass.setAllocator(allocator);
        klass.setReifiedClass(p2);
        return allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class generateInternal(RubyClass klass, Set<String> names2, final String clsPath, String clsName) {
        ClassDefiningClassLoader classDefiningClassLoader = CDCL;
        synchronized (classDefiningClassLoader) {
            int i2 = 0;
            for (String name2 : names2) {
                klass.getVariableTableManager().getVariableAccessorForVar(name2, i2);
                ++i2;
            }
            final int count2 = Math.min(i2, ReifiedRubyObject.REIFIED_MAX);
            final String[] newFields = RubyObjectSpecializer.varList(count2);
            final String baseName = CodegenUtils.p(ReifiedRubyObject.class);
            final String allocatorPath = clsPath + "Allocator";
            JiteClass jiteClass = new JiteClass(clsPath, baseName, new String[0]){
                {
                    int offset2;
                    super(x0, x1, x2);
                    this.defineMethod("<init>", 1, CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), new CodeBlock(){
                        {
                            this.aload(0);
                            this.aload(1);
                            this.aload(2);
                            this.invokespecial(baseName, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
                            this.voidreturn();
                        }
                    });
                    this.defineMethod("getVariable", 1, CodegenUtils.sig(Object.class, Integer.TYPE), new CodeBlock(){
                        {
                            LabelNode parentCall = new LabelNode(new Label());
                            this.line(0);
                            if (count2 > 0) {
                                RubyObjectSpecializer.genGetSwitch(clsPath, newFields, this, 1);
                            }
                            this.line(1);
                            this.aload(0);
                            this.iload(1);
                            this.invokespecial(CodegenUtils.p(ReifiedRubyObject.class), "getVariable", CodegenUtils.sig(Object.class, Integer.TYPE));
                            this.areturn();
                        }
                    });
                    this.defineMethod("setVariable", 1, CodegenUtils.sig(Void.TYPE, Integer.TYPE, Object.class), new CodeBlock(){
                        {
                            LabelNode parentCall = new LabelNode(new Label());
                            this.line(2);
                            if (count2 > 0) {
                                RubyObjectSpecializer.genPutSwitch(clsPath, newFields, this, 1);
                            }
                            this.line(3);
                            this.aload(0);
                            this.iload(1);
                            this.aload(2);
                            this.invokespecial(CodegenUtils.p(ReifiedRubyObject.class), "setVariable", CodegenUtils.sig(Void.TYPE, Integer.TYPE, Object.class));
                            this.voidreturn();
                        }
                    });
                    int i2 = 0;
                    while (i2 < count2) {
                        offset2 = i2++;
                        this.defineMethod("getVariable" + offset2, 1, CodegenUtils.sig(Object.class, new Class[0]), new CodeBlock(){
                            {
                                this.line(4);
                                this.aload(0);
                                this.getfield(clsPath, newFields[offset2], CodegenUtils.ci(Object.class));
                                this.areturn();
                            }
                        });
                    }
                    i2 = 0;
                    while (i2 < count2) {
                        offset2 = i2++;
                        this.defineMethod("setVariable" + offset2, 1, CodegenUtils.sig(Void.TYPE, Object.class), new CodeBlock(){
                            {
                                this.line(5);
                                this.aload(0);
                                this.aload(1);
                                this.putfield(clsPath, newFields[offset2], CodegenUtils.ci(Object.class));
                                this.voidreturn();
                            }
                        });
                    }
                    for (String prop : newFields) {
                        this.defineField(prop, 1, CodegenUtils.ci(Object.class), null);
                    }
                    this.addChildClass(new JiteClass(allocatorPath, CodegenUtils.p(Object.class), Helpers.arrayOf(CodegenUtils.p(ObjectAllocator.class))){
                        {
                            super(x0, x1, x2);
                            this.defineDefaultConstructor();
                            this.defineMethod("allocate", 1, CodegenUtils.sig(IRubyObject.class, Ruby.class, RubyClass.class), new CodeBlock(){
                                {
                                    this.newobj(clsPath);
                                    this.dup();
                                    this.aload(1);
                                    this.aload(2);
                                    this.invokespecial(clsPath, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
                                    this.areturn();
                                }
                            });
                        }
                    });
                }
            };
            Class specializedClass = RubyObjectSpecializer.defineClass(jiteClass);
            RubyObjectSpecializer.defineClass(jiteClass.getChildClasses().get(0));
            return specializedClass;
        }
    }

    private static String[] varList(int size2) {
        String[] vars = new String[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            vars[i2] = "var" + i2;
        }
        return vars;
    }

    private static void genGetSwitch(String clsPath, String[] newFields, CodeBlock block, int offsetVar) {
        int i2;
        LabelNode defaultError = new LabelNode(new Label());
        int size2 = newFields.length;
        LabelNode[] cases = new LabelNode[size2];
        for (i2 = 0; i2 < size2; ++i2) {
            cases[i2] = new LabelNode(new Label());
        }
        block.iload(offsetVar);
        block.tableswitch(0, size2 - 1, defaultError, cases);
        for (i2 = 0; i2 < size2; ++i2) {
            block.label(cases[i2]);
            block.aload(0);
            block.getfield(clsPath, newFields[i2], CodegenUtils.ci(Object.class));
            block.areturn();
        }
        block.label(defaultError);
    }

    private static void genPutSwitch(String clsPath, String[] newFields, CodeBlock block, int offsetVar) {
        int i2;
        LabelNode defaultError = new LabelNode(new Label());
        int size2 = newFields.length;
        LabelNode[] cases = new LabelNode[size2];
        for (i2 = 0; i2 < size2; ++i2) {
            cases[i2] = new LabelNode(new Label());
        }
        block.iload(offsetVar);
        block.tableswitch(0, size2 - 1, defaultError, cases);
        for (i2 = 0; i2 < size2; ++i2) {
            block.label(cases[i2]);
            block.aload(0);
            block.aload(2);
            block.putfield(clsPath, newFields[i2], CodegenUtils.ci(Object.class));
            block.voidreturn();
        }
        block.label(defaultError);
    }

    private static Class defineClass(JiteClass jiteClass) {
        return CDCL.defineClass(RubyObjectSpecializer.classNameFromJiteClass(jiteClass), jiteClass.toBytes(JDKVersion.V1_7));
    }

    private static String classNameFromJiteClass(JiteClass jiteClass) {
        return jiteClass.getClassName().replaceAll("/", ".");
    }
}

