/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.OfficeReader;
import writer2latex.util.Misc;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;

abstract class IndexConverterHelper
extends ConverterHelper {
    private String sEpubType;
    private String sSourceName;

    IndexConverterHelper(OfficeReader ofr, XhtmlConfig config, Converter converter, String sSourceName, String sEpubType) {
        super(ofr, config, converter);
        this.sSourceName = sSourceName;
        this.sEpubType = sEpubType;
    }

    abstract void populateIndex(Element var1, Element var2);

    void handleIndex(Element onode, Element hnode) {
        Element source = Misc.getChildByTagName(onode, this.sSourceName);
        if (source != null) {
            Element container = this.createContainer(onode, hnode);
            this.generateTitle(source, container);
            this.generateIndex(source, container);
        }
    }

    private Element createContainer(Element source, Element hnode) {
        String sStyleName;
        Element container = this.converter.createElement(this.converter.isHTML5() ? "section" : "div");
        hnode.appendChild(container);
        this.converter.addEpubType(container, this.sEpubType);
        String sName = source.getAttribute("text:name");
        if (sName != null) {
            this.converter.addTarget(container, sName);
        }
        if ((sStyleName = source.getAttribute("text:style-name")) != null) {
            StyleInfo sectionInfo = new StyleInfo();
            this.getSectionSc().applyStyle(sStyleName, sectionInfo);
            this.applyStyle(sectionInfo, container);
        }
        return container;
    }

    private void generateTitle(Element source, Element container) {
        Element title = Misc.getChildByTagName(source, "text:index-title-template");
        if (title != null) {
            Element h1 = this.converter.createElement("h1");
            container.appendChild(h1);
            String sStyleName = Misc.getAttribute((Node)title, "text:style-name");
            StyleInfo info = new StyleInfo();
            info.sTagName = "h1";
            this.getHeadingSc().applyStyle(1, sStyleName, info);
            this.applyStyle(info, h1);
            this.getTextCv().traversePCDATA(title, h1);
        }
    }

    private void generateIndex(Element source, Element container) {
        Element ul = this.converter.createElement("ul");
        ul.setAttribute("style", "list-style-type:none;margin:0;padding:0");
        container.appendChild(ul);
        this.populateIndex(source, ul);
    }
}

