import Entrypoint from './features/entrypoint';
declare class TransactionConfig {
    tracing: boolean;
    http: boolean;
}
declare class MetricsConfig {
    transaction: TransactionConfig;
    network: Object;
    v8: boolean;
    deepMetrics: boolean;
}
declare class ActionsConfig {
    profilingCpu: boolean;
    profilingHeap: boolean;
    eventLoopDump: boolean;
}
declare class IOConfig {
    level?: string;
    catchExceptions?: boolean;
    metrics: MetricsConfig;
    actions: ActionsConfig;
    network: boolean;
    ports: boolean;
    v8: boolean;
    transactions: boolean;
    http: boolean;
    deep_metrics: boolean;
    event_loop_dump: boolean;
    profiling: boolean;
}
interface Context {
    level?: string;
}
interface ActionOpts {
    name: string;
    opts: Object;
    action: Function;
}
export default class PMX {
    private notifyFeature;
    private metricsFeature;
    private actionsFeature;
    private eventsFeature;
    Entrypoint: Entrypoint;
    private initialConfig;
    constructor();
    getInitialConfig(): IOConfig;
    init(config?: IOConfig, force?: boolean): this;
    destroy(): void;
    notifyError(err: Error, context?: Context): void;
    metrics(metrics: Object | Array<Object>): Object;
    histogram(config: Object): void | import("./utils/metrics/histogram").default;
    metric(config: Object): any;
    counter(config: Object): import("./utils/metrics/counter").default | undefined;
    meter(config: Object): import("./utils/metrics/meter").default | undefined;
    action(name: string | ActionOpts, opts?: Object, fn?: Function): void;
    scopedAction(name: string, fn: Function): void;
    transpose(variableName: string, reporter: Function): void;
    onExit(callback: Function): any;
    probe(): {
        histogram: (histogram: any) => any;
        meter: (meter: any) => any;
        metric: (metric: any) => any;
        counter: (counter: any) => any;
        transpose: (variableName: any, reporter: any) => void;
    };
    emit(name: string, data: any): void;
    emitEvent(name: string, data: any): void;
    notify(notification: Error | any): void;
    getPID(file: string): number;
    initModule(opts: any, cb: Function): any;
    expressErrorHandler(): (err: any, req: any, res: any, next: any) => any;
    private genericBackwardConversion;
    private backwardConfigConversion;
    private initMetricsConf;
    private initActionsConf;
}
export {};
