# encoding: UTF-8

class WpPlugins < WpItems
  module Detectable
    # @return [ String ]
    def vulns_file
      PLUGINS_FILE
    end

    # @param [ WpTarget ] wp_target
    # @param [ Hash ] options
    #
    # @return [ WpPlugins ]
    def passive_detection(wp_target, options = {})
      detected = super(wp_target, options)

      detected += from_header(wp_target)
      detected += from_content(wp_target)

      detected.uniq! { |i| i.name }
      detected
    end

    protected

    # X-Powered-By: W3 Total Cache/0.9.2.5
    # WP-Super-Cache: Served supercache file from PHP
    # @param [ WpTarget ] wp_target
    #
    # @return [ WpPlugins ]
    def from_header(wp_target)
      headers    = Browser.get(wp_target.url).headers
      wp_plugins = WpPlugins.new(wp_target)

      if headers
        powered_by     = headers['X-Powered-By'].to_s
        wp_super_cache = headers['wp-super-cache'].to_s

        if matches = /W3 Total Cache\/([0-9.]+)/i.match(powered_by)
          wp_plugins.add('w3-total-cache', version: matches[1])
        end

        wp_plugins.add('wp-super-cache') if wp_super_cache =~ /supercache/i
      end

      wp_plugins
    end

    # <!-- Cached page generated by WP-Super-Cache on 2013-05-03 14:46:37 -->
    # <!-- Performance optimized by W3 Total Cache.
    # @param [ WpTarget ] wp_target
    #
    # @return [ WpPlugins ]
    def from_content(wp_target)
      body       = Browser.get(wp_target.url).body
      wp_plugins = WpPlugins.new(wp_target)

      wp_plugins.add('wp-super-cache') if body =~ /wp-super-cache/i
      wp_plugins.add('w3-total-cache') if body =~ /w3 total cache/i

      if body =~ /<!-- all in one seo pack ([^\s]+)/i
        wp_plugins.add('all-in-one-seo-pack', version: $1)
      end

      if body =~ /<!-- This site is optimized with the Yoast (?:WordPress )?SEO plugin v([^\s]+) -/i
        wp_plugins.add('wordpress-seo', version: $1)
      end

      if body =~ /<!-- Google Universal Analytics for WordPress v([^\s]+) -/i
        wp_plugins.add('google-universal-analytics', version: $1)
      end

      wp_plugins
    end

  end
end
