/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CG = "Kongo";
        final String metaValue_FJ = "Fi\u0121i";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "G\u0127arbi";
        final String metaValue_el = "Grieg";
        final String metaValue_la = "Latin";
        final String metaValue_peo = "Persjan Antik";
        final String metaValue_Hant = "Tradizzjonali";
        final Object[][] data = new Object[][] {
            { "lui", "Luwisinu\u017c" },
            { "nyn", "Nyankole" },
            { "mwl", "Mirandi\u017c" },
            { "nym", "Njamwe\u017ci" },
            { "lun", "Lunda" },
            { "nyo", "Njoro" },
            { "luo", "Luwa" },
            { "fil", "Filippino" },
            { "hmn", "\u0126mong" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "del", "Delawerjan" },
            { "lus", "Luxaj" },
            { "bal", "Balu\u010bi" },
            { "den", "Slav" },
            { "ban", "Balini\u017c" },
            { "uga", "Ugaritiku" },
            { "bas", "Basa" },
            { "egy", "E\u0121izzjan (Antik)" },
            { "raj", "Ra\u0121astani" },
            { "jrb", "Lhudi-G\u0127arbi" },
            { "nzi", "N\u017cima" },
            { "tem", "Timne" },
            { "sco", "Sko\u010b\u010bi\u017c" },
            { "aa", "Afar" },
            { "rap", "Rapanwi" },
            { "ter", "Tereno" },
            { "ab", "Abka\u017cjan" },
            { "rar", "Rarotongani" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "Emirati G\u0127arab Maqg\u0127uda" },
            { "ae", "Avestan" },
            { "AF", "Afganistan" },
            { "af", "Afrikans" },
            { "AG", "Antigua and Barbuda" },
            { "type.ca.ethiopic", "Kalendarju Etjopiku" },
            { "AI", "Angwilla" },
            { "ak", "Akan" },
            { "AL", "Albanija" },
            { "AM", "Armenja" },
            { "am", "Am\u0127ariku" },
            { "Arab", metaValue_ar },
            { "an", "Aragonese" },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "ar", metaValue_ar },
            { "AR", "Ar\u0121entina" },
            { "AS", "Samoa Amerikana" },
            { "as", "Assamese" },
            { "AT", "Awstrija" },
            { "AU", "Awstralja" },
            { "av", "Avarik" },
            { "AW", "Aruba" },
            { "en_US", "Ingli\u017c Amerikan" },
            { "AX", "G\u017cejjer Aland" },
            { "ay", "Ajmara" },
            { "AZ", "A\u017cerbaj\u0121an" },
            { "az", "A\u017cerbaj\u0121ani" },
            { "BA", "Bo\u017cnija \u0126er\u017cegovina" },
            { "ba", "Baxkir" },
            { "BB", "Barbados" },
            { "ceb", "Sibwano" },
            { "BD", "Bangladexx" },
            { "kum", "Kumiku" },
            { "BE", "Bel\u0121ju" },
            { "be", "Belarussu" },
            { "gmh", "\u0120ermaniku, Medjevali Pulit" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarija" },
            { "bg", "Bulgaru" },
            { "BH", "Ba\u0127rajn" },
            { "BI", "Burundi" },
            { "bi", "Bislama" },
            { "BJ", "Benin" },
            { "BM", "Bermuda" },
            { "bm", "Bambara" },
            { "kut", "Kutenaj" },
            { "myv", "Erzya" },
            { "BN", "Brunej" },
            { "bn", "Bengali" },
            { "BO", "Bolivja" },
            { "bo", "Tibetjan" },
            { "dgr", "Dogrib" },
            { "BR", "Il-Bra\u017cil" },
            { "br", "Brenton" },
            { "BS", "Ba\u0127amas" },
            { "bs", "Bosnijan" },
            { "BT", "Butan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Bjelorussja" },
            { "BZ", "Beli\u017ce" },
            { "sel", "Selkup" },
            { "CA", "Kanada" },
            { "ca", "Katalan" },
            { "CC", "Cocos (Keeling) Islands" },
            { "CD", "Democratic Republic of the Congo" },
            { "ce", "\u010ae\u010ben" },
            { "CF", "Repubblika Afrikana \u010aentrali" },
            { "CG", metaValue_CG },
            { "CH", "Svizzera" },
            { "ch", "\u010aamorro" },
            { "CI", "Kosta ta\u2019 l-Avorju" },
            { "%%REVISED", "Ortografija Irriveda" },
            { "CK", "Cook Islands" },
            { "CL", "\u010aili" },
            { "CM", "Kamerun" },
            { "CN", "I\u010b-\u010aina" },
            { "CO", "Kolombja" },
            { "co", "Korsiku" },
            { "CR", "Kosta Rika" },
            { "cr", "Krij" },
            { "cs", "\u010aek" },
            { "CU", "Kuba" },
            { "cu", "Slaviku tal-Knisja" },
            { "CV", "Kape Verde" },
            { "cv", "\u010auvax" },
            { "CX", "Christmas Island" },
            { "CY", "\u010aipru" },
            { "cy", "Welx" },
            { "CZ", "Repubblika \u010aeka" },
            { "eka", "Ekajuk" },
            { "da", "Dani\u017c" },
            { "DE", "Il-\u0120ermanja" },
            { "de", "\u0120ermani\u017c" },
            { "goh", "\u0120ermaniku, Antik Pulit" },
            { "ace", "A\u010bini\u017c" },
            { "DJ", "\u0120ibuti" },
            { "bej", "Beja" },
            { "DK", "Danimarka" },
            { "ach", "Akoli" },
            { "gon", "Gondi" },
            { "din", "Dinka" },
            { "DM", "Dominika" },
            { "DO", "Republikka Domenikana" },
            { "bem", "Bemba" },
            { "gor", "Gorontalo" },
            { "sga", "Irlandi\u017c, Antik" },
            { "got", "Gotiku" },
            { "dv", "Dive\u0127i" },
            { "zun", "\u017buni" },
            { "tig", "Tigre" },
            { "DZ", "Al\u0121erija" },
            { "dz", "D\u017congka" },
            { "pag", "Pangasinjan" },
            { "type.ca.chinese", "Kalendarju \u010aini\u017c" },
            { "pal", "Pa\u0127lavi" },
            { "chb", "\u010aib\u010ba" },
            { "pam", "Pampamga" },
            { "EC", "Ekwador" },
            { "pap", "Papjamento" },
            { "ada", "Adangme" },
            { "EE", "Estonja" },
            { "ee", "Ewe" },
            { "tiv", "Tiv" },
            { "EG", "E\u0121ittu" },
            { "EH", "Sahara tal-Punent" },
            { "chg", "\u010aagataj" },
            { "ro_MD", "Moldavjan" },
            { "pau", "Palawjan" },
            { "el", metaValue_el },
            { "chk", "\u010aukese" },
            { "chn", "\u0120argon ta\u010b-\u010ainuk" },
            { "en", "Ingli\u017c" },
            { "chm", "Mari" },
            { "eo", "Esperanto" },
            { "chp", "\u010aipewjan" },
            { "cho", "\u010aostaw" },
            { "chr", "\u010aerokij" },
            { "ER", "Eritrea" },
            { "type.co.big5han", "Ordni \u010aini\u017c Tradizzjonali (Big5)" },
            { "ES", "Spanja" },
            { "es", "Spanjol" },
            { "ET", "Etijopja" },
            { "et", "Estonjan" },
            { "EU", "Unjoni Ewropea" },
            { "eu", "Bask" },
            { "elx", "Elamit" },
            { "type.ca.gregorian", "Kalendarju Gregorjan" },
            { "chy", "Xajenn" },
            { "hsb", "Upper Sorbian" },
            { "ady", "Adyghe" },
            { "shn", "Xan" },
            { "fa", "Persjan" },
            { "Hans", "Simplifikat" },
            { "type.nu.latn", "Numri tal-Punent" },
            { "Hant", metaValue_Hant },
            { "ff", "Fula\u0127" },
            { "FI", "Finlandja" },
            { "fi", "Finlandi\u017c" },
            { "fj", metaValue_FJ },
            { "FJ", metaValue_FJ },
            { "fon", "Fon" },
            { "FK", "Falkland Islands" },
            { "FM", "Mikronesja" },
            { "FO", "G\u017cejjer Faroe" },
            { "fo", "Fawri\u017c" },
            { "umb", "Umbundu" },
            { "FR", "Franza" },
            { "fr", "Fran\u010bi\u017c" },
            { "sid", "Sidamo" },
            { "fy", "Fri\u017cjan" },
            { "tkl", "Tokelau" },
            { "grb", "\u0120erbo" },
            { "root", "G\u0127erq" },
            { "grc", "Grieg, Antik" },
            { "GA", "Gabon" },
            { "ga", "Irlandi\u017c" },
            { "vot", "Votik" },
            { "GB", "L-Ingilterra" },
            { "GD", "Grenada" },
            { "gd", "Galliku Sko\u010b\u010bi\u017c" },
            { "GE", "\u0120eor\u0121ja" },
            { "GF", "Gujana Fran\u010bi\u017ca" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "afh", "Afri\u0127ili" },
            { "GL", "Grinlandja" },
            { "gl", "Gallegjan" },
            { "enm", "Ingli\u017c, Medjevali" },
            { "GM", "Gambja" },
            { "GN", "Ginea" },
            { "gn", "Gwarani" },
            { "bho", "Bojpuri" },
            { "GP", "Gwadelupe" },
            { "GQ", "Ginea Ekwatorjali" },
            { "und", "Lingwa Mhux Mag\u0127rufa" },
            { "GR", "Gre\u010bja" },
            { "GS", "South Georgia and the South Sandwich Islands" },
            { "GT", "Gwatemala" },
            { "GU", "Gwam" },
            { "gu", "Gu\u0121arati" },
            { "gv", "Manks" },
            { "GW", "Ginea-Bissaw" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "GY", "Gujana" },
            { "ha", "\u0126awsa" },
            { "he", "Ebrajk" },
            { "hi", "\u0126indi" },
            { "hup", "\u0126upa" },
            { "HK", "\u0126ong Kong S.A.R. \u010aina" },
            { "HM", "Heard Island and McDonald Islands" },
            { "bik", "Bikol" },
            { "HN", "\u0126onduras" },
            { "bin", "Bini" },
            { "ho", "\u0126iri Motu" },
            { "HR", "Kroazja" },
            { "hr", "Kroat" },
            { "HT", "\u0126aiti" },
            { "ht", "Haitian" },
            { "HU", "Ungerija" },
            { "hu", "Ungeri\u017c" },
            { "tmh", "Tamaxek" },
            { "hy", "Armenjan" },
            { "hz", "\u0126erero" },
            { "ia", "Interlingua" },
            { "peo", metaValue_peo },
            { "ID", "Indone\u017cja" },
            { "id", "Indone\u017cjan" },
            { "IE", "Irlanda" },
            { "ie", "Interlingue" },
            { "nap", "Neapolitan" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "frm", "Fran\u010bi\u017c, Medjevali" },
            { "ik", "Inupjak" },
            { "fro", "Fran\u010bi\u017c, Antik" },
            { "IL", "I\u017crael" },
            { "IM", "Isle of Man" },
            { "IN", "L-Indja" },
            { "IO", "British Indian Ocean Territory" },
            { "io", "Ido" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "is", "I\u017clandi\u017c" },
            { "IT", "L-Italja" },
            { "it", "Taljan" },
            { "iu", "Inukitut" },
            { "ja", "\u0120appuni\u017c" },
            { "type.ca.islamic", "Kalendarju I\u017clamiku" },
            { "doi", "Dogri" },
            { "JM", "\u0120amajka" },
            { "JO", "\u0120ordan" },
            { "JP", "Il-\u0120appun" },
            { "sma", "Southern Sami" },
            { "ain", "Ajnu" },
            { "jv", "\u0120avani\u017c" },
            { "tog", "Tonga (Njasa)" },
            { "mad", "Maduri\u017c" },
            { "smj", "Lule Sami" },
            { "mag", "Maga\u0127i" },
            { "mai", "Majtili" },
            { "smn", "Inari Sami" },
            { "ka", "\u0120or\u0121jan" },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "type.ca.buddhist", "Kalendarju Buddist" },
            { "sms", "Skolt Sami" },
            { "KE", "Kenja" },
            { "man", "Mandingwan" },
            { "kg", metaValue_CG },
            { "419", "Amerika Latina" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "ki", "Kikuju" },
            { "mas", "Masaj" },
            { "kj", "Kuanyama" },
            { "kk", "Ka\u017cak" },
            { "kl", "Kalallisut" },
            { "KM", "Komoros" },
            { "km", "Kmer" },
            { "KN", "Saint Kitts and Nevis" },
            { "kn", "Kannada" },
            { "fr_CA", "Fran\u010bi\u017c Kanadi\u017c" },
            { "ko", "Korejan" },
            { "KP", "Koreja ta\u2019 Fuq" },
            { "KR", "Koreja t\u2019Isfel" },
            { "kr", "Kanuri" },
            { "ks", "Kaxmiri" },
            { "ku", "Kurdi\u017c" },
            { "fr_CH", "Fran\u010bi\u017c \u017bvizzeru" },
            { "kv", "Komi" },
            { "KW", "Kuwajt" },
            { "kw", "Korniku" },
            { "tpi", "Tok Pisin" },
            { "KY", "G\u017cejjer Kajmani" },
            { "ky", "Kirgi\u017c" },
            { "KZ", "Ka\u017cakstan" },
            { "Cyrl", "\u010airilliku" },
            { "snk", "Soninke" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Libanu" },
            { "lb", "Let\u017cburgi\u017c" },
            { "LC", "Santa Lu\u010bija" },
            { "phn", "Feni\u010bju" },
            { "gwi", "Gwi\u010bin" },
            { "lg", "Ganda" },
            { "nds", "\u0120ermani\u017c Komuni; Sassonu Komuni" },
            { "LI", "Liechtenstein" },
            { "li", "Limburgish" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadjen" },
            { "ln", "Lingaljan" },
            { "fur", "Frijuljan" },
            { "lo", "Lao" },
            { "cop", "Koptiku" },
            { "LR", "Liberja" },
            { "LS", "Lesoto" },
            { "LT", "Litwanja" },
            { "lt", "Litwanjan" },
            { "LU", "Lussemburgu" },
            { "lu", "Luba-Katanga" },
            { "LV", "Latvja" },
            { "lv", "Latvjan" },
            { "sog", "Sogdien" },
            { "LY", "Libja" },
            { "lad", "Ladino" },
            { "lah", "Landa" },
            { "MA", "Marokk" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "lam", "Lamba" },
            { "MG", "Madagaskar" },
            { "mg", "Malaga\u017ci" },
            { "MH", "G\u017cejjer ta\u2019 Marshall" },
            { "mh", "Marxall" },
            { "ale", "Aleut" },
            { "mi", "Maori" },
            { "MK", "Ma\u010bedonja" },
            { "mk", "Ma\u010bedonjan" },
            { "ML", "Mali" },
            { "ml", "Malajalam" },
            { "MM", "Mjanmar" },
            { "MN", "Mongolja" },
            { "mn", "Mongoljan" },
            { "new", "Newari" },
            { "MO", "Macao S.A.R., China" },
            { "MP", "G\u017cejjer Marjana ta\u2019 Fuq" },
            { "MQ", "Martinik" },
            { "MR", "Mawritanja" },
            { "mr", "Marati" },
            { "MS", "Montserrat" },
            { "ms", "Malajan" },
            { "MT", "Malta" },
            { "mt", "Malti" },
            { "MU", "Mawrizju" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Messiku" },
            { "type.ca.japanese", "Kalendarju \u0120appuni\u017c" },
            { "MY", "Malasja" },
            { "my", "Burmi\u017c" },
            { "MZ", "Mo\u017cambik" },
            { "mdf", "Moksha" },
            { "dsb", "Lower Sorbian" },
            { "NA", "Namibja" },
            { "na", "Nawuru" },
            { "nb", "Bokmahal Norve\u0121i\u017c" },
            { "type.ca.hebrew", "Kalendarju Ebrajk" },
            { "NC", "New Caledonia" },
            { "nd", "Ndebele, ta\u2019 Fuq" },
            { "NE", "Ni\u0121er" },
            { "ne", "Nepali\u017c" },
            { "NF", "Norfolk Island" },
            { "NG", "Ni\u0121erja" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "NI", "Nikaragwa" },
            { "NL", "Olanda" },
            { "nl", "Olandi\u017c" },
            { "nn", "Ninorsk Norve\u0121i\u017c" },
            { "NO", "Norve\u0121ja" },
            { "no", "Norve\u0121i\u017c" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "nr", "Ndebele, t\u2019Isfel" },
            { "NU", "Niue" },
            { "nv", "Nava\u0127o" },
            { "kaa", "Kara-Kalpak" },
            { "ny", "\u010ai\u010bewa; Njan\u0121a" },
            { "tsi", "Zimxjan" },
            { "NZ", "New Zealand" },
            { "kac", "Ka\u010bin" },
            { "kab", "Kabuljan" },
            { "rom", "\u017bingaru" },
            { "oc", "O\u010b\u010bitan" },
            { "kam", "Kamba" },
            { "men", "Mende" },
            { "crh", "Crimean Turkish; Crimean Tatar" },
            { "oj", "O\u0121ibwa" },
            { "ang", "Ingli\u017c, Antik" },
            { "OM", "Oman" },
            { "om", "Oromo (Afan)" },
            { "kaw", "Kawi" },
            { "anp", "Angika" },
            { "or", "Orija" },
            { "os", "Ossettiku" },
            { "Xpeo", metaValue_peo },
            { "kbd", "Kabardian" },
            { "PA", "Panama" },
            { "pa", "Pun\u0121abi" },
            { "dua", "Dwala" },
            { "type.ca.islamic-civil", "Kalendarju Islamiku-\u010aivili" },
            { "srr", "Serer" },
            { "csb", "Kashubian" },
            { "en_GB", "Ingli\u017c Brittaniku" },
            { "PE", "Peru" },
            { "PF", "Polinesja Fran\u010bi\u017ca" },
            { "PG", "Papwa-Ginea \u0120dida" },
            { "PH", "Filippini" },
            { "pi", "Pali" },
            { "PK", "Pakistan" },
            { "PL", "Polonja" },
            { "pl", "Pollakk" },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre and Miquelon" },
            { "dum", "Olandi\u017c, Medjevali" },
            { "PN", "Pitcairn" },
            { "type.ca.dangi", "Kalendarju Dangi" },
            { "PR", "Puerto Rico" },
            { "PS", "Territorju Palestinjan" },
            { "ps", "Paxtun" },
            { "PT", "Portugall" },
            { "pt", "Portugi\u017c" },
            { "mga", "Irlandi\u017c, Medjevali" },
            { "key.co", "Kollazjoni" },
            { "PW", "Palau" },
            { "nia", "Nijas" },
            { "PY", "Paragwaj" },
            { "tum", "Tumbuka" },
            { "QA", "Qatar" },
            { "bra", "Braj" },
            { "key.ca", "Kalendarju" },
            { "niu", "Nijuwejan" },
            { "lez", "Le\u017cgjan" },
            { "qu", "Ke\u010bwa" },
            { "zap", "\u017bapotek" },
            { "tvl", metaValue_TV },
            { "001", "Dinja" },
            { "002", "Affrika" },
            { "RE", "R\u00e9union" },
            { "005", "Amerika t\u2019Isfel" },
            { "jbo", "Lojban" },
            { "009", "O\u010bejanja" },
            { "rm", "Reto-Romanz" },
            { "rn", "Rundi" },
            { "key.cu", "Munita" },
            { "RO", "Rumanija" },
            { "ro", "Rumen" },
            { "RU", "Ir-Russja" },
            { "ru", "Russu" },
            { "RW", "Rwanda" },
            { "rw", "Kinjarwanda" },
            { "mic", "Mikmek" },
            { "suk", "Sukuma" },
            { "en_AU", "Ingli\u017c Awstraljan" },
            { "SA", "G\u0127arabja Sawdita" },
            { "sa", "Sanskrit" },
            { "pon", "Ponpejan" },
            { "SB", "Solomon Islands" },
            { "011", "Affrika tal-Punent" },
            { "SC", "Seychelles" },
            { "sc", "Sardinjan" },
            { "sus", "Susu" },
            { "SD", "Sudan" },
            { "sd", "Sindi" },
            { "013", "Amerika \u010aentrali" },
            { "SE", "\u017bvezja" },
            { "se", "Sami ta\u2019 Fuq" },
            { "014", "Affrika tal-Lvant" },
            { "arc", "Aramajk" },
            { "min", "Minangkabaw" },
            { "015", "Affrika ta\u2019 Fuq" },
            { "SG", "Singapor" },
            { "sg", "Sango" },
            { "SH", "Saint Helena" },
            { "sh", "Serbo-Kroat" },
            { "017", "Affrika Nofsani" },
            { "SI", "Slovenja" },
            { "si", "Sin\u0127ali\u017c" },
            { "018", "Affrika t\u2019Isfel" },
            { "SJ", "Svalbard and Jan Mayen" },
            { "sux", "Sumerjan" },
            { "019", "Amerika" },
            { "SK", "Slovakkja" },
            { "sk", "Slovakk" },
            { "SL", "Sierra Leone" },
            { "sl", "Sloven" },
            { "SM", "San Marino" },
            { "sm", "Samojan" },
            { "SN", "Senegal" },
            { "sn", "Xona" },
            { "SO", "Somalja" },
            { "so", "Somali" },
            { "arn", "Arawkanjan" },
            { "sq", "Albani\u017c" },
            { "arp", "Arapa\u0127o" },
            { "SR", "Surinam" },
            { "sr", "Serb" },
            { "ss", "Swati" },
            { "ST", "Sao Tome and Principe" },
            { "st", "Soto, t\u2019Isfel" },
            { "su", "Sundani\u017c" },
            { "SV", "El Salvador" },
            { "sv", "Svedi\u017c" },
            { "sw", "Swa\u0127ili" },
            { "SY", "Sirja" },
            { "yao", "Jao" },
            { "SZ", "Swa\u017ciland" },
            { "arw", "Arawak" },
            { "iba", "Iban" },
            { "yap", "Japese" },
            { "ta", "Tamil" },
            { "142", "Asja" },
            { "TC", "Turks and Caicos Islands" },
            { "bua", "Burjat" },
            { "143", "Asja \u010aentrali" },
            { "TD", "\u010aad" },
            { "te", "Telugu" },
            { "145", "Asja tal-Punent" },
            { "TF", "Territorji Fran\u010bi\u017ci ta\u2019 Nofsinhar" },
            { "TG", "Togo" },
            { "tg", "Ta\u0121ik" },
            { "TH", "Tajlandja" },
            { "th", "Tajlandi\u017c" },
            { "ti", "Tigrinja" },
            { "bug", "Bugini\u017c" },
            { "TJ", "Ta\u0121ikistan" },
            { "029", "Karibew" },
            { "TK", "Tokelaw" },
            { "tk", "Turkmeni" },
            { "TL", "Timor tal-Lvant" },
            { "tl", "Tagalog" },
            { "TM", "Turkmenistan" },
            { "TN", "Tune\u017c" },
            { "tn", "Zwana" },
            { "TO", "Tonga" },
            { "to", "Tongan" },
            { "TR", "Turkija" },
            { "tr", "Tork" },
            { "ts", "Tsonga" },
            { "TT", "Trinidad u Tobago" },
            { "tt", "Tatar" },
            { "dyu", "Djula" },
            { "TV", metaValue_TV },
            { "TW", "Tajwan" },
            { "tw", "Twi" },
            { "ast", "Asturian" },
            { "ty", "Ta\u0127itjan" },
            { "TZ", "Tan\u017canija" },
            { "Zzzz", "Kitba Mhux Mag\u0127rufa" },
            { "150", "Ewropa" },
            { "UA", "Ukraina" },
            { "rup", "Aromanijan" },
            { "030", "Asja tal-Lvant" },
            { "151", "Ewropa tal-Lvant" },
            { "154", "Ewropa ta\u2019 Fuq" },
            { "tyv", "Tuvinjan" },
            { "034", "Asja t\u2019Isfel \u010aentrali" },
            { "155", "Ewropa tal-Punent" },
            { "hai", "\u0126ajda" },
            { "035", "Asja tax-Xlokk" },
            { "UG", "Uganda" },
            { "ug", "Wigur" },
            { "type.co.pinyin", "Ordni tal-Pinjin" },
            { "Zyyy", "Komuni" },
            { "039", "Ewropa t\u2019Isfel" },
            { "uk", "Ukranjan" },
            { "UM", "United States Minor Outlying Islands" },
            { "ur", "Urdu" },
            { "US", "L-Istati Uniti" },
            { "haw", "\u0126awajjan" },
            { "xal", "Kalmyk" },
            { "zen", "\u017benaga" },
            { "type.co.gb2312han", "Ordni \u010aini\u017c Sempli\u010bi (GB2312)" },
            { "UY", "Urugwaj" },
            { "UZ", "U\u017cbekistan" },
            { "uz", "U\u017cbek" },
            { "kha", "Kasi" },
            { "type.co.stroke", "Ordni Ma\u0127\u017cu\u017ca" },
            { "VA", "Vatikan" },
            { "pro", "Provenzal, Antik" },
            { "VC", "Saint Vincent and the Grenadines" },
            { "VE", "Venezwela" },
            { "ve", "Venda" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "vi", "Vjetnami\u017c" },
            { "kho", "Kotani\u017c" },
            { "VN", "Vjetnam" },
            { "vo", "Volapuk" },
            { "VU", "Vanwatu" },
            { "gaa", "Ga" },
            { "nog", "Nogai" },
            { "wa", "Walloon" },
            { "non", "Skandinav, Antik" },
            { "syr", "Sirjan" },
            { "053", "Awstralja u New Zealand" },
            { "054", "Melanesja" },
            { "WF", "Wallis and Futuna" },
            { "Grek", metaValue_el },
            { "type.co.traditional", metaValue_Hant },
            { "057", "Re\u0121jun ta\u2019 Mikrone\u017cja" },
            { "wo", "Wolof" },
            { "ar_001", "G\u0127arbi Standard Modern" },
            { "WS", "Samoa" },
            { "gay", "Gajo" },
            { "mnc", "Man\u010burjan" },
            { "wal", "Walamo" },
            { "gba", "Gbaja" },
            { "was", "Waxo" },
            { "mni", "Manipuri" },
            { "war", "Waraj" },
            { "awa", "Awad\u0127i" },
            { "Latn", metaValue_la },
            { "061", "Polinesja" },
            { "xh", "\u0126o\u017ca" },
            { "Zxxx", "Mhux Miktub" },
            { "byn", "Blin" },
            { "osa", "Osa\u0121jan" },
            { "moh", "Mo\u0127ak" },
            { "YE", "Jemen" },
            { "type.co.standard", "Ordni Standard" },
            { "yi", "Jiddix" },
            { "mos", "Mossi" },
            { "fan", "Fang" },
            { "yo", "Joruba" },
            { "fat", "Fanti" },
            { "YT", "Majotte" },
            { "ota", "Tork (Imperu Ottoman)" },
            { "vai", "Vai" },
            { "ZA", "Afrika t\u2019Isfel" },
            { "za", "\u017bwang" },
            { "zh", "\u010aini\u017c" },
            { "ZM", "\u017bambja" },
            { "zu", "\u017bulu" },
            { "ZW", "\u017bimbabwe" },
            { "type.co.phonebook", "Ordni Telefonika" },
            { "ZZ", "Re\u0121jun Mhux Mag\u0127ruf" },
            { "kmb", "Kimbundu" },
            { "type.ca.iso8601", "Kalendarju ISO-8601" },
            { "lol", "Mongo" },
            { "nso", "Soto, ta\u2019 Fuq" },
            { "loz", "Lo\u017ci" },
            { "gez", "Geez" },
            { "zh_Hans", "\u010aini\u017c Simplifikat" },
            { "kok", "Konkani" },
            { "hil", "Hiligaynon" },
            { "kos", "Kosrejan" },
            { "dak", "Dakota" },
            { "hit", "\u0126ittit" },
            { "dar", "Dargwa" },
            { "kpe", "Kpelle" },
            { "ilo", "Iloko" },
            { "nwc", "Classical Newari" },
            { "udm", "Udmurt" },
            { "mul", "Lingwi Diversi" },
            { "cad", "Kaddo" },
            { "mus", "Kriek" },
            { "gil", "Gilbertjan" },
            { "car", "Karib" },
            { "sad", "Sandawe" },
            { "sah", "Jakut" },
            { "krc", "Karachay-Balkar" },
            { "sam", "Samritan" },
            { "inh", "Ingush" },
            { "sas", "Saska" },
            { "sat", "Santali" },
            { "efi", "Efik" },
            { "jpr", "Lhudi-Persjan" },
            { "kru", "Kurusk" },
            { "lua", "Luba-Luluwa" },
        };
        return data;
    }
}
