/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import org.apache.jasper.compiler.JarResource;

public class JarURLResource
implements JarResource {
    private String jarUrl;

    public JarURLResource(URL jarURL) {
        this(jarURL.toExternalForm());
    }

    public JarURLResource(String jarUrl) {
        this.jarUrl = jarUrl;
    }

    @Override
    public JarFile getJarFile() throws IOException {
        URL jarFileUrl = new URL("jar:" + this.jarUrl + "!/");
        JarURLConnection conn = (JarURLConnection)jarFileUrl.openConnection();
        conn.setUseCaches(false);
        conn.connect();
        return conn.getJarFile();
    }

    @Override
    public String getUrl() {
        return this.jarUrl;
    }

    @Override
    public URL getEntry(String name) {
        try {
            return new URL("jar:" + this.jarUrl + "!/" + name);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("", e);
        }
    }
}

