/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;

class HprofArrayValue
extends HprofObject
implements ArrayItemValue {
    final ClassDump dumpClass;
    final int index;

    HprofArrayValue(ClassDump classDump, long l, int n) {
        super(l + (long)n + 1L);
        this.dumpClass = classDump;
        this.index = n;
    }

    @Override
    public Instance getDefiningInstance() {
        return new ObjectArrayDump(this.dumpClass, this.getInstanceArrayOffset());
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Instance getInstance() {
        HprofHeap hprofHeap = this.dumpClass.getHprof();
        HprofByteBuffer hprofByteBuffer = hprofHeap.dumpBuffer;
        int n = hprofByteBuffer.getIDSize();
        long l = hprofByteBuffer.getID(this.getInstanceArrayOffset() + 1L + (long)n + 4L + 4L + (long)n + (long)this.index * (long)n);
        return hprofHeap.getInstanceByID(l);
    }

    private long getInstanceArrayOffset() {
        return this.fileOffset - (long)this.index - 1L;
    }
}

