/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

final class ColorIcon
implements Icon {
    private final Color color;
    private final int size;

    public ColorIcon(Color color, int n) {
        this.color = color;
        this.size = n;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, this.size - 1, this.size - 1);
        if (null == this.color) {
            graphics.drawLine(n, n2 + this.size - 1, n + this.size - 1, n2);
        } else {
            graphics.setColor(this.color);
            graphics.fillRect(n + 1, n2 + 1, this.size - 2, this.size - 2);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

