/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.kerberos;

import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class KerberosTicketValidator {
    static final Oid SPNEGO_OID = KerberosTicketValidator.getSpnegoOid();
    private static final Logger LOGGER = ESLoggerFactory.getLogger(KerberosTicketValidator.class);
    private static final String KEY_TAB_CONF_NAME = "KeytabConf";
    private static final String SUN_KRB5_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";

    private static Oid getSpnegoOid() {
        Oid oid = null;
        try {
            oid = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gsse) {
            throw ExceptionsHelper.convertToRuntime((Exception)gsse);
        }
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void validateTicket(byte[] decodedToken, Path keytabPath, boolean krbDebug, ActionListener<Tuple<String, String>> actionListener) {
        GSSManager gssManager = GSSManager.getInstance();
        GSSContext gssContext = null;
        LoginContext loginContext = null;
        try {
            loginContext = KerberosTicketValidator.serviceLogin(keytabPath.toString(), krbDebug);
            GSSCredential serviceCreds = KerberosTicketValidator.createCredentials(gssManager, loginContext.getSubject());
            gssContext = gssManager.createContext(serviceCreds);
            String base64OutToken = this.encodeToString(KerberosTicketValidator.acceptSecContext(decodedToken, gssContext, loginContext.getSubject()));
            LOGGER.trace("validateTicket isGSSContextEstablished = {}, username = {}, outToken = {}", (Object)gssContext.isEstablished(), (Object)gssContext.getSrcName().toString(), (Object)base64OutToken);
            actionListener.onResponse((Object)new Tuple((Object)(gssContext.isEstablished() ? gssContext.getSrcName().toString() : null), (Object)base64OutToken));
        }
        catch (GSSException e) {
            actionListener.onFailure((Exception)e);
            KerberosTicketValidator.privilegedLogoutNoThrow(loginContext);
            KerberosTicketValidator.privilegedDisposeNoThrow(gssContext);
        }
        catch (PrivilegedActionException pve) {
            block8: {
                if (pve.getCause() instanceof LoginException) {
                    actionListener.onFailure((Exception)((LoginException)pve.getCause()));
                    break block8;
                }
                if (pve.getCause() instanceof GSSException) {
                    actionListener.onFailure((Exception)((GSSException)pve.getCause()));
                    break block8;
                }
                actionListener.onFailure(pve.getException());
                {
                    catch (Throwable throwable) {
                        KerberosTicketValidator.privilegedLogoutNoThrow(loginContext);
                        KerberosTicketValidator.privilegedDisposeNoThrow(gssContext);
                        throw throwable;
                    }
                }
            }
            KerberosTicketValidator.privilegedLogoutNoThrow(loginContext);
            KerberosTicketValidator.privilegedDisposeNoThrow(gssContext);
        }
        KerberosTicketValidator.privilegedLogoutNoThrow(loginContext);
        KerberosTicketValidator.privilegedDisposeNoThrow(gssContext);
    }

    private String encodeToString(byte[] outToken) {
        if (outToken != null && outToken.length > 0) {
            return Base64.getEncoder().encodeToString(outToken);
        }
        return null;
    }

    private static byte[] acceptSecContext(byte[] base64decodedTicket, GSSContext gssContext, Subject subject) throws PrivilegedActionException {
        return KerberosTicketValidator.doAsWrapper(subject, () -> gssContext.acceptSecContext(base64decodedTicket, 0, base64decodedTicket.length));
    }

    private static GSSCredential createCredentials(GSSManager gssManager, Subject subject) throws PrivilegedActionException {
        return KerberosTicketValidator.doAsWrapper(subject, () -> gssManager.createCredential(null, 0, SPNEGO_OID, 2));
    }

    private static <T> T doAsWrapper(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        try {
            return (T)AccessController.doPrivileged(() -> Subject.doAs(subject, action));
        }
        catch (PrivilegedActionException pae) {
            if (pae.getCause() instanceof PrivilegedActionException) {
                throw (PrivilegedActionException)pae.getCause();
            }
            throw pae;
        }
    }

    private static void privilegedDisposeNoThrow(GSSContext gssContext) {
        if (gssContext != null) {
            try {
                AccessController.doPrivileged(() -> {
                    gssContext.dispose();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                LOGGER.debug("Could not dispose GSS Context", e.getCause());
            }
        }
    }

    private static void privilegedLogoutNoThrow(LoginContext loginContext) {
        if (loginContext != null) {
            try {
                AccessController.doPrivileged(() -> {
                    loginContext.logout();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                LOGGER.debug("Could not close LoginContext", e.getCause());
            }
        }
    }

    private static LoginContext serviceLogin(String keytabFilePath, boolean krbDebug) throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> {
            Subject subject = new Subject(false, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
            KeytabJaasConf conf = new KeytabJaasConf(keytabFilePath, krbDebug);
            LoginContext loginContext = new LoginContext(KEY_TAB_CONF_NAME, subject, null, conf);
            loginContext.login();
            return loginContext;
        });
    }

    static class KeytabJaasConf
    extends Configuration {
        private final String keytabFilePath;
        private final boolean krbDebug;

        KeytabJaasConf(String keytabFilePath, boolean krbDebug) {
            this.keytabFilePath = keytabFilePath;
            this.krbDebug = krbDebug;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("keyTab", this.keytabFilePath);
            options.put("principal", "*");
            options.put("useKeyTab", Boolean.TRUE.toString());
            options.put("storeKey", Boolean.TRUE.toString());
            options.put("doNotPrompt", Boolean.TRUE.toString());
            options.put("isInitiator", Boolean.FALSE.toString());
            options.put("debug", Boolean.toString(this.krbDebug));
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosTicketValidator.SUN_KRB5_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.unmodifiableMap(options))};
        }
    }
}

