/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.xpack.sql.proto.Mode;

public abstract class AbstractSqlRequest
extends ActionRequest
implements ToXContent {
    private Mode mode = Mode.PLAIN;

    protected AbstractSqlRequest() {
    }

    protected AbstractSqlRequest(Mode mode) {
        this.mode = mode;
    }

    protected AbstractSqlRequest(StreamInput in) throws IOException {
        super(in);
        this.mode = (Mode)in.readEnum(Mode.class);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.mode == null) {
            validationException = ValidateActions.addValidationError((String)"[mode] is required", validationException);
        }
        return validationException;
    }

    public final void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.mode);
    }

    public Mode mode() {
        return this.mode;
    }

    public void mode(Mode mode) {
        this.mode = mode;
    }

    public void mode(String mode) {
        this.mode = Mode.fromString((String)mode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractSqlRequest that = (AbstractSqlRequest)((Object)o);
        return this.mode == that.mode;
    }

    public int hashCode() {
        return Objects.hash(this.mode);
    }
}

