/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.job.persistence.JobStorageDeletionTask;
import org.elasticsearch.xpack.ml.job.JobManager;

public class TransportDeleteJobAction
extends TransportMasterNodeAction<DeleteJobAction.Request, DeleteJobAction.Response> {
    private final Client client;
    private final JobManager jobManager;
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportDeleteJobAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager, PersistentTasksService persistentTasksService, Client client) {
        super(settings, "cluster:admin/xpack/ml/job/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteJobAction.Request::new);
        this.client = client;
        this.jobManager = jobManager;
        this.persistentTasksService = persistentTasksService;
    }

    protected String executor() {
        return "same";
    }

    protected DeleteJobAction.Response newResponse() {
        return new DeleteJobAction.Response();
    }

    protected void masterOperation(Task task, DeleteJobAction.Request request, ClusterState state, ActionListener<DeleteJobAction.Response> listener) throws Exception {
        ActionListener markAsDeletingListener = ActionListener.wrap(response -> {
            if (request.isForce()) {
                this.forceDeleteJob(request, (JobStorageDeletionTask)task, listener);
            } else {
                this.normalDeleteJob(request, (JobStorageDeletionTask)task, listener);
            }
        }, e -> {
            if (e instanceof MlMetadata.JobAlreadyMarkedAsDeletedException) {
                this.waitForDeletingJob(request.getJobId(), MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT, (ActionListener<DeleteJobAction.Response>)ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e2 -> {
                    if (request.isForce() && e2 instanceof TimeoutException) {
                        this.forceDeleteJob(request, (JobStorageDeletionTask)task, listener);
                    } else {
                        listener.onFailure(e2);
                    }
                }));
            } else {
                listener.onFailure(e);
            }
        });
        this.markJobAsDeleting(request.getJobId(), (ActionListener<Boolean>)markAsDeletingListener, request.isForce());
    }

    protected void masterOperation(DeleteJobAction.Request request, ClusterState state, ActionListener<DeleteJobAction.Response> listener) throws Exception {
        throw new UnsupportedOperationException("the Task parameter is required");
    }

    protected ClusterBlockException checkBlock(DeleteJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void normalDeleteJob(DeleteJobAction.Request request, JobStorageDeletionTask task, ActionListener<DeleteJobAction.Response> listener) {
        this.jobManager.deleteJob(request, task, listener);
    }

    private void forceDeleteJob(final DeleteJobAction.Request request, final JobStorageDeletionTask task, final ActionListener<DeleteJobAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        String jobId = request.getJobId();
        ActionListener<Boolean> removeTaskListener = new ActionListener<Boolean>(){

            public void onResponse(Boolean response) {
                TransportDeleteJobAction.this.jobManager.deleteJob(request, task, (ActionListener<DeleteJobAction.Response>)listener);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    TransportDeleteJobAction.this.jobManager.deleteJob(request, task, (ActionListener<DeleteJobAction.Response>)listener);
                } else {
                    listener.onFailure(e);
                }
            }
        };
        ActionListener killJobListener = ActionListener.wrap(arg_0 -> this.lambda$forceDeleteJob$3(request, state, (ActionListener)removeTaskListener, arg_0), arg_0 -> this.lambda$forceDeleteJob$4(request, state, (ActionListener)removeTaskListener, listener, arg_0));
        this.killProcess(jobId, (ActionListener<KillProcessAction.Response>)killJobListener);
    }

    private void killProcess(String jobId, ActionListener<KillProcessAction.Response> listener) {
        KillProcessAction.Request killRequest = new KillProcessAction.Request(jobId);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)KillProcessAction.INSTANCE, (ActionRequest)killRequest, listener);
    }

    private void removePersistentTask(String jobId, ClusterState currentState, final ActionListener<Boolean> listener) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
        if (jobTask == null) {
            listener.onResponse(null);
        } else {
            this.persistentTasksService.sendRemoveRequest(jobTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                    listener.onResponse((Object)Boolean.TRUE);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    void markJobAsDeleting(final String jobId, final ActionListener<Boolean> listener, final boolean force) {
        this.clusterService.submitStateUpdateTask("mark-job-as-deleted", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.metaData().custom("persistent_tasks");
                MlMetadata.Builder builder = new MlMetadata.Builder(MlMetadata.getMlMetadata((ClusterState)currentState));
                builder.markJobAsDeleted(jobId, tasks, force);
                return TransportDeleteJobAction.buildNewClusterState(currentState, builder);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                TransportDeleteJobAction.this.logger.debug("Job [" + jobId + "] is successfully marked as deleted");
                listener.onResponse((Object)true);
            }
        });
    }

    void waitForDeletingJob(String jobId, TimeValue timeout, final ActionListener<DeleteJobAction.Response> listener) {
        ClusterStateObserver stateObserver = new ClusterStateObserver(this.clusterService, timeout, this.logger, this.threadPool.getThreadContext());
        ClusterState clusterState = stateObserver.setAndGetObservedState();
        if (TransportDeleteJobAction.jobIsDeletedFromState(jobId, clusterState)) {
            listener.onResponse((Object)new DeleteJobAction.Response(true));
        } else {
            stateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    listener.onResponse((Object)new DeleteJobAction.Response(true));
                }

                public void onClusterServiceClose() {
                    listener.onFailure((Exception)new NodeClosedException(TransportDeleteJobAction.this.clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    listener.onFailure((Exception)new TimeoutException("timed out after " + timeout));
                }
            }, newClusterState -> TransportDeleteJobAction.jobIsDeletedFromState(jobId, newClusterState), timeout);
        }
    }

    static boolean jobIsDeletedFromState(String jobId, ClusterState clusterState) {
        return !MlMetadata.getMlMetadata((ClusterState)clusterState).getJobs().containsKey(jobId);
    }

    private static ClusterState buildNewClusterState(ClusterState currentState, MlMetadata.Builder builder) {
        ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
        newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)builder.build()).build());
        return newState.build();
    }

    private /* synthetic */ void lambda$forceDeleteJob$4(DeleteJobAction.Request request, ClusterState state, ActionListener removeTaskListener, ActionListener listener, Exception e) {
        if (e instanceof ElasticsearchStatusException) {
            this.removePersistentTask(request.getJobId(), state, (ActionListener<Boolean>)removeTaskListener);
        } else {
            listener.onFailure(e);
        }
    }

    private /* synthetic */ void lambda$forceDeleteJob$3(DeleteJobAction.Request request, ClusterState state, ActionListener removeTaskListener, KillProcessAction.Response response) throws Exception {
        this.removePersistentTask(request.getJobId(), state, (ActionListener<Boolean>)removeTaskListener);
    }
}

