/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Icons;
import esmska.data.Log;
import esmska.gui.Actions;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.apache.commons.lang.StringUtils;
import org.openide.awt.Mnemonics;

public class StatusPanel
extends JPanel {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final DateFormat shortTimeFormat = DateFormat.getTimeInstance(3);
    private Log log = Log.getInstance();
    private Timer statusTimer = new Timer(5000, new HideStatusListener());
    private Runnable currentHandler;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;

    public StatusPanel() {
        this.initComponents();
        this.statusTimer.setRepeats(false);
        this.log.addActionListener(new LogListener());
    }

    public void setStatusMessage(String message, Date time, ImageIcon icon, boolean html) {
        String messageEsc = StringUtils.defaultString(message);
        if (!html) {
            messageEsc = MiscUtils.escapeHtml(messageEsc);
        }
        if (time != null) {
            String timestamp = shortTimeFormat.format(time);
            this.statusMessageLabel.setText("<html>[" + timestamp + "] " + messageEsc + "</html>");
        } else {
            this.statusMessageLabel.setText("<html>" + messageEsc + "</html>");
        }
        this.statusMessageLabel.setIcon(icon);
        this.currentHandler = null;
        this.statusMessageLabel.setToolTipText(l10n.getString("StatusPanel.statusMessageLabel.toolTipText"));
    }

    public void installClickHandler(Runnable handler, String tooltip) {
        this.currentHandler = handler;
        this.statusMessageLabel.setToolTipText(tooltip);
    }

    public void hideStatusMessageAfter(int millis) {
        if (millis <= 0) {
            this.statusTimer.stop();
            return;
        }
        this.statusTimer.setInitialDelay(millis);
        this.statusTimer.restart();
    }

    public void setTaskRunning(boolean b) {
        if (!b) {
            this.statusAnimationLabel.setIcon(Icons.get("task-idle.png"));
        } else {
            this.statusAnimationLabel.setIcon(Icons.get("task-busy.gif"));
        }
    }

    public void setProgress(Integer value, String text, Boolean stringPainted, Boolean visible) {
        if (value != null) {
            this.progressBar.setValue(value);
        }
        if (text != null) {
            this.progressBar.setString(text);
        }
        if (stringPainted != null) {
            this.progressBar.setStringPainted(stringPainted);
        }
        if (visible != null) {
            this.progressBar.setVisible(visible);
        }
    }

    private void initComponents() {
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        Mnemonics.setLocalizedText(this.statusMessageLabel, l10n.getString("StatusPanel.statusMessageLabel.text"));
        this.statusMessageLabel.setToolTipText(l10n.getString("StatusPanel.statusMessageLabel.toolTipText"));
        this.statusMessageLabel.setFocusable(false);
        this.statusMessageLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.statusMessageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatusPanel.this.statusMessageLabelMouseClicked(evt);
            }
        });
        this.statusAnimationLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/task-idle.png")));
        this.statusAnimationLabel.setFocusable(false);
        this.progressBar.setMaximum(15);
        this.progressBar.setFocusable(false);
        this.progressBar.setString(l10n.getString("StatusPanel.progressBar.string"));
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel, -1, 163, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel, -2, 16, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusMessageLabel, GroupLayout.Alignment.TRAILING, -1, 20, Short.MAX_VALUE).addComponent(this.statusAnimationLabel, GroupLayout.Alignment.TRAILING, -2, 20, -2).addComponent(this.progressBar, GroupLayout.Alignment.TRAILING, -2, -1, -2));
    }

    private void statusMessageLabelMouseClicked(MouseEvent evt) {
        if (this.currentHandler != null) {
            this.currentHandler.run();
        } else {
            Actions.getLogAction().actionPerformed(null);
        }
    }

    private class HideStatusListener
    implements ActionListener {
        private HideStatusListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusPanel.this.statusMessageLabel.setIcon(null);
            StatusPanel.this.statusMessageLabel.setText(null);
        }
    }

    private class LogListener
    implements ActionListener {
        private LogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getID() == 0) {
                Log.Record last = StatusPanel.this.log.getLastRecord();
                StatusPanel.this.setStatusMessage(last.getMessage(), last.getTime(), last.getIcon(), false);
            }
        }
    }
}

