/* -*- mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
// vim:sts=8:sw=8:ts=8:noet:sr:cino=>s,f0,{0,g0,(0,\:0,t0,+0,=s
/*
 * Copyright (C) 2016 the FFLAS-FFPACK group
 *
 * Written by <clement.pernet@imag.fr>
 *
 *  Includes the proper intrinsic definitions, according to the architecture and system.
 *  Code proposed by Marat Dukhan http://stackoverflow.com/questions/11228855/header-files-for-simd-intrinsics
 *
 * ========LICENCE========
 * This file is part of the library FFLAS-FFPACK.
 *
 * FFLAS-FFPACK is free software: you can redistribute it and/or modify
 * it under the terms of the  GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * ========LICENCE========
 *.
 */

#if defined(_MSC_VER)
    /* Microsoft C/C++-compatible compiler */
#include <intrin.h>
#elif (defined(__GNUC__) || defined(__clang__) || defined(__INTEL_COMPILER)) && (defined(__x86_64__) || defined(__i386__))
    /* GCC-compatible compiler, targeting x86/x86-64 */
#include <x86intrin.h>
#elif (defined(__GNUC__) || defined(__clang__)) && defined(__ARM_NEON__)
    /* GCC-compatible compiler, targeting ARM with NEON */
#include <arm_neon.h>
#elif (defined(__GNUC__) || defined(__clang__)) && defined(__IWMMXT__)
    /* GCC-compatible compiler, targeting ARM with WMMX */
#include <mmintrin.h>
#elif (defined(__GNUC__) || defined(__xlC__) || defined(__clang__)) && (defined(__VEC__) || defined(__ALTIVEC__))
    /* XLC or GCC-compatible compiler, targeting PowerPC with VMX/VSX */
#include <altivec.h>
#elif (defined(__GNUC__) || defined(__clang__)) && defined(__SPE__)
    /* GCC-compatible compiler, targeting PowerPC with SPE */
#include <spe.h>
#endif
