/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.text;

import javax.swing.ImageIcon;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.model.TextModel;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.text.ColorMode;
import org.gephi.visualization.text.TextManager;
import org.openide.util.NbBundle;

public class TextColorMode
implements ColorMode {
    private final VizConfig vizConfig = VizController.getInstance().getVizConfig();
    private float[] color;

    @Override
    public void defaultNodeColor(TextManager.Renderer renderer) {
        this.color = VizController.getInstance().getVizModel().getTextModel().nodeColor;
    }

    @Override
    public void defaultEdgeColor(TextManager.Renderer renderer) {
        this.color = VizController.getInstance().getVizModel().getTextModel().edgeColor;
    }

    @Override
    public void textNodeColor(TextManager.Renderer renderer, NodeModel nodeModel) {
        this.textColor(renderer, nodeModel, nodeModel.isSelected() || nodeModel.isHighlight());
    }

    @Override
    public void textEdgeColor(TextManager.Renderer renderer, EdgeModel edgeModel) {
        this.textColor(renderer, edgeModel, edgeModel.isSelected() || edgeModel.isAutoSelected());
    }

    public void textColor(TextManager.Renderer renderer, TextModel text, boolean selected) {
        if (text.hasCustomTextColor()) {
            if (this.vizConfig.isLightenNonSelected()) {
                if (!selected) {
                    float lightColorFactor = 1.0f - this.vizConfig.getLightenNonSelectedFactor();
                    renderer.setColor(text.getTextR(), text.getTextG(), text.getTextB(), lightColorFactor);
                } else {
                    renderer.setColor(text.getTextR(), text.getTextG(), text.getTextB(), 1.0f);
                }
            } else {
                renderer.setColor(text.getTextR(), text.getTextG(), text.getTextB(), text.getTextAlpha());
            }
        } else if (this.vizConfig.isLightenNonSelected()) {
            if (!selected) {
                float lightColorFactor = 1.0f - this.vizConfig.getLightenNonSelectedFactor();
                renderer.setColor(this.color[0], this.color[1], this.color[2], lightColorFactor);
            } else {
                renderer.setColor(this.color[0], this.color[1], this.color[2], 1.0f);
            }
        } else {
            renderer.setColor(this.color[0], this.color[1], this.color[2], 1.0f);
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(TextColorMode.class, (String)"TextColorMode.name");
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/org/gephi/visualization/opengl/text/TextColorMode.png"));
    }

    public String toString() {
        return this.getName();
    }
}

