/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dump;

import com.android.dex.util.FileUtils;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.command.dump.Args;
import com.android.dx.command.dump.BlockDumper;
import com.android.dx.command.dump.ClassDumper;
import com.android.dx.command.dump.DotDumper;
import com.android.dx.command.dump.SsaDumper;
import com.android.dx.util.HexParser;
import java.io.UnsupportedEncodingException;

public class Main {
    static Args parsedArgs = new Args();

    private Main() {
    }

    public static void main(String[] args) {
        String arg;
        int at;
        for (at = 0; at < args.length && !(arg = args[at]).equals("--") && arg.startsWith("--"); ++at) {
            if (arg.equals("--bytes")) {
                Main.parsedArgs.rawBytes = true;
                continue;
            }
            if (arg.equals("--basic-blocks")) {
                Main.parsedArgs.basicBlocks = true;
                continue;
            }
            if (arg.equals("--rop-blocks")) {
                Main.parsedArgs.ropBlocks = true;
                continue;
            }
            if (arg.equals("--optimize")) {
                Main.parsedArgs.optimize = true;
                continue;
            }
            if (arg.equals("--ssa-blocks")) {
                Main.parsedArgs.ssaBlocks = true;
                continue;
            }
            if (arg.startsWith("--ssa-step=")) {
                Main.parsedArgs.ssaStep = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.equals("--debug")) {
                Main.parsedArgs.debug = true;
                continue;
            }
            if (arg.equals("--dot")) {
                Main.parsedArgs.dotDump = true;
                continue;
            }
            if (arg.equals("--strict")) {
                Main.parsedArgs.strictParse = true;
                continue;
            }
            if (arg.startsWith("--width=")) {
                arg = arg.substring(arg.indexOf(61) + 1);
                Main.parsedArgs.width = Integer.parseInt(arg);
                continue;
            }
            if (arg.startsWith("--method=")) {
                Main.parsedArgs.method = arg = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            System.err.println("unknown option: " + arg);
            throw new RuntimeException("usage");
        }
        if (at == args.length) {
            System.err.println("no input files specified");
            throw new RuntimeException("usage");
        }
        while (at < args.length) {
            try {
                String name = args[at];
                System.out.println("reading " + name + "...");
                byte[] bytes = FileUtils.readFile(name);
                if (!name.endsWith(".class")) {
                    String src;
                    try {
                        src = new String(bytes, "utf-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException("shouldn't happen", ex);
                    }
                    bytes = HexParser.parse(src);
                }
                Main.processOne(name, bytes);
            }
            catch (ParseException ex) {
                System.err.println("\ntrouble parsing:");
                if (Main.parsedArgs.debug) {
                    ex.printStackTrace();
                }
                ex.printContext(System.err);
            }
            ++at;
        }
    }

    private static void processOne(String name, byte[] bytes) {
        if (Main.parsedArgs.dotDump) {
            DotDumper.dump(bytes, name, parsedArgs);
        } else if (Main.parsedArgs.basicBlocks) {
            BlockDumper.dump(bytes, System.out, name, false, parsedArgs);
        } else if (Main.parsedArgs.ropBlocks) {
            BlockDumper.dump(bytes, System.out, name, true, parsedArgs);
        } else if (Main.parsedArgs.ssaBlocks) {
            Main.parsedArgs.optimize = false;
            SsaDumper.dump(bytes, System.out, name, parsedArgs);
        } else {
            ClassDumper.dump(bytes, System.out, name, parsedArgs);
        }
    }
}

