/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.tracepoint;

import java.util.ArrayList;
import java.util.EnumSet;
import org.jruby.Ruby;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class TracePoint
extends RubyObject {
    private EventHook hook;
    private volatile boolean enabled = false;
    private String eventName = "";
    private String file = "";
    private int line = -1;
    private String name = "";
    private IRubyObject type;
    private IRubyObject exception;
    private IRubyObject returnValue;
    private IRubyObject binding;
    private volatile boolean inside = false;

    public static void createTracePointClass(Ruby runtime2) {
        RubyClass tracePoint = runtime2.defineClass("TracePoint", runtime2.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new TracePoint(runtime2, klazz);
            }
        });
        tracePoint.defineAnnotatedMethods(TracePoint.class);
    }

    public TracePoint(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.type = runtime2.getNil();
        this.exception = runtime2.getNil();
        this.returnValue = runtime2.getNil();
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] _events, final Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            throw runtime2.newArgumentError("must be called with a block");
        }
        ArrayList<RubyEvent> events = new ArrayList<RubyEvent>(_events.length);
        for (int i2 = 0; i2 < _events.length; ++i2) {
            RubySymbol _event = (RubySymbol)TypeConverter.convertToType(context, _events[i2], runtime2.getSymbol(), TracePoint.sites((ThreadContext)context).to_sym);
            String eventName = _event.asJavaString().toUpperCase();
            RubyEvent event2 = null;
            try {
                event2 = RubyEvent.valueOf(eventName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (event2 == null) {
                throw runtime2.newArgumentError("unknown event: " + eventName);
            }
            if (event2 == RubyEvent.A_CALL) {
                events.add(RubyEvent.CALL);
                events.add(RubyEvent.B_CALL);
                events.add(RubyEvent.C_CALL);
                continue;
            }
            if (event2 == RubyEvent.A_RETURN) {
                events.add(RubyEvent.RETURN);
                events.add(RubyEvent.B_RETURN);
                events.add(RubyEvent.C_RETURN);
                continue;
            }
            events.add(event2);
        }
        EnumSet<Object> _eventSet = events.size() > 0 ? EnumSet.copyOf(events) : EnumSet.of(RubyEvent.LINE);
        final EnumSet<Object> eventSet = _eventSet;
        this.hook = new EventHook(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void event(ThreadContext context, RubyEvent event2, String file2, int line, String name2, IRubyObject type2) {
                if (!TracePoint.this.enabled || context.isWithinTrace()) {
                    return;
                }
                TracePoint.this.inside = true;
                if (file2 == null) {
                    file2 = "(ruby)";
                }
                if (type2 == null) {
                    type2 = context.fals;
                }
                IRubyObject binding2 = event2 == RubyEvent.THREAD_BEGIN || event2 == RubyEvent.THREAD_END ? context.nil : RubyBinding.newBinding(context.runtime, context.currentBinding());
                context.preTrace();
                TracePoint.this.update(event2.getName(), file2, line, name2, type2, context.getErrorInfo(), context.nil, binding2);
                try {
                    block.yieldSpecific(context, TracePoint.this);
                }
                finally {
                    TracePoint.this.update(null, null, line, null, context.nil, context.nil, context.nil, context.nil);
                    context.postTrace();
                    TracePoint.this.inside = false;
                }
            }

            @Override
            public void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
                this.event(context, RubyEvent.fromName(eventName), file2, line, name2, type2);
            }

            @Override
            public boolean isInterestedInEvent(RubyEvent event2) {
                return eventSet.contains((Object)event2);
            }
        };
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject binding(ThreadContext context) {
        this.checkInside(context);
        return this.binding == null ? context.nil : this.binding;
    }

    @JRubyMethod
    public IRubyObject defined_class(ThreadContext context) {
        this.checkInside(context);
        return this.type;
    }

    @JRubyMethod
    public IRubyObject disable(ThreadContext context, Block block) {
        return this.doToggle(context, block, false);
    }

    @JRubyMethod
    public IRubyObject enable(ThreadContext context, Block block) {
        return this.doToggle(context, block, true);
    }

    @JRubyMethod(name={"enabled?"})
    public IRubyObject enabled_p(ThreadContext context) {
        return context.runtime.newBoolean(this.enabled);
    }

    @JRubyMethod
    public IRubyObject event(ThreadContext context) {
        this.checkInside(context);
        return this.eventName == null ? context.nil : context.runtime.newSymbol(this.eventName);
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        if (this.inside) {
            return context.runtime.newString("#<TracePoint:" + this.eventName + ">");
        }
        return context.runtime.newString("#<TracePoint:" + (this.enabled ? "enabled" : "disabled") + ">");
    }

    @JRubyMethod
    public IRubyObject lineno(ThreadContext context) {
        this.checkInside(context);
        return context.runtime.newFixnum(this.line);
    }

    @JRubyMethod
    public IRubyObject method_id(ThreadContext context) {
        this.checkInside(context);
        return this.name == null ? context.nil : context.runtime.newSymbol(this.name);
    }

    @JRubyMethod
    public IRubyObject callee_id(ThreadContext context) {
        this.checkInside(context);
        return this.name == null ? context.nil : context.runtime.newSymbol(this.name);
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        this.checkInside(context);
        return this.file == null ? context.nil : context.runtime.newString(this.file);
    }

    @JRubyMethod
    public IRubyObject raised_exception(ThreadContext context) {
        this.checkInside(context);
        return this.exception;
    }

    @JRubyMethod
    public IRubyObject return_value(ThreadContext context) {
        this.checkInside(context);
        return this.returnValue;
    }

    @JRubyMethod
    public IRubyObject self(ThreadContext context) {
        return this.binding.isNil() ? context.nil : ((RubyBinding)this.binding).getBinding().getSelf();
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject trace(ThreadContext context, IRubyObject self2, IRubyObject[] events, Block block) {
        TracePoint tp = (TracePoint)self2.callMethod(context, "new", events, block);
        tp.enable(context, Block.NULL_BLOCK);
        return tp;
    }

    private void update(String eventName, String file2, int line, String name2, IRubyObject type2, IRubyObject exception2, IRubyObject returnValue, IRubyObject binding2) {
        this.eventName = eventName;
        this.file = file2;
        this.line = line;
        this.name = name2;
        this.type = type2;
        this.exception = exception2;
        this.returnValue = returnValue;
        this.binding = binding2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized IRubyObject doToggle(ThreadContext context, Block block, boolean toggle) {
        if (block.isGiven()) {
            boolean old = this.enabled;
            try {
                this.updateEnabled(context, toggle);
                IRubyObject iRubyObject = block.yieldSpecific(context);
                return iRubyObject;
            }
            finally {
                this.updateEnabled(context, old);
            }
        }
        RubyBoolean old = context.runtime.newBoolean(this.enabled);
        this.updateEnabled(context, toggle);
        return old;
    }

    public void updateEnabled(ThreadContext context, boolean toggle) {
        if (toggle == this.enabled) {
            return;
        }
        this.enabled = toggle;
        if (toggle) {
            context.runtime.addEventHook(this.hook);
        } else {
            context.runtime.removeEventHook(this.hook);
        }
    }

    private void checkInside(ThreadContext context) throws RaiseException {
        if (!this.inside) {
            throw context.runtime.newRuntimeError("access from outside");
        }
    }

    private static JavaSites.TracePointSites sites(ThreadContext context) {
        return context.sites.TracePoint;
    }
}

