/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class AuditTrailService
extends AbstractComponent
implements AuditTrail {
    private final XPackLicenseState licenseState;
    private final List<AuditTrail> auditTrails;

    @Override
    public String name() {
        return "service";
    }

    public AuditTrailService(Settings settings, List<AuditTrail> auditTrails, XPackLicenseState licenseState) {
        super(settings);
        this.auditTrails = Collections.unmodifiableList(auditTrails);
        this.licenseState = licenseState;
    }

    public List<AuditTrail> getAuditTrails() {
        return this.auditTrails;
    }

    @Override
    public void authenticationSuccess(String realm, User user, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationSuccess(realm, user, request);
            }
        }
    }

    @Override
    public void authenticationSuccess(String realm, User user, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationSuccess(realm, user, action, message);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.anonymousAccessDenied(action, message);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.anonymousAccessDenied(request);
            }
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(request);
            }
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(action, message);
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(token, action, message);
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(realm, token, action, message);
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(token, request);
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(realm, token, request);
            }
        }
    }

    @Override
    public void accessGranted(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.accessGranted(authentication, action, message, roleNames);
            }
        }
    }

    @Override
    public void accessDenied(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.accessDenied(authentication, action, message, roleNames);
            }
        }
    }

    @Override
    public void tamperedRequest(RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(request);
            }
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(action, message);
            }
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(user, action, request);
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.connectionGranted(inetAddress, profile, rule);
            }
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.connectionDenied(inetAddress, profile, rule);
            }
        }
    }

    @Override
    public void runAsGranted(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsGranted(authentication, action, message, roleNames);
            }
        }
    }

    @Override
    public void runAsDenied(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsDenied(authentication, action, message, roleNames);
            }
        }
    }

    @Override
    public void runAsDenied(Authentication authentication, RestRequest request, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsDenied(authentication, request, roleNames);
            }
        }
    }
}

