/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapMetaDataResolver;

public class LdapSession
implements Releasable {
    protected final Logger logger;
    protected final RealmConfig realm;
    protected final LDAPInterface connection;
    protected final String userDn;
    protected final GroupsResolver groupsResolver;
    private LdapMetaDataResolver metaDataResolver;
    protected final TimeValue timeout;
    protected final Collection<Attribute> attributes;

    public LdapSession(Logger logger, RealmConfig realm, LDAPInterface connection, String userDn, GroupsResolver groupsResolver, LdapMetaDataResolver metaDataResolver, TimeValue timeout, Collection<Attribute> attributes) {
        this.logger = logger;
        this.realm = realm;
        this.connection = connection;
        this.userDn = userDn;
        this.groupsResolver = groupsResolver;
        this.metaDataResolver = metaDataResolver;
        this.timeout = timeout;
        this.attributes = attributes;
    }

    public void close() {
        if (this.connection instanceof LDAPConnection) {
            ((LDAPConnection)this.connection).close();
        }
    }

    public String userDn() {
        return this.userDn;
    }

    public RealmConfig realm() {
        return this.realm;
    }

    public LDAPInterface getConnection() {
        return this.connection;
    }

    public void groups(ActionListener<List<String>> listener) {
        this.groupsResolver.resolve(this.connection, this.userDn, this.timeout, this.logger, this.attributes, listener);
    }

    public void metaData(ActionListener<Map<String, Object>> listener) {
        this.metaDataResolver.resolve(this.connection, this.userDn, this.timeout, this.logger, this.attributes, listener);
    }

    public void resolve(ActionListener<LdapUserData> listener) {
        this.logger.debug("Resolving LDAP groups + meta-data for user [{}]", (Object)this.userDn);
        this.groups((ActionListener<List<String>>)ActionListener.wrap(groups -> {
            this.logger.debug("Resolved {} LDAP groups [{}] for user [{}]", (Object)groups.size(), groups, (Object)this.userDn);
            this.metaData((ActionListener<Map<String, Object>>)ActionListener.wrap(meta -> {
                this.logger.debug("Resolved {} meta-data fields [{}] for user [{}]", (Object)meta.size(), meta, (Object)this.userDn);
                listener.onResponse((Object)new LdapUserData((List<String>)groups, (Map<String, Object>)meta));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public static interface GroupsResolver {
        public void resolve(LDAPInterface var1, String var2, TimeValue var3, Logger var4, Collection<Attribute> var5, ActionListener<List<String>> var6);

        public String[] attributes();
    }

    public static class LdapUserData {
        public final List<String> groups;
        public final Map<String, Object> metaData;

        public LdapUserData(List<String> groups, Map<String, Object> metaData) {
            this.groups = groups;
            this.metaData = metaData;
        }
    }
}

