/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.tree.Location;

public abstract class BinaryExpression
extends Expression {
    private final Expression left;
    private final Expression right;

    protected BinaryExpression(Location location, Expression left, Expression right) {
        super(location, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    @Override
    public final BinaryExpression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    protected abstract BinaryExpression replaceChildren(Expression var1, Expression var2);

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public boolean foldable() {
        return this.left.foldable() && this.right.foldable();
    }

    @Override
    public boolean nullable() {
        return this.left.nullable() || this.left.nullable();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BinaryExpression other = (BinaryExpression)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left());
        sb.append(" ");
        sb.append(this.symbol());
        sb.append(" ");
        sb.append(this.right());
        return sb.toString();
    }

    public abstract String symbol();

    public abstract BinaryExpression swapLeftAndRight();
}

