/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;

public class TransportDeleteCalendarAction
extends HandledTransportAction<DeleteCalendarAction.Request, DeleteCalendarAction.Response> {
    private final Client client;
    private final JobManager jobManager;
    private final JobProvider jobProvider;

    @Inject
    public TransportDeleteCalendarAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, JobManager jobManager, JobProvider jobProvider) {
        super(settings, "cluster:admin/xpack/ml/calendars/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteCalendarAction.Request::new);
        this.client = client;
        this.jobManager = jobManager;
        this.jobProvider = jobProvider;
    }

    protected void doExecute(DeleteCalendarAction.Request request, ActionListener<DeleteCalendarAction.Response> listener) {
        String calendarId = request.getCalendarId();
        ActionListener calendarListener = ActionListener.wrap(calendar -> {
            DeleteByQueryRequest dbqRequest = this.buildDeleteByQuery(calendarId);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest, (ActionListener)ActionListener.wrap(response -> {
                if (response.getDeleted() == 0L) {
                    listener.onFailure((Exception)new ResourceNotFoundException("No calendar with id [" + calendarId + "]", new Object[0]));
                    return;
                }
                this.jobManager.updateProcessOnCalendarChanged(calendar.getJobIds());
                listener.onResponse((Object)new DeleteCalendarAction.Response(true));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobProvider.calendar(calendarId, (ActionListener<Calendar>)calendarListener);
    }

    private DeleteByQueryRequest buildDeleteByQuery(String calendarId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-meta"});
        DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
        request.setSlices(5);
        request.setRefresh(true);
        TermsQueryBuilder query = QueryBuilders.termsQuery((String)Calendar.ID.getPreferredName(), (String[])new String[]{calendarId});
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        return request;
    }
}

