/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Clock;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StartupSelfGeneratedLicenseTask
extends ClusterStateUpdateTask {
    private int selfGeneratedLicenseMaxNodes = 1000;
    private final Settings settings;
    private final Clock clock;
    private final ClusterService clusterService;
    private final Logger logger;

    public StartupSelfGeneratedLicenseTask(Settings settings, Clock clock, ClusterService clusterService) {
        this.settings = settings;
        this.clock = clock;
        this.clusterService = clusterService;
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (Settings)settings, (String[])new String[0]);
    }

    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        LicensesMetaData licensesMetaData = (LicensesMetaData)newState.metaData().custom("licenses");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("registered self generated license: {}", (Object)licensesMetaData);
        }
    }

    public ClusterState execute(ClusterState currentState) throws Exception {
        XPackPlugin.checkReadyForXPackCustomMetadata(currentState);
        MetaData metaData = currentState.metaData();
        LicensesMetaData currentLicensesMetaData = (LicensesMetaData)metaData.custom("licenses");
        if (currentLicensesMetaData == null) {
            String type = (String)LicenseService.SELF_GENERATED_LICENSE_TYPE.get(this.settings);
            if (!SelfGeneratedLicense.validSelfGeneratedType(type)) {
                throw new IllegalArgumentException("Illegal self generated license type [" + type + "]. Must be trial or basic.");
            }
            return this.updateWithLicense(currentState, type);
        }
        if (LicenseUtils.signatureNeedsUpdate(currentLicensesMetaData.getLicense(), currentState.nodes())) {
            return this.updateLicenseSignature(currentState, currentLicensesMetaData);
        }
        if (LicenseUtils.licenseNeedsExtended(currentLicensesMetaData.getLicense())) {
            return this.extendBasic(currentState, currentLicensesMetaData);
        }
        return currentState;
    }

    private ClusterState updateLicenseSignature(ClusterState currentState, LicensesMetaData currentLicenseMetaData) {
        License license = currentLicenseMetaData.getLicense();
        MetaData.Builder mdBuilder = MetaData.builder((MetaData)currentState.metaData());
        String type = license.type();
        long issueDate = license.issueDate();
        long expiryDate = license.expiryDate();
        if ("basic".equals(type) && expiryDate != LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS) {
            expiryDate = LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS;
        }
        License.Builder specBuilder = License.builder().uid(license.uid()).issuedTo(license.issuedTo()).maxNodes(this.selfGeneratedLicenseMaxNodes).issueDate(issueDate).type(type).expiryDate(expiryDate);
        License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder, currentState.nodes());
        Version trialVersion = currentLicenseMetaData.getMostRecentTrialVersion();
        LicensesMetaData newLicenseMetadata = new LicensesMetaData(selfGeneratedLicense, trialVersion);
        mdBuilder.putCustom("licenses", (MetaData.Custom)newLicenseMetadata);
        this.logger.info("Updating existing license to the new version.\n\nOld license:\n {}\n\n New license:\n{}", (Object)license, (Object)newLicenseMetadata.getLicense());
        return ClusterState.builder((ClusterState)currentState).metaData(mdBuilder).build();
    }

    public void onFailure(String source, @Nullable Exception e) {
        this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
    }

    private ClusterState extendBasic(ClusterState currentState, LicensesMetaData currentLicenseMetadata) {
        License license = currentLicenseMetadata.getLicense();
        MetaData.Builder mdBuilder = MetaData.builder((MetaData)currentState.metaData());
        LicensesMetaData newLicenseMetadata = this.createBasicLicenseFromExistingLicense(currentLicenseMetadata);
        mdBuilder.putCustom("licenses", (MetaData.Custom)newLicenseMetadata);
        this.logger.info("Existing basic license has an expiration. Basic licenses no longer expire.Regenerating license.\n\nOld license:\n {}\n\n New license:\n{}", (Object)license, (Object)newLicenseMetadata.getLicense());
        return ClusterState.builder((ClusterState)currentState).metaData(mdBuilder).build();
    }

    private LicensesMetaData createBasicLicenseFromExistingLicense(LicensesMetaData currentLicenseMetadata) {
        License currentLicense = currentLicenseMetadata.getLicense();
        License.Builder specBuilder = License.builder().uid(currentLicense.uid()).issuedTo(currentLicense.issuedTo()).maxNodes(this.selfGeneratedLicenseMaxNodes).issueDate(currentLicense.issueDate()).type("basic").expiryDate(LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS);
        License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder, currentLicense.version());
        Version trialVersion = currentLicenseMetadata.getMostRecentTrialVersion();
        return new LicensesMetaData(selfGeneratedLicense, trialVersion);
    }

    private ClusterState updateWithLicense(ClusterState currentState, String type) {
        long issueDate = this.clock.millis();
        MetaData.Builder mdBuilder = MetaData.builder((MetaData)currentState.metaData());
        long expiryDate = "basic".equals(type) ? LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS : issueDate + LicenseService.NON_BASIC_SELF_GENERATED_LICENSE_DURATION.getMillis();
        License.Builder specBuilder = License.builder().uid(UUID.randomUUID().toString()).issuedTo(this.clusterService.getClusterName().value()).maxNodes(this.selfGeneratedLicenseMaxNodes).issueDate(issueDate).type(type).expiryDate(expiryDate);
        License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder, currentState.nodes());
        LicensesMetaData licensesMetaData = "trial".equals(type) ? new LicensesMetaData(selfGeneratedLicense, Version.CURRENT) : new LicensesMetaData(selfGeneratedLicense, null);
        mdBuilder.putCustom("licenses", (MetaData.Custom)licensesMetaData);
        return ClusterState.builder((ClusterState)currentState).metaData(mdBuilder).build();
    }
}

