/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFObject;

public class PDFICCBasedColorSpace
extends PDFObject
implements PDFColorSpace {
    private PDFICCStream iccStream;
    private String explicitName;

    public PDFICCBasedColorSpace(String explicitName, PDFICCStream iccStream) {
        this.explicitName = explicitName;
        this.iccStream = iccStream;
    }

    public PDFICCBasedColorSpace(PDFICCStream iccStream) {
        this(null, iccStream);
    }

    public PDFICCStream getICCStream() {
        return this.iccStream;
    }

    public int getNumComponents() {
        return this.iccStream.getICCProfile().getNumComponents();
    }

    public String getName() {
        if (this.explicitName != null) {
            return this.explicitName;
        }
        return "ICC" + this.iccStream.getObjectNumber();
    }

    public boolean isDeviceColorSpace() {
        return false;
    }

    public boolean isRGBColorSpace() {
        return this.getNumComponents() == 3;
    }

    public boolean isCMYKColorSpace() {
        return this.getNumComponents() == 4;
    }

    public boolean isGrayColorSpace() {
        return this.getNumComponents() == 1;
    }

    protected String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getObjectID());
        sb.append("[/ICCBased ").append(this.getICCStream().referencePDF()).append("]");
        sb.append("\nendobj\n");
        return sb.toString();
    }
}

